/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.Flow;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.jetbrains.annotations.Nullable;

public abstract class StorageScanNode<RowT>
extends AbstractNode<RowT> {
    private static final int NOT_WAITING = -1;
    private Queue<RowT> inBuff = new LinkedBlockingQueue<RowT>(512);
    @Nullable
    private final Predicate<RowT> filters;
    @Nullable
    private final Function<RowT, RowT> rowTransformer;
    private int requested;
    private int waiting;
    private boolean inLoop;
    @Nullable
    private Flow.Subscription activeSubscription;
    private boolean dataRequested;

    public StorageScanNode(ExecutionContext<RowT> ctx, @Nullable Predicate<RowT> filters, @Nullable Function<RowT, RowT> rowTransformer) {
        super(ctx);
        assert (ctx.txAttributes() != null) : "Transaction not initialized.";
        this.filters = filters;
        this.rowTransformer = rowTransformer;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (rowsCnt > 0 && this.requested == 0) : "rowsCnt=" + rowsCnt + ", requested=" + this.requested;
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.context().execute(this::push, this::onError);
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        if (this.activeSubscription != null) {
            this.activeSubscription.cancel();
            this.activeSubscription = null;
        }
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.dataRequested = false;
        this.inBuff = new LinkedBlockingQueue<RowT>(512);
        if (this.activeSubscription != null) {
            this.activeSubscription.cancel();
            this.activeSubscription = null;
        }
    }

    protected abstract Flow.Publisher<RowT> scan();

    private void push() throws Exception {
        if (this.isClosed()) {
            return;
        }
        this.checkState();
        if (this.requested > 0 && !this.inBuff.isEmpty()) {
            this.inLoop = true;
            try {
                while (this.requested > 0 && !this.inBuff.isEmpty()) {
                    this.checkState();
                    RowT row = this.inBuff.poll();
                    if (this.filters != null && !this.filters.test(row)) continue;
                    if (this.rowTransformer != null) {
                        row = this.rowTransformer.apply(row);
                    }
                    --this.requested;
                    this.downstream().push(row);
                }
            }
            finally {
                this.inLoop = false;
            }
        }
        if (this.requested > 0 && (this.waiting == 0 || this.activeSubscription == null)) {
            this.requestNextBatch();
        }
        if (this.requested > 0 && this.waiting == -1) {
            if (this.inBuff.isEmpty()) {
                this.requested = 0;
                this.downstream().end();
            } else {
                this.context().execute(this::push, this::onError);
            }
        }
    }

    private void requestNextBatch() {
        Flow.Subscription subscription;
        if (this.waiting == -1) {
            return;
        }
        if (this.waiting == 0) {
            this.waiting = 512 - this.inBuff.size();
        }
        if ((subscription = this.activeSubscription) != null) {
            subscription.request(this.waiting);
        } else if (!this.dataRequested) {
            this.scan().subscribe(new SubscriberImpl());
            this.dataRequested = true;
        } else {
            this.waiting = -1;
        }
    }

    @Override
    public void register(List<Node<RowT>> sources) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        throw new UnsupportedOperationException();
    }

    private class SubscriberImpl
    implements Flow.Subscriber<RowT> {
        private Queue<RowT> inBuffInner;

        private SubscriberImpl() {
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            assert (StorageScanNode.this.activeSubscription == null);
            this.inBuffInner = StorageScanNode.this.inBuff;
            StorageScanNode.this.activeSubscription = subscription;
            subscription.request(StorageScanNode.this.waiting);
        }

        @Override
        public void onNext(RowT row) {
            this.inBuffInner.add(row);
            if (this.inBuffInner.size() == 512) {
                StorageScanNode.this.context().execute(() -> {
                    StorageScanNode.this.waiting = 0;
                    StorageScanNode.this.push();
                }, StorageScanNode.this::onError);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            StorageScanNode.this.context().execute(() -> {
                throw throwable;
            }, StorageScanNode.this::onError);
        }

        @Override
        public void onComplete() {
            StorageScanNode.this.context().execute(() -> {
                StorageScanNode.this.activeSubscription = null;
                StorageScanNode.this.waiting = 0;
                StorageScanNode.this.push();
            }, StorageScanNode.this::onError);
        }
    }
}

