/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParametersDelegate;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;

public class BenchmarkUtils {
    private static final SimpleDateFormat DATE_FMT = new SimpleDateFormat("<HH:mm:ss>");
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("HHmmss");
    public static final String WEIGHT_DELIMITER = ":";
    private static boolean isWin = System.getProperty("os.name").toLowerCase().contains("win");

    public static JCommander jcommander(String[] a, Object args, String programName) {
        JCommander jCommander = new JCommander();
        jCommander.setAcceptUnknownOptions(true);
        jCommander.setProgramName(programName);
        jCommander.addObject(args);
        jCommander.parse(a);
        return jCommander;
    }

    public static String usage(Object args) {
        CompositeParameters cp = new CompositeParameters();
        cp.benchmarkArgs = args == null ? new Object() : args;
        JCommander jCommander = new JCommander();
        jCommander.setAcceptUnknownOptions(true);
        jCommander.addObject((Object)cp);
        StringBuilder sb = new StringBuilder();
        jCommander.usage(sb);
        return sb.toString();
    }

    public static void println(String msg) {
        System.out.println(DATE_FMT.format(new Date()) + '<' + Thread.currentThread().getName() + '>' + "<yardstick> " + msg);
    }

    public static void error(String msg, Throwable err) {
        System.err.println(DATE_FMT.format(new Date()) + '<' + Thread.currentThread().getName() + '>' + "<yardstick> " + msg);
        if (err != null) {
            err.printStackTrace(System.err);
        }
    }

    public static void println(String msg, File f) {
        String name = f.getParent() == null ? "" : f.getParentFile().getName() + File.separator + f.getName();
        System.out.println(DATE_FMT.format(new Date()) + '<' + Thread.currentThread().getName() + '>' + "<yardstick> " + msg + name);
    }

    public static void println(BenchmarkConfiguration cfg, String msg) {
        cfg.output().println(DATE_FMT.format(new Date()) + '<' + Thread.currentThread().getName() + '>' + "<yardstick> " + msg);
    }

    public static void errorHelp(BenchmarkConfiguration cfg, String msg) {
        cfg.error().println("ERROR: " + msg);
        cfg.error().println("Type '--help' for usage.");
    }

    public static void errorHelp(BenchmarkConfiguration cfg, String msg, Throwable t) {
        BenchmarkUtils.errorHelp(cfg, msg);
        if (t != null) {
            t.printStackTrace(cfg.error());
        }
    }

    public static String fixFolderName(String fName) {
        return fName.length() > 200 ? fName.substring(0, 200) : fName;
    }

    public static String description(BenchmarkConfiguration cfg, BenchmarkDriver drv) {
        if (cfg.driverNames() == null || cfg.driverNames().isEmpty() || cfg.descriptions() == null || cfg.descriptions().isEmpty()) {
            return "";
        }
        String simpleName = drv.getClass().getSimpleName();
        for (int i = 0; i < cfg.driverNames().size(); ++i) {
            if (!simpleName.equals(cfg.driverNames().get(i).split(WEIGHT_DELIMITER)[0].trim())) continue;
            if (i > cfg.descriptions().size() - 1) break;
            return cfg.descriptions().get(i);
        }
        return "";
    }

    public static ProcessExecutionResult kill9Server(BenchmarkConfiguration cfg, boolean isDebug) {
        return BenchmarkUtils.executeRemotely(cfg.remoteUser(), cfg.remoteHostName(), isDebug, Collections.singletonList("pkill -9 -f 'Dyardstick.server" + cfg.memberId() + "'"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProcessExecutionResult executeRemotely(String remoteUser, String hostName, boolean isDebug, Iterable<String> cmds) {
        if (isWin) {
            throw new UnsupportedOperationException("Unsupported operation for windows.");
        }
        Tuple<Thread, StringBuffer> t1 = null;
        Tuple<Thread, StringBuffer> t2 = null;
        try {
            StringBuilder log = new StringBuilder("RemoteUser=" + remoteUser + ", hostName=" + hostName).append('\n');
            Process p = Runtime.getRuntime().exec("ssh -o PasswordAuthentication=no " + remoteUser + "@" + hostName);
            try (PrintStream out = new PrintStream(p.getOutputStream(), true);){
                if (isDebug) {
                    t1 = BenchmarkUtils.monitorInputStream(p.getInputStream(), "OUT");
                    t2 = BenchmarkUtils.monitorInputStream(p.getErrorStream(), "ERR");
                }
                for (String cmd : cmds) {
                    log.append("Executing cmd=").append(cmd).append('\n');
                    out.println(cmd);
                }
                out.println("exit");
                p.waitFor();
            }
            ProcessExecutionResult processExecutionResult = new ProcessExecutionResult(p.exitValue(), log.toString(), t1 == null ? "" : ((StringBuffer)((Tuple)t1).val2).toString(), t2 == null ? "" : ((StringBuffer)((Tuple)t2).val2).toString());
            return processExecutionResult;
        }
        catch (Exception err) {
            ProcessExecutionResult processExecutionResult = new ProcessExecutionResult(err);
            return processExecutionResult;
        }
        finally {
            if (isDebug) {
                if (t1 != null && ((Tuple)t1).val1 != null) {
                    ((Thread)((Tuple)t1).val1).interrupt();
                }
                if (t2 != null && ((Tuple)t2).val1 != null) {
                    ((Thread)((Tuple)t2).val1).interrupt();
                }
            }
        }
    }

    private static Tuple<Thread, StringBuffer> monitorInputStream(final InputStream in, String name) {
        final StringBuffer sb = new StringBuffer();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try (BufferedReader input = new BufferedReader(new InputStreamReader(in));){
                    String l;
                    while (!Thread.currentThread().isInterrupted() && (l = input.readLine()) != null) {
                        sb.append(l).append('\n');
                    }
                }
                catch (IOException e) {
                    sb.append(e).append('\n');
                }
            }
        }, name);
        thread.setDaemon(true);
        thread.start();
        return new Tuple<Thread, StringBuffer>(thread, sb);
    }

    public static ProcessExecutionResult startServer(BenchmarkConfiguration cfg, boolean isDebug) {
        List<String> descriptions = cfg.descriptions();
        String descriptrion = descriptions == null || descriptions.isEmpty() ? "" : "_" + descriptions.get(0);
        String now = TIME_FORMATTER.format(new Date());
        String logFile = cfg.logsFolder() + "/" + now + "_id" + cfg.memberId() + "_" + cfg.remoteHostName() + descriptrion + ".log";
        StringBuilder cmdArgs = new StringBuilder();
        for (String arg : cfg.commandLineArguments()) {
            cmdArgs.append(arg).append(' ');
        }
        String java = cfg.customProperties().get("JAVA");
        ArrayList<String> cmds = new ArrayList<String>();
        String curFold = cfg.currentFolder();
        if (curFold != null && !curFold.isEmpty()) {
            cmds.add("cd " + curFold);
        }
        cmds.add("nohup " + java + " " + cfg.customProperties().get("JVM_OPTS") + " -cp " + cfg.customProperties().get("CLASSPATH") + " org.yardstickframework.BenchmarkServerStartUp " + cmdArgs + " > " + logFile + " 2>& 1 &");
        return BenchmarkUtils.executeRemotely(cfg.remoteUser(), cfg.remoteHostName(), isDebug, cmds);
    }

    private BenchmarkUtils() {
    }

    private static class Tuple<T, K> {
        private T val1;
        private K val2;

        Tuple(T val1, K val2) {
            this.val1 = val1;
            this.val2 = val2;
        }
    }

    public static class ProcessExecutionResult {
        private final int exitCode;
        private final String log;
        private final String out;
        private final String err;
        private final Exception e;

        public ProcessExecutionResult(int exitCode, String log, String out, String err) {
            this.exitCode = exitCode;
            this.log = log;
            this.out = out;
            this.err = err;
            this.e = null;
        }

        public ProcessExecutionResult(Exception e) {
            this.exitCode = -1;
            this.out = null;
            this.err = null;
            this.log = null;
            this.e = e;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getLog() {
            return this.log;
        }

        public String getOutput() {
            return this.out;
        }

        public String getErrorOutput() {
            return this.err;
        }

        public Exception getException() {
            return this.e;
        }

        public String toString() {
            return "Result{\nexitCode=" + this.exitCode + '\n' + "log=\n" + this.log + '\n' + "out=\n'" + this.out + '\n' + "err=\n'" + this.err + '\n' + "e=" + this.e + '}';
        }
    }

    private static class CompositeParameters {
        @ParametersDelegate
        private BenchmarkConfiguration cfg = new BenchmarkConfiguration();
        @ParametersDelegate
        private Object benchmarkArgs;

        private CompositeParameters() {
        }
    }
}

