/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.task.TaskExecutionOptions;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteComputeHandler {
    private final GridKernalContext ctx;
    private final ThreadLocal<TaskExecutionOptions> opts;

    public IgniteComputeHandler(IgniteComputeHandler other, Function<TaskExecutionOptions, TaskExecutionOptions> optsTransformer) {
        this(other.ctx, optsTransformer);
        TaskExecutionOptions copy = TaskExecutionOptions.options(other.opts.get());
        this.opts.set(optsTransformer.apply(copy));
    }

    public IgniteComputeHandler(GridKernalContext ctx, Function<TaskExecutionOptions, TaskExecutionOptions> optsTransformer) {
        this.ctx = ctx;
        this.opts = ThreadLocal.withInitial(() -> (TaskExecutionOptions)optsTransformer.apply(TaskExecutionOptions.options()));
    }

    public IgniteInternalFuture<?> affinityRunAsync(String cacheName, Object affKey, IgniteRunnable job) {
        this.guard();
        try {
            A.notNull(affKey, "affKey");
            A.notNull(job, "job");
            CU.validateCacheName(cacheName);
            ComputeTaskInternalFuture<?> computeTaskInternalFuture = this.ctx.closure().affinityRun(Collections.singletonList(cacheName), affKey, (Runnable)job, this.opts.get());
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    public IgniteInternalFuture<?> affinityRunAsync(@NotNull Collection<String> cacheNames, Object affKey, IgniteRunnable job) {
        this.guard();
        try {
            A.notNull(affKey, "affKey");
            A.notNull(job, "job");
            A.ensure(!cacheNames.isEmpty(), "cachesNames mustn't be empty");
            CU.validateCacheNames(cacheNames);
            ComputeTaskInternalFuture<?> computeTaskInternalFuture = this.ctx.closure().affinityRun(cacheNames, affKey, (Runnable)job, this.opts.get());
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    public IgniteInternalFuture<?> affinityRunAsync(@NotNull Collection<String> cacheNames, int partId, IgniteRunnable job) {
        this.guard();
        try {
            A.ensure(partId >= 0, "partId = " + partId);
            A.notNull(job, "job");
            A.ensure(!cacheNames.isEmpty(), "cachesNames mustn't be empty");
            CU.validateCacheNames(cacheNames);
            ComputeTaskInternalFuture<?> computeTaskInternalFuture = this.ctx.closure().affinityRun(cacheNames, partId, (Runnable)job, this.opts.get());
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    public <R> IgniteInternalFuture<R> affinityCallAsync(String cacheName, Object affKey, IgniteCallable<R> job) {
        this.guard();
        try {
            A.notNull(affKey, "affKey");
            A.notNull(job, "job");
            CU.validateCacheName(cacheName);
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.ctx.closure().affinityCall(Collections.singletonList(cacheName), affKey, job, this.opts.get());
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    public <R> IgniteInternalFuture<R> affinityCallAsync(@NotNull Collection<String> cacheNames, Object affKey, IgniteCallable<R> job) {
        this.guard();
        try {
            A.notNull(affKey, "affKey");
            A.notNull(job, "job");
            A.ensure(!cacheNames.isEmpty(), "cachesNames mustn't be empty");
            CU.validateCacheNames(cacheNames);
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.ctx.closure().affinityCall(cacheNames, affKey, job, this.opts.get());
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    public <R> IgniteInternalFuture<R> affinityCallAsync(@NotNull Collection<String> cacheNames, int partId, IgniteCallable<R> job) {
        this.guard();
        try {
            A.ensure(partId >= 0, "partId = " + partId);
            A.notNull(job, "job");
            A.ensure(!cacheNames.isEmpty(), "cachesNames mustn't be empty");
            CU.validateCacheNames(cacheNames);
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.ctx.closure().affinityCall(cacheNames, partId, job, this.opts.get());
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> IgniteInternalFuture<R> executeAsync(String taskName, @Nullable T arg) {
        this.guard();
        try {
            A.notNull(taskName, "taskName");
            ComputeTaskInternalFuture computeTaskInternalFuture = this.ctx.task().execute(taskName, arg, this.opts.get());
            return computeTaskInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> IgniteInternalFuture<R> executeAsync(Class<? extends ComputeTask<T, R>> taskCls, @Nullable T arg) {
        this.guard();
        try {
            A.notNull(taskCls, "taskCls");
            ComputeTaskInternalFuture computeTaskInternalFuture = this.ctx.task().execute(taskCls, arg, this.opts.get());
            return computeTaskInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> ComputeTaskInternalFuture<R> executeAsync(ComputeTask<T, R> task, @Nullable T arg) {
        this.guard();
        try {
            A.notNull(task, "task");
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.ctx.task().execute(task, arg, this.opts.get());
            return computeTaskInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    public IgniteInternalFuture<?> broadcastAsync(IgniteRunnable job) {
        this.guard();
        try {
            A.notNull(job, "job");
            ComputeTaskInternalFuture<?> computeTaskInternalFuture = this.ctx.closure().runAsync(GridClosureCallMode.BROADCAST, job, this.opts.get());
            return computeTaskInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    public <R> IgniteInternalFuture<Collection<R>> broadcastAsync(IgniteCallable<R> job) {
        this.guard();
        try {
            A.notNull(job, "job");
            IgniteInternalFuture<Collection<R>> igniteInternalFuture = this.ctx.closure().callAsync(GridClosureCallMode.BROADCAST, Collections.singletonList(job), this.opts.get());
            return igniteInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, T> IgniteInternalFuture<Collection<R>> broadcastAsync(IgniteClosure<T, R> job, @Nullable T arg) {
        this.guard();
        try {
            A.notNull(job, "job");
            IgniteInternalFuture<Collection<R>> igniteInternalFuture = this.ctx.closure().broadcast(job, arg, this.opts.get());
            return igniteInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    public IgniteInternalFuture<?> runAsync(IgniteRunnable job) {
        this.guard();
        try {
            A.notNull(job, "job");
            ComputeTaskInternalFuture<?> computeTaskInternalFuture = this.ctx.closure().runAsync(GridClosureCallMode.BALANCE, job, this.opts.get());
            return computeTaskInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    public IgniteInternalFuture<?> runAsync(Collection<? extends IgniteRunnable> jobs) {
        this.guard();
        try {
            A.notEmpty(jobs, "jobs");
            ComputeTaskInternalFuture<?> computeTaskInternalFuture = this.ctx.closure().runAsync(GridClosureCallMode.BALANCE, jobs, this.opts.get());
            return computeTaskInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, T> IgniteInternalFuture<R> applyAsync(IgniteClosure<T, R> job, @Nullable T arg) {
        this.guard();
        try {
            A.notNull(job, "job");
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.ctx.closure().callAsync(job, arg, this.opts.get());
            return computeTaskInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    public <R> IgniteInternalFuture<R> callAsync(IgniteCallable<R> job) {
        this.guard();
        try {
            A.notNull(job, "job");
            IgniteInternalFuture<R> igniteInternalFuture = this.ctx.closure().callAsync(GridClosureCallMode.BALANCE, job, this.opts.get());
            return igniteInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    public <R> IgniteInternalFuture<Collection<R>> callAsync(Collection<? extends IgniteCallable<R>> jobs) {
        this.guard();
        try {
            A.notEmpty(jobs, "jobs");
            IgniteInternalFuture igniteInternalFuture = this.ctx.closure().callAsync(GridClosureCallMode.BALANCE, jobs, this.opts.get());
            return igniteInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> IgniteInternalFuture<Collection<R>> applyAsync(IgniteClosure<T, R> job, @Nullable Collection<? extends T> args) {
        this.guard();
        try {
            A.notNull(job, "job");
            A.notNull(args, "args");
            ComputeTaskInternalFuture<Collection<R>> computeTaskInternalFuture = this.ctx.closure().callAsync(job, args, this.opts.get());
            return computeTaskInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R1, R2> IgniteInternalFuture<R2> callAsync(Collection<? extends IgniteCallable<R1>> jobs, IgniteReducer<R1, R2> rdc) {
        this.guard();
        try {
            A.notEmpty(jobs, "jobs");
            A.notNull(rdc, "rdc");
            ComputeTaskInternalFuture<R2> computeTaskInternalFuture = this.ctx.closure().forkjoinAsync(GridClosureCallMode.BALANCE, jobs, rdc, this.opts.get());
            return computeTaskInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R1, R2, T> IgniteInternalFuture<R2> applyAsync(IgniteClosure<T, R1> job, Collection<? extends T> args, IgniteReducer<R1, R2> rdc) {
        this.guard();
        try {
            A.notNull(job, "job");
            A.notNull(rdc, "rdc");
            A.notNull(args, "args");
            ComputeTaskInternalFuture<R2> computeTaskInternalFuture = this.ctx.closure().callAsync(job, args, rdc, this.opts.get());
            return computeTaskInternalFuture;
        }
        finally {
            this.opts.remove();
            this.unguard();
        }
    }

    public IgniteComputeHandler withName(String taskName) {
        A.notNull(taskName, "taskName");
        this.guard();
        try {
            this.opts.get().withName(taskName);
        }
        finally {
            this.unguard();
        }
        return this;
    }

    public IgniteComputeHandler withTimeout(long timeout) {
        A.ensure(timeout >= 0L, "timeout >= 0");
        this.guard();
        try {
            this.opts.get().withTimeout(timeout);
        }
        finally {
            this.unguard();
        }
        return this;
    }

    public IgniteComputeHandler withNoFailover() {
        this.guard();
        try {
            this.opts.get().withFailoverDisabled();
        }
        finally {
            this.unguard();
        }
        return this;
    }

    public IgniteComputeHandler withProjection(Collection<ClusterNode> prj) {
        A.notEmpty(prj, "projection");
        this.guard();
        try {
            this.opts.get().withProjection(prj);
        }
        finally {
            this.unguard();
        }
        return this;
    }

    public IgniteComputeHandler withNoResultCache() {
        this.guard();
        try {
            this.opts.get().withResultCacheDisabled();
        }
        finally {
            this.unguard();
        }
        return this;
    }

    public IgniteComputeHandler withExecutor(String execName) {
        A.notEmpty(execName, "executor name");
        this.guard();
        try {
            this.opts.get().withExecutor(execName);
        }
        finally {
            this.unguard();
        }
        return this;
    }

    public IgniteComputeHandler withProjectionPredicate(IgnitePredicate<ClusterNode> predicate) {
        this.guard();
        try {
            this.opts.get().withProjectionPredicate(predicate);
        }
        finally {
            this.unguard();
        }
        return this;
    }

    public IgniteComputeHandler asPublicRequest() {
        this.guard();
        try {
            this.opts.get().asPublicRequest();
        }
        finally {
            this.unguard();
        }
        return this;
    }

    private void guard() {
        this.ctx.gateway().readLock();
    }

    private void unguard() {
        this.ctx.gateway().readUnlock();
    }
}

