/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheGroupIdMessage;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtAffinityAssignmentRequest
extends GridCacheGroupIdMessage {
    private static final long serialVersionUID = 0L;
    private static final int SND_PART_STATE_MASK = 1;
    private byte flags;
    private long futId;
    private AffinityTopologyVersion topVer;

    public GridDhtAffinityAssignmentRequest() {
    }

    public GridDhtAffinityAssignmentRequest(long futId, int grpId, AffinityTopologyVersion topVer, boolean sndPartMap) {
        assert (topVer != null);
        this.futId = futId;
        this.grpId = grpId;
        this.topVer = topVer;
        if (sndPartMap) {
            this.flags = (byte)(this.flags | 1);
        }
    }

    public boolean sendPartitionsState() {
        return (this.flags & 1) != 0;
    }

    public long futureId() {
        return this.futId;
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public boolean partitionExchangeMessage() {
        return true;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public short directType() {
        return 28;
    }

    @Override
    public byte fieldsCount() {
        return 7;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtAffinityAssignmentRequest.class);
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAffinityAssignmentRequest.class, this, super.toString());
    }
}

