/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.jetbrains.annotations.Nullable;

public class GridCacheReturnCompletableWrapper {
    private static final AtomicReferenceFieldUpdater<GridCacheReturnCompletableWrapper, Object> COMPLETABLE_WRAPPER_UPD = AtomicReferenceFieldUpdater.newUpdater(GridCacheReturnCompletableWrapper.class, Object.class, "o");
    private volatile Object o;
    private final UUID nodeId;

    public GridCacheReturnCompletableWrapper(UUID nodeId) {
        this.nodeId = nodeId;
    }

    @Nullable
    public UUID nodeId() {
        return this.nodeId;
    }

    public void initialize(GridCacheReturn ret) {
        Object obj = this.o;
        if (obj == null) {
            boolean res = COMPLETABLE_WRAPPER_UPD.compareAndSet(this, null, ret);
            if (!res) {
                this.initialize(ret);
            }
        } else if (obj instanceof GridFutureAdapter) {
            ((GridFutureAdapter)obj).onDone(ret);
            boolean res = COMPLETABLE_WRAPPER_UPD.compareAndSet(this, obj, ret);
            assert (res);
        } else {
            throw new IllegalStateException("GridCacheReturnCompletableWrapper can't be reinitialized");
        }
    }

    public IgniteInternalFuture<GridCacheReturn> fut() {
        Object obj = this.o;
        if (obj instanceof GridCacheReturn) {
            return new GridFinishedFuture<GridCacheReturn>((GridCacheReturn)obj);
        }
        if (obj instanceof IgniteInternalFuture) {
            return (IgniteInternalFuture)obj;
        }
        if (obj == null) {
            boolean res = COMPLETABLE_WRAPPER_UPD.compareAndSet(this, null, new GridFutureAdapter());
            if (res) {
                return (IgniteInternalFuture)this.o;
            }
            return this.fut();
        }
        throw new IllegalStateException();
    }
}

