/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.io.entity.ByteBufferEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestByteBufferEntity {
    TestByteBufferEntity() {
    }

    @Test
    void testBasics() throws Exception {
        ByteBuffer bytes = ByteBuffer.wrap("Message content".getBytes(StandardCharsets.US_ASCII));
        try (ByteBufferEntity httpentity = new ByteBufferEntity(bytes, null);){
            Assertions.assertEquals((long)bytes.capacity(), (long)httpentity.getContentLength());
            Assertions.assertNotNull((Object)httpentity.getContent());
            Assertions.assertFalse((boolean)httpentity.isRepeatable());
            Assertions.assertFalse((boolean)httpentity.isStreaming());
        }
    }

    @Test
    void testWriteTo() throws Exception {
        ByteBuffer bytes = ByteBuffer.wrap("Message content".getBytes(StandardCharsets.US_ASCII));
        try (ByteBufferEntity httpentity = new ByteBufferEntity(bytes, null);){
            int i;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            httpentity.writeTo((OutputStream)out);
            byte[] bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)bytes.capacity(), (int)bytes2.length);
            bytes.position(0);
            for (i = 0; i < bytes2.length; ++i) {
                Assertions.assertEquals((byte)bytes.get(i), (byte)bytes2[i]);
            }
            out = new ByteArrayOutputStream();
            httpentity.writeTo((OutputStream)out);
            bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)bytes.capacity(), (int)bytes2.length);
            bytes.position(0);
            for (i = 0; i < bytes.capacity(); ++i) {
                Assertions.assertEquals((byte)bytes.get(i), (byte)bytes2[i]);
            }
            Assertions.assertThrows(NullPointerException.class, () -> httpentity.writeTo(null));
        }
    }
}

