/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.StateEntry;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.ttl.AbstractTtlState;
import org.apache.flink.util.FlinkRuntimeException;

class TtlIncrementalCleanup<K, N, S> {
    @Nonnegative
    private final int cleanupSize;
    private AbstractTtlState<K, N, ?, S, ?> ttlState;
    private InternalKvState.StateIncrementalVisitor<K, N, S> stateIterator;

    TtlIncrementalCleanup(@Nonnegative int cleanupSize) {
        this.cleanupSize = cleanupSize;
    }

    void stateAccessed() {
        this.initIteratorIfNot();
        try {
            this.runCleanup();
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException("Failed to incrementally clean up state with TTL", t);
        }
    }

    private void initIteratorIfNot() {
        if (this.stateIterator == null || !this.stateIterator.hasNext()) {
            this.stateIterator = ((InternalKvState)this.ttlState.original).getStateIncrementalVisitor(this.cleanupSize);
        }
    }

    private void runCleanup() {
        Collection<StateEntry<K, N, S>> nextEntries;
        for (int entryNum = 0; entryNum < this.cleanupSize && this.stateIterator.hasNext() && !(nextEntries = this.stateIterator.nextEntries()).isEmpty(); entryNum += nextEntries.size()) {
            for (StateEntry<K, N, S> state : nextEntries) {
                S cleanState = this.ttlState.getUnexpiredOrNull(state.getState());
                if (cleanState == null) {
                    this.stateIterator.remove(state);
                    continue;
                }
                if (cleanState == state.getState()) continue;
                this.stateIterator.update(state, cleanState);
            }
        }
    }

    public void setTtlState(@Nonnull AbstractTtlState<K, N, ?, S, ?> ttlState) {
        this.ttlState = ttlState;
    }

    int getCleanupSize() {
        return this.cleanupSize;
    }
}

