/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterDelegate;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class MultipleRecordWriters<T extends IOReadableWritable>
implements RecordWriterDelegate<T> {
    private final List<RecordWriter<T>> recordWriters;
    private final CompletableFuture<?>[] futures;

    public MultipleRecordWriters(List<RecordWriter<T>> recordWriters) {
        this.recordWriters = (List)Preconditions.checkNotNull(recordWriters);
        this.futures = new CompletableFuture[recordWriters.size()];
    }

    @Override
    public void broadcastEvent(AbstractEvent event) throws IOException {
        IOException exception = null;
        for (RecordWriter<T> recordWriter : this.recordWriters) {
            try {
                recordWriter.broadcastEvent(event);
            }
            catch (IOException e) {
                exception = (IOException)ExceptionUtils.firstOrSuppressed((Throwable)new IOException("Could not send event to downstream tasks.", e), exception);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public RecordWriter<T> getRecordWriter(int outputIndex) {
        return this.recordWriters.get(outputIndex);
    }

    @Override
    public void setMaxOverdraftBuffersPerGate(int maxOverdraftBuffersPerGate) {
        for (RecordWriter<T> recordWriter : this.recordWriters) {
            recordWriter.setMaxOverdraftBuffersPerGate(maxOverdraftBuffersPerGate);
        }
    }

    @Override
    public CompletableFuture<?> getAvailableFuture() {
        for (int i = 0; i < this.futures.length; ++i) {
            this.futures[i] = this.recordWriters.get(i).getAvailableFuture();
        }
        return CompletableFuture.allOf(this.futures);
    }

    @Override
    public boolean isAvailable() {
        for (RecordWriter<T> recordWriter : this.recordWriters) {
            if (recordWriter.isAvailable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        for (RecordWriter<T> recordWriter : this.recordWriters) {
            recordWriter.close();
        }
    }
}

