/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.util.Preconditions;

public class TaskExecutionStateTransition {
    private final TaskExecutionState taskExecutionState;
    private final boolean cancelTask;
    private final boolean releasePartitions;

    public TaskExecutionStateTransition(TaskExecutionState taskExecutionState) {
        this(taskExecutionState, false, false);
    }

    public TaskExecutionStateTransition(TaskExecutionState taskExecutionState, boolean cancelTask, boolean releasePartitions) {
        this.taskExecutionState = (TaskExecutionState)Preconditions.checkNotNull((Object)taskExecutionState);
        this.cancelTask = cancelTask;
        this.releasePartitions = releasePartitions;
    }

    public Throwable getError(ClassLoader userCodeClassloader) {
        return this.taskExecutionState.getError(userCodeClassloader);
    }

    public ExecutionAttemptID getID() {
        return this.taskExecutionState.getID();
    }

    public ExecutionState getExecutionState() {
        return this.taskExecutionState.getExecutionState();
    }

    public AccumulatorSnapshot getAccumulators() {
        return this.taskExecutionState.getAccumulators();
    }

    public IOMetrics getIOMetrics() {
        return this.taskExecutionState.getIOMetrics();
    }

    public boolean getCancelTask() {
        return this.cancelTask;
    }

    public boolean getReleasePartitions() {
        return this.releasePartitions;
    }
}

