/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.deletefolders;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.actions.deletefolders.FileItem;

@Action(id="DELETE_FOLDERS", name="i18n::ActionDeleteFolders.Name", description="i18n::ActionDeleteFolders.Description", image="DeleteFolders.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionDeleteFolders.keyword"}, documentationUrl="/workflow/actions/deletefolders.html")
public class ActionDeleteFolders
extends ActionBase {
    private static final Class<?> PKG = ActionDeleteFolders.class;
    @HopMetadataProperty(key="arg_from_previous")
    private boolean argFromPrevious;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<FileItem> fileItems;
    @HopMetadataProperty(key="limit_folders")
    private String limitFolders;
    @HopMetadataProperty(key="success_condition", storeWithCode=true)
    private SuccessCondition successCondition;
    int nrErrors = 0;
    int nrSuccess = 0;
    boolean successConditionBroken = false;
    int nrLimitFolders = 0;

    public ActionDeleteFolders() {
        this("");
    }

    public ActionDeleteFolders(String name) {
        super(name, "");
        this.argFromPrevious = false;
        this.fileItems = List.of();
        this.successCondition = SuccessCondition.NO_ERRORS;
        this.limitFolders = "10";
    }

    public ActionDeleteFolders(ActionDeleteFolders other) {
        super(other.getName(), other.getDescription(), other.getPluginId());
        this.argFromPrevious = other.argFromPrevious;
        this.limitFolders = other.limitFolders;
        this.successCondition = other.successCondition;
        this.fileItems = new ArrayList<FileItem>(other.fileItems);
    }

    public Object clone() {
        return new ActionDeleteFolders(this);
    }

    public Result execute(Result result, int nr) throws HopException {
        List rows = result.getRows();
        result.setNrErrors(1L);
        result.setResult(false);
        this.nrErrors = 0;
        this.nrSuccess = 0;
        this.successConditionBroken = false;
        this.nrLimitFolders = Const.toInt((String)this.resolve(this.getLimitFolders()), (int)10);
        if (this.argFromPrevious && this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
        }
        if (this.argFromPrevious && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Error.SuccessConditionBroken", (String[])new String[]{"" + this.nrErrors}));
                    result.setNrErrors((long)this.nrErrors);
                    result.setNrLinesDeleted((long)this.nrSuccess);
                    return result;
                }
                RowMetaAndData resultRow = (RowMetaAndData)rows.get(iteration);
                String argsPrevious = resultRow.getString(0, null);
                if (!Utils.isEmpty((CharSequence)argsPrevious)) {
                    if (this.deleteFolder(argsPrevious)) {
                        this.updateSuccess();
                        continue;
                    }
                    this.updateErrors();
                    continue;
                }
                this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Error.EmptyLine", (String[])new String[0]));
            }
        } else if (this.fileItems != null) {
            for (FileItem item : this.fileItems) {
                if (!this.parentWorkflow.isStopped()) {
                    if (this.successConditionBroken) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Error.SuccessConditionBroken", (String[])new String[]{"" + this.nrErrors}));
                        result.setNrErrors((long)this.nrErrors);
                        result.setNrLinesDeleted((long)this.nrSuccess);
                        return result;
                    }
                    String realFileName = this.resolve(item.getFileName());
                    if (!Utils.isEmpty((CharSequence)realFileName)) {
                        if (this.deleteFolder(realFileName)) {
                            this.updateSuccess();
                            continue;
                        }
                        this.updateErrors();
                        continue;
                    }
                    this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Error.EmptyLine", (String[])new String[0]));
                    continue;
                }
                break;
            }
        }
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Log.Info.NrError", (String[])new String[]{"" + this.nrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Log.Info.NrDeletedFolders", (String[])new String[]{"" + this.nrSuccess}));
            this.logDetailed("=======================================");
        }
        result.setNrErrors((long)this.nrErrors);
        result.setNrLinesDeleted((long)this.nrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        return result;
    }

    private void updateErrors() {
        ++this.nrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        return this.nrErrors > 0 && this.getSuccessCondition() == SuccessCondition.NO_ERRORS || this.nrErrors >= this.nrLimitFolders && this.getSuccessCondition() == SuccessCondition.ERRORS_LESS;
    }

    private void updateSuccess() {
        ++this.nrSuccess;
    }

    private boolean getSuccessStatus() {
        return this.nrErrors == 0 && this.getSuccessCondition() == SuccessCondition.NO_ERRORS || this.nrSuccess >= this.nrLimitFolders && this.getSuccessCondition() == SuccessCondition.AT_LEAST_X_FOLDERS_DELETED || this.nrErrors <= this.nrLimitFolders && this.getSuccessCondition() == SuccessCondition.ERRORS_LESS;
    }

    private boolean deleteFolder(String folderName) {
        boolean rcode = false;
        try (FileObject folder = HopVfs.getFileObject((String)folderName, (IVariables)this.getVariables());){
            if (folder.exists()) {
                if (folder.getType() == FileType.FOLDER) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.ProcessingFolder", (String[])new String[]{folderName}));
                    }
                    int count = folder.delete((FileSelector)new TextFileSelector());
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.TotalDeleted", (String[])new String[]{folderName, String.valueOf(count)}));
                    }
                    rcode = true;
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Error.NotFolder", (String[])new String[]{folder.toString()}));
                }
            } else {
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.FolderAlreadyDeleted", (String[])new String[]{folderName}));
                }
                rcode = true;
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.CouldNotDelete", (String[])new String[]{folderName, e.getMessage()}), e);
        }
        return rcode;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (Utils.isEmpty(this.fileItems)) {
            String message = BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.NrClonesdMissing", (String[])new String[0]);
            remarks.add((ICheckResult)new CheckResult(3, "Any folders to deletes", (ICheckResultSource)this));
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        ResourceReference reference = null;
        for (FileItem item : this.fileItems) {
            String filename = this.resolve(item.getFileName());
            if (reference == null) {
                reference = new ResourceReference((IResourceHolder)this);
                references.add(reference);
            }
            reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    @Generated
    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    @Generated
    public void setArgFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    @Generated
    public List<FileItem> getFileItems() {
        return this.fileItems;
    }

    @Generated
    public void setFileItems(List<FileItem> fileItems) {
        this.fileItems = fileItems;
    }

    @Generated
    public String getLimitFolders() {
        return this.limitFolders;
    }

    @Generated
    public void setLimitFolders(String limitFolders) {
        this.limitFolders = limitFolders;
    }

    @Generated
    public SuccessCondition getSuccessCondition() {
        return this.successCondition;
    }

    @Generated
    public void setSuccessCondition(SuccessCondition successCondition) {
        this.successCondition = successCondition;
    }

    public static enum SuccessCondition implements IEnumHasCodeAndDescription
    {
        NO_ERRORS("success_if_no_errors", BaseMessages.getString(PKG, (String)"ActionDeleteFolders.SuccessWhenAllWorksFine.Label", (String[])new String[0])),
        ERRORS_LESS("success_if_errors_less", BaseMessages.getString(PKG, (String)"ActionDeleteFolders.SuccessWhenErrorsLessThan.Label", (String[])new String[0])),
        AT_LEAST_X_FOLDERS_DELETED("success_when_at_least", BaseMessages.getString(PKG, (String)"ActionDeleteFolders.SuccessWhenAtLeast.Label", (String[])new String[0]));

        private final String code;
        private final String description;

        private SuccessCondition(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(SuccessCondition.class);
        }

        public static SuccessCondition lookupDescription(String description) {
            return (SuccessCondition)IEnumHasCodeAndDescription.lookupDescription(SuccessCondition.class, (String)description, (IEnumHasCodeAndDescription)NO_ERRORS);
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }
    }

    private static class TextFileSelector
    implements FileSelector {
        private TextFileSelector() {
        }

        public boolean includeFile(FileSelectInfo info) {
            return true;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

