/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databaselookup;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.databaselookup.DatabaseLookupMeta;
import org.apache.hop.pipeline.transforms.databaselookup.KeyField;
import org.apache.hop.pipeline.transforms.databaselookup.Lookup;
import org.apache.hop.pipeline.transforms.databaselookup.ReturnValue;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DatabaseLookupDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = DatabaseLookupMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private Button wCache;
    private Label wlCacheLoadAll;
    private Button wCacheLoadAll;
    private Label wlCacheSize;
    private Text wCacheSize;
    private TableView wKey;
    private TextVar wSchema;
    private TextVar wTable;
    private TableView wReturn;
    private Label wlOrderBy;
    private Text wOrderBy;
    private Label wlFailMultiple;
    private Button wFailMultiple;
    private Button wEatRows;
    private final DatabaseLookupMeta input;
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private final List<ColumnInfo> fieldColumns = new ArrayList<ColumnInfo>();
    private IRowMeta prevFields = null;

    public DatabaseLookupDialog(Shell parent, IVariables variables, DatabaseLookupMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    private void addKeysTab(CTabFolder wTabFolder, int margin, ModifyListener lsMod) {
        CTabItem wKeysTab = new CTabItem(wTabFolder, 0);
        wKeysTab.setFont(GuiResource.getInstance().getFontDefault());
        wKeysTab.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.KeysTab.TabTitle", (String[])new String[0]));
        ScrolledComposite wKeySComp = new ScrolledComposite((Composite)wTabFolder, 768);
        wKeySComp.setLayout((Layout)new FillLayout());
        Composite keysComp = new Composite((Composite)wKeySComp, 0);
        PropsUi.setLook((Widget)keysComp);
        FormLayout keysLayout = new FormLayout();
        keysLayout.marginWidth = PropsUi.getFormMargin();
        keysLayout.marginHeight = PropsUi.getFormMargin();
        keysComp.setLayout((Layout)keysLayout);
        Button wGet = new Button(keysComp, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.GetLookupFields.Button", (String[])new String[0]));
        this.setButtonPositions(new Button[]{wGet}, margin, null);
        PropsUi.setLook((Widget)wGet);
        Label wlKey = new Label(keysComp, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Keys.Label", (String[])new String[0]));
        wlKey.setLayoutData((Object)new FormDataBuilder().top().left().build());
        PropsUi.setLook((Widget)wlKey);
        int nrKeyCols = 4;
        int nrKeyRows = this.input.getLookup().getKeyFields().isEmpty() ? 1 : this.input.getLookup().getKeyFields().size();
        ColumnInfo[] ciKey = new ColumnInfo[nrKeyCols];
        ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Tablefield", (String[])new String[0]), 2, new String[]{""}, false);
        ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Comparator", (String[])new String[0]), 2, DatabaseLookupMeta.conditionStrings);
        ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Field1", (String[])new String[0]), 2, new String[]{""}, false);
        ciKey[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Field2", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(ciKey[0]);
        this.fieldColumns.add(ciKey[2]);
        this.fieldColumns.add(ciKey[3]);
        this.wKey = new TableView(this.variables, keysComp, 68354, ciKey, nrKeyRows, lsMod, this.props);
        this.wKey.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 30, 10, 30, 30}));
        this.wKey.setLayoutData((Object)new FormDataBuilder().top((Control)wlKey, margin).bottom((Control)wGet, -margin).fullWidth().build());
        keysComp.pack();
        keysComp.setLayoutData((Object)new FormDataBuilder().fullWidth().build());
        wKeySComp.setContent((Control)keysComp);
        wKeySComp.setExpandHorizontal(true);
        wKeySComp.setExpandVertical(true);
        wKeySComp.setMinWidth(keysComp.getBounds().width);
        wKeySComp.setMinHeight(keysComp.getBounds().height);
        wGet.addListener(13, e -> this.get());
        wKeysTab.setControl((Control)wKeySComp);
    }

    private void addGeneralTab(CTabFolder wTabFolder, int middle, int margin, ModifyListener lsMod) {
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.input.setChanged();
                DatabaseLookupDialog.this.setTableFieldCombo();
            }
        };
        ModifyListener lsTableMod = arg0 -> {
            this.input.setChanged();
            this.setTableFieldCombo();
        };
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.GeneralTab.TabTitle", (String[])new String[0]));
        ScrolledComposite wGeneralSComp = new ScrolledComposite((Composite)wTabFolder, 768);
        wGeneralSComp.setLayout((Layout)new FillLayout());
        Composite fieldGeneralComp = new Composite((Composite)wGeneralSComp, 0);
        PropsUi.setLook((Widget)fieldGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = PropsUi.getFormMargin();
        generalLayout.marginHeight = PropsUi.getFormMargin();
        fieldGeneralComp.setLayout((Layout)generalLayout);
        this.wConnection = this.addConnectionLine(fieldGeneralComp, null, this.input.getConnection(), lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        Label wlSchema = new Label(fieldGeneralComp, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button(fieldGeneralComp, 0x1000008);
        PropsUi.setLook((Widget)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, fieldGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin * 2);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        Label wlTable = new Label(fieldGeneralComp, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Lookuptable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)wbSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button(fieldGeneralComp, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Browse.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, fieldGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)wbSchema, margin);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        Label wlCache = new Label(fieldGeneralComp, 131072);
        wlCache.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Cache.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCache);
        FormData fdlCache = new FormData();
        fdlCache.left = new FormAttachment(0, 0);
        fdlCache.right = new FormAttachment(middle, -margin);
        fdlCache.top = new FormAttachment((Control)this.wTable, margin);
        wlCache.setLayoutData((Object)fdlCache);
        this.wCache = new Button(fieldGeneralComp, 32);
        PropsUi.setLook((Widget)this.wCache);
        FormData fdCache = new FormData();
        fdCache.left = new FormAttachment(middle, 0);
        fdCache.top = new FormAttachment((Control)wlCache, 0, 0x1000000);
        this.wCache.setLayoutData((Object)fdCache);
        this.wCache.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.input.setChanged();
                DatabaseLookupDialog.this.enableFields();
            }
        });
        this.wlCacheSize = new Label(fieldGeneralComp, 131072);
        this.wlCacheSize.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Cachesize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCacheSize);
        this.wlCacheSize.setEnabled(this.input.isCached());
        FormData fdlCachesize = new FormData();
        fdlCachesize.left = new FormAttachment(0, 0);
        fdlCachesize.right = new FormAttachment(middle, -margin);
        fdlCachesize.top = new FormAttachment((Control)this.wCache, margin);
        this.wlCacheSize.setLayoutData((Object)fdlCachesize);
        this.wCacheSize = new Text(fieldGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wCacheSize);
        this.wCacheSize.setEnabled(this.input.isCached());
        this.wCacheSize.addModifyListener(lsMod);
        FormData fdCachesize = new FormData();
        fdCachesize.left = new FormAttachment(middle, 0);
        fdCachesize.right = new FormAttachment(100, 0);
        fdCachesize.top = new FormAttachment((Control)this.wCache, margin);
        this.wCacheSize.setLayoutData((Object)fdCachesize);
        this.wlCacheLoadAll = new Label(fieldGeneralComp, 131072);
        this.wlCacheLoadAll.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.CacheLoadAll.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCacheLoadAll);
        FormData fdlCacheLoadAll = new FormData();
        fdlCacheLoadAll.left = new FormAttachment(0, 0);
        fdlCacheLoadAll.right = new FormAttachment(middle, -margin);
        fdlCacheLoadAll.top = new FormAttachment((Control)this.wCacheSize, margin);
        this.wlCacheLoadAll.setLayoutData((Object)fdlCacheLoadAll);
        this.wCacheLoadAll = new Button(fieldGeneralComp, 32);
        PropsUi.setLook((Widget)this.wCacheLoadAll);
        FormData fdCacheLoadAll = new FormData();
        fdCacheLoadAll.left = new FormAttachment(middle, 0);
        fdCacheLoadAll.top = new FormAttachment((Control)this.wlCacheLoadAll, 0, 0x1000000);
        this.wCacheLoadAll.setLayoutData((Object)fdCacheLoadAll);
        this.wCacheLoadAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.input.setChanged();
                DatabaseLookupDialog.this.enableFields();
            }
        });
        Label wlEatRows = new Label(fieldGeneralComp, 131072);
        wlEatRows.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.EatRows.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEatRows);
        FormData fdlEatRows = new FormData();
        fdlEatRows.left = new FormAttachment(0, 0);
        fdlEatRows.top = new FormAttachment((Control)this.wCacheLoadAll, margin);
        fdlEatRows.right = new FormAttachment(middle, -margin);
        wlEatRows.setLayoutData((Object)fdlEatRows);
        this.wEatRows = new Button(fieldGeneralComp, 32);
        PropsUi.setLook((Widget)this.wEatRows);
        FormData fdEatRows = new FormData();
        fdEatRows.left = new FormAttachment(middle, 0);
        fdEatRows.top = new FormAttachment((Control)wlEatRows, 0, 0x1000000);
        this.wEatRows.setLayoutData((Object)fdEatRows);
        this.wEatRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.input.setChanged();
                DatabaseLookupDialog.this.enableFields();
            }
        });
        this.wlFailMultiple = new Label(fieldGeneralComp, 131072);
        this.wlFailMultiple.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.FailMultiple.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFailMultiple);
        FormData fdlFailMultiple = new FormData();
        fdlFailMultiple.left = new FormAttachment(0, 0);
        fdlFailMultiple.top = new FormAttachment((Control)this.wEatRows, margin);
        fdlFailMultiple.right = new FormAttachment(middle, -margin);
        this.wlFailMultiple.setLayoutData((Object)fdlFailMultiple);
        this.wFailMultiple = new Button(fieldGeneralComp, 32);
        PropsUi.setLook((Widget)this.wFailMultiple);
        FormData fdFailMultiple = new FormData();
        fdFailMultiple.left = new FormAttachment(middle, 0);
        fdFailMultiple.top = new FormAttachment((Control)this.wlFailMultiple, 0, 0x1000000);
        this.wFailMultiple.setLayoutData((Object)fdFailMultiple);
        this.wFailMultiple.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.input.setChanged();
                DatabaseLookupDialog.this.enableFields();
            }
        });
        fieldGeneralComp.setLayoutData((Object)new FormDataBuilder().fullWidth().build());
        fieldGeneralComp.pack();
        Rectangle bounds = fieldGeneralComp.getBounds();
        wGeneralSComp.setContent((Control)fieldGeneralComp);
        wGeneralSComp.setExpandHorizontal(true);
        wGeneralSComp.setExpandVertical(true);
        wGeneralSComp.setMinWidth(bounds.width);
        wGeneralSComp.setMinHeight(bounds.height);
        wbSchema.addListener(13, e -> this.getSchemaName());
        wbTable.addListener(13, e -> this.getTableName());
        wGeneralTab.setControl((Control)wGeneralSComp);
    }

    private void addFieldsTab(CTabFolder wTabFolder, int middle, int margin, ModifyListener lsMod) {
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.FieldsTab.TabTitle", (String[])new String[0]));
        ScrolledComposite wFieldsSComp = new ScrolledComposite((Composite)wTabFolder, 768);
        wFieldsSComp.setLayout((Layout)new FillLayout());
        Composite fieldFieldsComp = new Composite((Composite)wFieldsSComp, 0);
        PropsUi.setLook((Widget)fieldFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = PropsUi.getFormMargin();
        fieldsLayout.marginHeight = PropsUi.getFormMargin();
        fieldFieldsComp.setLayout((Layout)fieldsLayout);
        Label wlReturn = new Label(fieldFieldsComp, 0);
        wlReturn.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Return.Label", (String[])new String[0]));
        wlReturn.setLayoutData((Object)new FormDataBuilder().top().left().build());
        PropsUi.setLook((Widget)wlReturn);
        Button wGetLU = new Button(fieldFieldsComp, 8);
        wGetLU.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.GetFields.Button", (String[])new String[0]));
        wGetLU.addListener(13, e -> this.getlookup());
        PropsUi.setLook((Widget)wGetLU);
        this.setButtonPositions(new Button[]{wGetLU}, margin, null);
        this.wOrderBy = new Text(fieldFieldsComp, 18436);
        this.wOrderBy.setLayoutData((Object)new FormDataBuilder().bottom((Control)wGetLU, -margin).fullWidth().build());
        this.wOrderBy.addModifyListener(lsMod);
        PropsUi.setLook((Widget)this.wOrderBy);
        this.wlOrderBy = new Label(fieldFieldsComp, 16384);
        this.wlOrderBy.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Orderby.Label", (String[])new String[0]));
        this.wlOrderBy.setLayoutData((Object)new FormDataBuilder().bottom((Control)this.wOrderBy, -margin).fullWidth().build());
        PropsUi.setLook((Widget)this.wlOrderBy);
        int upInsCols = 5;
        int upInsRows = this.input.getLookup().getReturnValues().isEmpty() ? 1 : this.input.getLookup().getReturnValues().size();
        ColumnInfo[] ciReturn = new ColumnInfo[upInsCols];
        ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Field", (String[])new String[0]), 2, new String[0], false);
        ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Newname", (String[])new String[0]), 1, false);
        ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Default", (String[])new String[0]), 1, false);
        ciReturn[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames());
        ciReturn[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.TrimTypeColumn.Column", (String[])new String[0]), 2, ValueMetaBase.trimTypeDesc, true);
        this.tableFieldColumns.add(ciReturn[0]);
        this.wReturn = new TableView(this.variables, fieldFieldsComp, 68354, ciReturn, upInsRows, lsMod, this.props);
        this.wReturn.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 30, 30, 15, 15, 10}));
        this.wReturn.setLayoutData((Object)new FormDataBuilder().top((Control)wlReturn, margin).bottom((Control)this.wlOrderBy, -margin * 2).fullWidth().build());
        fieldFieldsComp.setLayoutData((Object)new FormDataBuilder().fullWidth().build());
        fieldFieldsComp.pack();
        Rectangle bounds = fieldFieldsComp.getBounds();
        wFieldsSComp.setContent((Control)fieldFieldsComp);
        wFieldsSComp.setExpandHorizontal(true);
        wFieldsSComp.setExpandVertical(true);
        wFieldsSComp.setMinWidth(bounds.width);
        wFieldsSComp.setMinHeight(bounds.height);
        wFieldsTab.setControl((Control)wFieldsSComp);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOk);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wCancel);
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        this.addGeneralTab(wTabFolder, middle, margin, lsMod);
        this.addKeysTab(wTabFolder, margin, lsMod);
        this.addFieldsTab(wTabFolder, middle, margin, lsMod);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.setInputFieldCombo();
        this.setTableFieldCombo();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setInputFieldCombo() {
        this.shell.getDisplay().asyncExec(() -> {
            try {
                this.prevFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            }
            catch (HopException e) {
                this.prevFields = null;
            }
            if (this.prevFields == null) {
                new RowMeta();
                String msg = BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.DoMapping.UnableToFindInput", (String[])new String[0]);
                this.logError(msg);
            } else {
                String[] fieldNames = Const.sortStrings((String[])this.prevFields.getFieldNames());
                for (ColumnInfo colInfo : this.fieldColumns) {
                    colInfo.setComboValues(fieldNames);
                }
            }
        });
    }

    private void setTableFieldCombo() {
        this.shell.getDisplay().asyncExec(() -> {
            block11: {
                if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                    DatabaseMeta databaseMeta;
                    String tableName = this.wTable.getText();
                    String connectionName = this.wConnection.getText();
                    String schemaName = this.wSchema.getText();
                    if (!Utils.isEmpty((CharSequence)tableName) && (databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables)) != null) {
                        try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                            String[] fieldNames;
                            database.connect();
                            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.variables, schemaName, tableName);
                            IRowMeta rowMeta = database.getTableFields(schemaTable);
                            if (null == rowMeta || null == (fieldNames = Const.sortStrings((String[])rowMeta.getFieldNames()))) break block11;
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                        catch (Exception e) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                    }
                }
            }
        });
    }

    private void enableFields() {
        this.wlOrderBy.setEnabled(!this.wFailMultiple.getSelection());
        this.wOrderBy.setEnabled(!this.wFailMultiple.getSelection());
        this.wCacheSize.setEnabled(this.wCache.getSelection() && !this.wCacheLoadAll.getSelection());
        this.wlCacheSize.setEnabled(this.wCache.getSelection() && !this.wCacheLoadAll.getSelection());
        this.wCacheLoadAll.setEnabled(this.wCache.getSelection());
        this.wlCacheLoadAll.setEnabled(this.wCache.getSelection());
        this.wFailMultiple.setEnabled(!this.wCache.getSelection());
        this.wlFailMultiple.setEnabled(!this.wCache.getSelection());
    }

    public void getData() {
        TableItem item;
        int i;
        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Log.GettingKeyInfo", (String[])new String[0]));
        this.wCache.setSelection(this.input.isCached());
        this.wCacheSize.setText("" + this.input.getCacheSize());
        this.wCacheLoadAll.setSelection(this.input.isLoadingAllDataInCache());
        Lookup lookup = this.input.getLookup();
        for (i = 0; i < lookup.getKeyFields().size(); ++i) {
            KeyField keyField = lookup.getKeyFields().get(i);
            item = this.wKey.table.getItem(i);
            item.setText(1, Const.NVL((String)keyField.getTableField(), (String)""));
            item.setText(2, Const.NVL((String)keyField.getCondition(), (String)""));
            item.setText(3, Const.NVL((String)keyField.getStreamField1(), (String)""));
            item.setText(4, Const.NVL((String)keyField.getStreamField2(), (String)""));
        }
        for (i = 0; i < lookup.getReturnValues().size(); ++i) {
            ReturnValue returnValue = lookup.getReturnValues().get(i);
            item = this.wReturn.table.getItem(i);
            item.setText(1, Const.NVL((String)returnValue.getTableField(), (String)""));
            item.setText(2, Const.NVL((String)returnValue.getNewName(), (String)""));
            item.setText(3, Const.NVL((String)returnValue.getDefaultValue(), (String)""));
            item.setText(4, Const.NVL((String)returnValue.getDefaultType(), (String)""));
            item.setText(5, Const.NVL((String)ValueMetaBase.getTrimTypeDesc((int)ValueMetaBase.getTrimTypeByCode((String)returnValue.getTrimType())), (String)ValueMetaBase.trimTypeCode[0]));
        }
        this.wSchema.setText(Const.NVL((String)this.input.getSchemaName(), (String)""));
        this.wTable.setText(Const.NVL((String)this.input.getTableName(), (String)""));
        if (!Utils.isEmpty((CharSequence)this.input.getConnection())) {
            this.wConnection.setText(this.input.getConnection());
        }
        this.wOrderBy.setText(Const.NVL((String)lookup.getOrderByClause(), (String)""));
        this.wFailMultiple.setSelection(lookup.isFailingOnMultipleResults());
        this.wEatRows.setSelection(lookup.isEatingRowOnLookupFailure());
        this.wKey.optimizeTableView();
        this.wReturn.optimizeTableView();
        this.enableFields();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        Lookup lookup = this.input.getLookup();
        lookup.getKeyFields().clear();
        lookup.getReturnValues().clear();
        this.input.setCached(this.wCache.getSelection());
        this.input.setCacheSize(Const.toInt((String)this.wCacheSize.getText(), (int)0));
        this.input.setLoadingAllDataInCache(this.wCacheLoadAll.getSelection());
        for (TableItem item : this.wKey.getNonEmptyItems()) {
            KeyField keyField = new KeyField();
            keyField.setTableField(item.getText(1));
            keyField.setCondition(item.getText(2));
            keyField.setStreamField1(item.getText(3));
            keyField.setStreamField2(item.getText(4));
            lookup.getKeyFields().add(keyField);
        }
        for (TableItem item : this.wReturn.getNonEmptyItems()) {
            ReturnValue returnValue = new ReturnValue();
            returnValue.setTableField(item.getText(1));
            returnValue.setNewName(item.getText(2));
            returnValue.setDefaultValue(item.getText(3));
            returnValue.setDefaultType(item.getText(4));
            returnValue.setTrimType(ValueMetaBase.getTrimTypeCode((int)ValueMetaBase.getTrimTypeByDesc((String)item.getText(5))));
            lookup.getReturnValues().add(returnValue);
        }
        lookup.setSchemaName(this.wSchema.getText());
        lookup.setTableName(this.wTable.getText());
        this.input.setConnection(this.wConnection.getText());
        lookup.setOrderByClause(this.wOrderBy.getText());
        lookup.setFailingOnMultipleResults(this.wFailMultiple.getSelection());
        lookup.setEatingRowOnLookupFailure(this.wEatRows.getSelection());
        this.transformName = this.wTransformName.getText();
        if (this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables);
        if (databaseMeta != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Log.LookingAtConnection", (String[])new String[0]) + String.valueOf(databaseMeta));
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(2, "=");
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wKey, (int)1, (int[])new int[]{1, 3}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.GetFieldsFailed.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.GetFieldsFailed.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getlookup() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                if (!Utils.isEmpty((CharSequence)this.wTable.getText())) {
                    String schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.variables, this.wSchema.getText(), this.wTable.getText());
                    IRowMeta r = database.getTableFields(schemaTable);
                    if (r != null && !r.isEmpty()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Log.FoundTableFields", (String[])new String[0]) + schemaTable + " --> " + r.toStringMeta());
                        BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{4}, (int)-1, (int)-1, null);
                    } else {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.CouldNotReadTableInfo.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.CouldNotReadTableInfo.DialogTitle", (String[])new String[0]));
                        mb.open();
                    }
                }
            }
            catch (HopException e) {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ErrorOccurred.DialogMessage", (String[])new String[0]) + Const.CR + e.getMessage());
                mb.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ErrorOccurred.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.InvalidConnectionName.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.InvalidConnectionName.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void getSchemaName() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
        }
    }
}

