/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.bfs;

import org.psjava.algo.graph.bfs.BFSVisitor;
import org.psjava.algo.graph.bfs.SimpleStopper;
import org.psjava.ds.graph.DirectedEdge;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.queue.Queue;
import org.psjava.ds.set.MutableSet;
import org.psjava.goods.GoodMutableSetFactory;
import org.psjava.goods.GoodQueueFactory;

public class BFS {
    public static <V, E extends DirectedEdge<V>> void traverse(Graph<V, E> adj, Iterable<V> startVertices, BFSVisitor<V, E> visitor) {
        MutableSet discovered = GoodMutableSetFactory.getInstance().create();
        SimpleStopper stopper = new SimpleStopper();
        Queue queue = GoodQueueFactory.getInstance().create();
        for (V v : startVertices) {
            queue.enque(new QueueItem<V>(0, v));
            discovered.add(v);
            visitor.onDiscover(v, 0, stopper);
            if (!stopper.isStopped()) continue;
            break;
        }
        block1: while (!queue.isEmpty() && !stopper.isStopped()) {
            QueueItem cur = (QueueItem)queue.deque();
            for (DirectedEdge edge : adj.getEdges(cur.v)) {
                Object nextv = edge.to();
                if (discovered.contains(nextv)) continue;
                discovered.add(nextv);
                visitor.onWalk(edge);
                visitor.onDiscover(nextv, cur.depth + 1, stopper);
                if (stopper.isStopped()) continue block1;
                queue.enque(new QueueItem(cur.depth + 1, nextv));
            }
        }
    }

    private BFS() {
    }

    private static class QueueItem<V> {
        int depth;
        V v;

        QueueItem(int depth, V v) {
            this.depth = depth;
            this.v = v;
        }
    }
}

