/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.openid;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.openid.OpenIdError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class UserInfoError {
    public static final UserInfoError OTHER = new UserInfoError().withTag(Tag.OTHER);
    private Tag _tag;
    private OpenIdError openidErrorValue;

    private UserInfoError() {
    }

    private UserInfoError withTag(Tag _tag) {
        UserInfoError result = new UserInfoError();
        result._tag = _tag;
        return result;
    }

    private UserInfoError withTagAndOpenidError(Tag _tag, OpenIdError openidErrorValue) {
        UserInfoError result = new UserInfoError();
        result._tag = _tag;
        result.openidErrorValue = openidErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isOpenidError() {
        return this._tag == Tag.OPENID_ERROR;
    }

    public static UserInfoError openidError(OpenIdError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UserInfoError().withTagAndOpenidError(Tag.OPENID_ERROR, value);
    }

    public OpenIdError getOpenidErrorValue() {
        if (this._tag != Tag.OPENID_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.OPENID_ERROR, but was Tag." + this._tag.name());
        }
        return this.openidErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.openidErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UserInfoError) {
            UserInfoError other = (UserInfoError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case OPENID_ERROR: {
                    return this.openidErrorValue == other.openidErrorValue || this.openidErrorValue.equals((Object)other.openidErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<UserInfoError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserInfoError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case OPENID_ERROR: {
                    g.writeStartObject();
                    this.writeTag("openid_error", g);
                    g.writeFieldName("openid_error");
                    OpenIdError.Serializer.INSTANCE.serialize(value.openidErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public UserInfoError deserialize(JsonParser p) throws IOException, JsonParseException {
            UserInfoError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("openid_error".equals(tag)) {
                OpenIdError fieldValue = null;
                Serializer.expectField("openid_error", p);
                fieldValue = OpenIdError.Serializer.INSTANCE.deserialize(p);
                value = UserInfoError.openidError(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        OPENID_ERROR,
        OTHER;

    }
}

