/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.workflow.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.IExecutionConfiguration;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ConfigurationDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.shared.AuditManagerGuiUtil;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.config.IWorkflowEngineRunConfiguration;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engines.local.LocalWorkflowRunConfiguration;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class WorkflowExecutionConfigurationDialog
extends ConfigurationDialog {
    private static final Class<?> PKG = WorkflowExecutionConfigurationDialog.class;
    public static final String AUDIT_LIST_TYPE_LAST_USED_RUN_CONFIGURATIONS = "last-workflow-run-configurations";
    public static final String MAP_TYPE_WORKFLOW_RUN_CONFIG_USAGE = "workflow-run-configuration-usage";
    private CCombo wStartAction;
    private MetaSelectionLine<WorkflowRunConfiguration> wRunConfiguration;

    public WorkflowExecutionConfigurationDialog(Shell parent, WorkflowExecutionConfiguration configuration, WorkflowMeta workflowMeta) {
        super(parent, (IExecutionConfiguration)configuration, (AbstractMeta)workflowMeta);
    }

    @Override
    protected void optionsSectionControls() {
        this.wlLogLevel = new Label((Composite)this.gDetails, 131072);
        this.wlLogLevel.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.LogLevel.Label", (String[])new String[0]));
        this.wlLogLevel.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.LogLevel.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLogLevel);
        FormData fdlLogLevel = new FormData();
        fdlLogLevel.top = new FormAttachment(0, 0);
        fdlLogLevel.left = new FormAttachment(0, 0);
        this.wlLogLevel.setLayoutData((Object)fdlLogLevel);
        this.wLogLevel = new CCombo((Composite)this.gDetails, 2056);
        this.wLogLevel.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.LogLevel.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wLogLevel);
        FormData fdLogLevel = new FormData();
        fdLogLevel.top = new FormAttachment((Control)this.wlLogLevel, -2, 128);
        fdLogLevel.right = new FormAttachment(100, 0);
        fdLogLevel.left = new FormAttachment((Control)this.wlLogLevel, 6);
        this.wLogLevel.setLayoutData((Object)fdLogLevel);
        this.wLogLevel.setItems(LogLevel.getLogLevelDescriptions());
        this.wClearLog = new Button((Composite)this.gDetails, 32);
        this.wClearLog.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.ClearLog.Label", (String[])new String[0]));
        this.wClearLog.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.ClearLog.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wClearLog);
        FormData fdClearLog = new FormData();
        fdClearLog.top = new FormAttachment((Control)this.wLogLevel, 10);
        fdClearLog.left = new FormAttachment(0, 0);
        this.wClearLog.setLayoutData((Object)fdClearLog);
        Label wlStartAction = new Label((Composite)this.gDetails, 131072);
        wlStartAction.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.StartCopy.Label", (String[])new String[0]));
        wlStartAction.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.StartCopy.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStartAction);
        FormData fdlStartAction = new FormData();
        fdlStartAction.top = new FormAttachment((Control)this.wClearLog, 10);
        fdlStartAction.left = new FormAttachment(0, 0);
        wlStartAction.setLayoutData((Object)fdlStartAction);
        this.wStartAction = new CCombo((Composite)this.gDetails, 2056);
        this.wStartAction.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.StartCopy.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wStartAction);
        FormData fdStartActionAction = new FormData();
        fdStartActionAction.top = new FormAttachment((Control)wlStartAction, 0, 0x1000000);
        fdStartActionAction.left = new FormAttachment((Control)wlStartAction, PropsUi.getMargin());
        fdStartActionAction.right = new FormAttachment(100, 0);
        this.wStartAction.setLayoutData((Object)fdStartActionAction);
        WorkflowMeta workflowMeta = (WorkflowMeta)this.abstractMeta;
        String[] names = new String[workflowMeta.getActions().size()];
        for (int i = 0; i < names.length; ++i) {
            ActionMeta actionMeta = (ActionMeta)workflowMeta.getActions().get(i);
            names[i] = actionMeta.getName();
        }
        this.wStartAction.setItems(names);
    }

    public boolean open() {
        String shellTitle = BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.Shell.Title", (String[])new String[0]);
        this.mainLayout(shellTitle, GuiResource.getInstance().getImageWorkflow());
        this.addRunConfigurationSectionLayout();
        String alwaysShowOptionLabel = BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.AlwaysOption.Value", (String[])new String[0]);
        String alwaysShowOptionTooltip = BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.alwaysShowOption", (String[])new String[0]);
        String docUrl = Const.getDocUrl((String)BaseMessages.getString(HopGui.class, (String)"HopGui.WorkflowExecutionConfigurationDialog.Help", (String[])new String[0]));
        String docTitle = BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.docTitle", (String[])new String[0]);
        String docHeader = BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.docHeader", (String[])new String[0]);
        this.buttonsSectionLayout(alwaysShowOptionLabel, alwaysShowOptionTooltip, docTitle, docUrl, docHeader);
        this.optionsSectionLayout(PKG, "WorkflowExecutionConfigurationDialog");
        this.parametersSectionLayout(PKG, "WorkflowExecutionConfigurationDialog");
        this.getData();
        this.openDialog();
        return this.retval;
    }

    private void addRunConfigurationSectionLayout() {
        String runConfigLabel = BaseMessages.getString(PKG, (String)"ConfigurationDialog.RunConfiguration.Label", (String[])new String[0]);
        String runConfigTooltip = BaseMessages.getString(PKG, (String)"ConfigurationDialog.RunConfiguration.Tooltip", (String[])new String[0]);
        this.wRunConfiguration = new MetaSelectionLine<WorkflowRunConfiguration>(this.hopGui.getVariables(), (IHopMetadataProvider)this.hopGui.getMetadataProvider(), WorkflowRunConfiguration.class, (Composite)this.shell, 2048, runConfigLabel, runConfigTooltip, true);
        this.wRunConfigurationControl = this.wRunConfiguration;
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.right = new FormAttachment(100, 0);
        fdRunConfiguration.top = new FormAttachment(0, PropsUi.getMargin());
        fdRunConfiguration.left = new FormAttachment(0, 0);
        this.wRunConfiguration.setLayoutData(fdRunConfiguration);
    }

    private void getVariablesData() {
        this.wVariables.clearAll(false);
        ArrayList variableNames = new ArrayList(this.configuration.getVariablesMap().keySet());
        Collections.sort(variableNames);
        ArrayList paramNames = new ArrayList(this.configuration.getParametersMap().keySet());
        for (String variableName : variableNames) {
            String variableValue = (String)this.configuration.getVariablesMap().get(variableName);
            if (paramNames.contains(variableName)) continue;
            TableItem tableItem = new TableItem(this.wVariables.table, 0);
            tableItem.setText(1, variableName);
            tableItem.setText(2, Const.NVL((String)variableValue, (String)""));
        }
        this.wVariables.removeEmptyRows();
        this.wVariables.setRowNums();
        this.wVariables.optWidth(true);
    }

    public void getData() {
        ActionMeta action;
        this.wClearLog.setSelection(this.configuration.isClearingLog());
        try {
            this.wRunConfiguration.fillItems();
            if (Const.indexOfString((String)this.configuration.getRunConfiguration(), (String[])this.wRunConfiguration.getItems()) < 0) {
                this.getConfiguration().setRunConfiguration(null);
            }
        }
        catch (Exception e) {
            this.hopGui.getLog().logError("Unable to obtain a list of workflow run configurations", (Throwable)e);
        }
        Map<String, String> workflowUsageMap = null;
        String lastGlobalRunConfig = AuditManagerGuiUtil.getLastUsedValue(AUDIT_LIST_TYPE_LAST_USED_RUN_CONFIGURATIONS);
        String selectedRunConfig = null;
        if (StringUtils.isNotEmpty((String)this.abstractMeta.getName())) {
            workflowUsageMap = AuditManagerGuiUtil.getUsageMap(MAP_TYPE_WORKFLOW_RUN_CONFIG_USAGE);
            selectedRunConfig = workflowUsageMap.get(this.abstractMeta.getName());
        }
        if (StringUtils.isEmpty(selectedRunConfig)) {
            WorkflowRunConfiguration defaultRunConfig = null;
            try {
                defaultRunConfig = WorkflowRunConfiguration.findDefault((IHopMetadataProvider)this.hopGui.getMetadataProvider());
            }
            catch (HopException e) {
                LogChannel.UI.logError("Error finding default workflow run configuration", (Throwable)e);
            }
            if (defaultRunConfig != null) {
                selectedRunConfig = defaultRunConfig.getName();
            }
        }
        this.wRunConfiguration.setText(Const.NVL(selectedRunConfig, (String)""));
        if (StringUtils.isNotEmpty((String)selectedRunConfig) && StringUtils.isNotEmpty((String)lastGlobalRunConfig) && !selectedRunConfig.equals(lastGlobalRunConfig)) {
            this.wRunConfiguration.getLabelWidget().setBackground(GuiResource.getInstance().getColorLightBlue());
            this.wRunConfiguration.getLabelWidget().setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.VerifyRunConfigurationName.Warning", (String[])new String[0]));
            this.wRunConfiguration.getComboWidget().setBackground(GuiResource.getInstance().getColorLightBlue());
            this.wRunConfiguration.getComboWidget().setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.VerifyRunConfigurationName.Warning", (String[])new String[0]));
        }
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.hopGui.getVariables(), (String)HopExtensionPoint.HopGuiRunConfiguration.id, this.wRunConfiguration);
        }
        catch (HopException defaultRunConfig) {
            // empty catch block
        }
        if (StringUtil.isEmpty((String)this.wRunConfiguration.getText())) {
            if (StringUtils.isNotEmpty((String)this.getConfiguration().getRunConfiguration())) {
                this.wRunConfiguration.setText(this.getConfiguration().getRunConfiguration());
            } else if (this.wRunConfiguration.getItemCount() == 1) {
                this.wRunConfiguration.select(0);
            }
        }
        String startAction = "";
        if (!Utils.isEmpty((CharSequence)this.getConfiguration().getStartActionName()) && (action = ((WorkflowMeta)this.abstractMeta).findAction(this.getConfiguration().getStartActionName())) != null) {
            startAction = action.getName();
        }
        this.wStartAction.setText(startAction);
        if (workflowUsageMap != null && workflowUsageMap.containsKey("LOG_LEVEL")) {
            this.wLogLevel.select(Integer.parseInt(workflowUsageMap.get("LOG_LEVEL")));
        } else {
            this.wLogLevel.select(this.configuration.getLogLevel().getLevel());
        }
        this.getParamsData();
        this.getVariablesData();
    }

    @Override
    public boolean getInfo() {
        try {
            String runConfigurationName;
            IHopMetadataSerializer serializer = this.hopGui.getMetadataProvider().getSerializer(WorkflowRunConfiguration.class);
            if (serializer.listObjectNames().isEmpty()) {
                String name = WorkflowExecutionConfigurationDialog.createLocalWorkflowConfiguration(this.shell, (IHopMetadataSerializer<WorkflowRunConfiguration>)serializer);
                this.wRunConfiguration.setText(name);
            }
            if (StringUtils.isEmpty((String)(runConfigurationName = this.wRunConfiguration.getText()))) {
                MessageBox box = new MessageBox(this.shell, 34);
                box.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.NoRunConfigurationSpecified.Title", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.NoRunConfigurationSpecified.Message", (String[])new String[0]));
                box.open();
                return false;
            }
            if (!serializer.exists(this.hopGui.getVariables().resolve(runConfigurationName))) {
                MessageBox box = new MessageBox(this.shell, 33);
                box.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.RunConfigurationDoesNotExist.Title", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.RunConfigurationDoesNotExist.Message", (String[])new String[]{runConfigurationName}));
                box.open();
                return false;
            }
            this.getConfiguration().setRunConfiguration(runConfigurationName);
            AuditManagerGuiUtil.addLastUsedValue(AUDIT_LIST_TYPE_LAST_USED_RUN_CONFIGURATIONS, runConfigurationName);
            if (StringUtils.isNotEmpty((String)this.abstractMeta.getName())) {
                Map<String, String> usageMap = AuditManagerGuiUtil.getUsageMap(MAP_TYPE_WORKFLOW_RUN_CONFIG_USAGE);
                usageMap.put(this.abstractMeta.getName(), runConfigurationName);
                usageMap.put("LOG_LEVEL", String.valueOf(this.wLogLevel.getSelectionIndex()));
                AuditManagerGuiUtil.saveUsageMap(MAP_TYPE_WORKFLOW_RUN_CONFIG_USAGE, usageMap);
            }
            this.configuration.setClearingLog(this.wClearLog.getSelection());
            this.configuration.setLogLevel(LogLevel.values()[this.wLogLevel.getSelectionIndex()]);
            String startActionName = null;
            if (!Utils.isEmpty((CharSequence)this.wStartAction.getText()) && this.wStartAction.getSelectionIndex() >= 0) {
                ActionMeta action = (ActionMeta)((WorkflowMeta)this.abstractMeta).getActions().get(this.wStartAction.getSelectionIndex());
                startActionName = action.getName();
            }
            this.getConfiguration().setStartActionName(startActionName);
            this.getInfoParameters();
            this.getInfoVariables();
            return true;
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error in settings", "There is an error in the dialog settings", e);
            return false;
        }
    }

    public static final String createLocalWorkflowConfiguration(Shell shell, IHopMetadataSerializer<WorkflowRunConfiguration> prcSerializer) {
        try {
            MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 196);
            box.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.NoRunConfigurationDefined.Title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.NoRunConfigurationDefined.Message", (String[])new String[0]));
            int answer = box.open();
            if ((answer & 0x40) != 0) {
                LocalWorkflowRunConfiguration localWorkflowRunConfiguration = new LocalWorkflowRunConfiguration();
                localWorkflowRunConfiguration.setEnginePluginId("Local");
                WorkflowRunConfiguration local = new WorkflowRunConfiguration("local", BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.LocalRunConfiguration.Description", (String[])new String[0]), null, (IWorkflowEngineRunConfiguration)localWorkflowRunConfiguration, true);
                prcSerializer.save((IHopMetadata)local);
                return local.getName();
            }
        }
        catch (Exception e) {
            new ErrorDialog(shell, BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.ErrorSavingRunConfiguration.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WorkflowExecutionConfigurationDialog.ErrorSavingRunConfiguration.Message", (String[])new String[0]), e);
        }
        return null;
    }

    public WorkflowExecutionConfiguration getConfiguration() {
        return (WorkflowExecutionConfiguration)this.configuration;
    }
}

