/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.delay;

import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.delay.Delay;
import org.apache.hop.pipeline.transforms.delay.DelayData;

@Transform(id="Delay", image="delay.svg", name="i18n::Delay.Name", description="i18n::Delay.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::DelayMeta.keyword"}, documentationUrl="/pipeline/transforms/delay.html")
public class DelayMeta
extends BaseTransformMeta<Delay, DelayData> {
    private static final Class<?> PKG = DelayMeta.class;
    @HopMetadataProperty(key="timeout", injectionKeyDescription="Delay.Injection.Timeout")
    private String timeout;
    @HopMetadataProperty(key="timeout_field", injectionKeyDescription="Delay.Injection.TimeoutField")
    private String timeoutField;
    @HopMetadataProperty(key="scaletime", injectionKeyDescription="Delay.Injection.Scaletime")
    private String scaletime;
    @HopMetadataProperty(key="scaletime_from_field", injectionKeyDescription="Delay.Injection.ScaleTimeFromField")
    private boolean scaleTimeFromField;
    @HopMetadataProperty(key="scaletime_field", injectionKeyDescription="Delay.Injection.ScaleTimeField")
    private String scaleTimeField;
    private static final String DEFAULT_SCALE_TIME = "seconds";
    private static final String[] SCALE_TIME_CODE = new String[]{"milliseconds", "seconds", "minutes", "hours"};

    public Object clone() {
        return super.clone();
    }

    public void setTimeoutField(String timeoutField) {
        this.timeoutField = Utils.isEmpty((CharSequence)timeoutField) ? null : timeoutField;
    }

    public void setScaleTimeCode(int scaleTimeIndex) {
        switch (scaleTimeIndex) {
            case 0: {
                this.scaletime = SCALE_TIME_CODE[0];
                break;
            }
            case 1: {
                this.scaletime = SCALE_TIME_CODE[1];
                break;
            }
            case 2: {
                this.scaletime = SCALE_TIME_CODE[2];
                break;
            }
            case 3: {
                this.scaletime = SCALE_TIME_CODE[3];
                break;
            }
            default: {
                this.scaletime = SCALE_TIME_CODE[1];
            }
        }
    }

    public int getScaleTimeCode() {
        int retval = 1;
        if (this.scaletime == null) {
            return retval;
        }
        if (this.scaletime.equals(SCALE_TIME_CODE[0])) {
            retval = 0;
        } else if (this.scaletime.equals(SCALE_TIME_CODE[1])) {
            retval = 1;
        } else if (this.scaletime.equals(SCALE_TIME_CODE[2])) {
            retval = 2;
        } else if (this.scaletime.equals(SCALE_TIME_CODE[3])) {
            retval = 3;
        }
        return retval;
    }

    public void setScaleTimeField(String scaleTimeField) {
        this.scaleTimeField = Utils.isEmpty((CharSequence)scaleTimeField) ? null : scaleTimeField;
    }

    public void setDefault() {
        this.timeout = "1";
        this.scaletime = DEFAULT_SCALE_TIME;
        this.timeoutField = null;
        this.scaleTimeFromField = false;
        this.scaleTimeField = null;
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (Utils.isEmpty((CharSequence)this.timeout) && Utils.isEmpty((CharSequence)this.timeoutField)) {
            errorMessage = BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.TimeOutMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.TimeOutOk", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
        }
        remarks.add((ICheckResult)cr);
        cr = prev == null || prev.isEmpty() ? new CheckResult(3, BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.TransformRecevingData", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (prev != null && !prev.isEmpty()) {
            if (!Utils.isEmpty((CharSequence)this.timeoutField) && prev.indexOfValue(this.timeoutField) < 0) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.TimeoutFieldNotFound", (String[])new String[]{this.timeoutField}), (ICheckResultSource)transformMeta));
            }
            if (this.scaleTimeFromField) {
                if (Utils.isEmpty((CharSequence)this.scaleTimeField)) {
                    remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.ScaleTimeFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta));
                } else if (prev.indexOfValue(this.scaleTimeField) < 0) {
                    remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.ScaleTimeFieldNotFound", (String[])new String[]{this.scaleTimeField}), (ICheckResultSource)transformMeta));
                }
            }
        }
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getTimeoutField() {
        return this.timeoutField;
    }

    @Generated
    public String getScaletime() {
        return this.scaletime;
    }

    @Generated
    public boolean isScaleTimeFromField() {
        return this.scaleTimeFromField;
    }

    @Generated
    public String getScaleTimeField() {
        return this.scaleTimeField;
    }

    @Generated
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setScaletime(String scaletime) {
        this.scaletime = scaletime;
    }

    @Generated
    public void setScaleTimeFromField(boolean scaleTimeFromField) {
        this.scaleTimeFromField = scaleTimeFromField;
    }
}

