/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat.internals;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.anthropic.AnthropicChatModel;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.huggingface.DedicatedEndpointHuggingFaceChatModel;
import dev.langchain4j.model.huggingface.HuggingFaceChatModel;
import dev.langchain4j.model.mistralai.MistralAiChatModel;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.output.Response;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transforms.languagemodelchat.LanguageModelChatMeta;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.BaseMessage;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.LanguageModel;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.Message;

public class LanguageModelFacade {
    private final LanguageModelChatMeta meta;
    private final JsonAdapter<List<Message>> inputJsonAdapter;
    private final JsonAdapter<List<BaseMessage>> outputJsonAdapter;
    private final LanguageModel lm;
    private final IVariables variables;
    private ChatLanguageModel model;

    public LanguageModelFacade(IVariables variables, LanguageModelChatMeta meta) {
        this.variables = variables;
        this.meta = (LanguageModelChatMeta)((Object)meta.clone());
        this.lm = new LanguageModel(meta);
        this.inputJsonAdapter = new Moshi.Builder().build().adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{Message.class}));
        this.outputJsonAdapter = new Moshi.Builder().build().adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{BaseMessage.class}));
    }

    private void createModel() {
        switch (this.lm.getType()) {
            case OPEN_AI: {
                this.model = this.createOpenAiModel();
                break;
            }
            case ANTHROPIC: {
                this.model = this.createAnthropicModel();
                break;
            }
            case OLLAMA: {
                this.model = this.createOllamaModel();
                break;
            }
            case MISTRAL: {
                this.model = this.createMistralModel();
                break;
            }
            case HUGGING_FACE: {
                this.model = this.createHuggingFaceModel();
            }
        }
    }

    private String resolve(String param) {
        return this.variables.resolve(StringUtils.trimToNull((String)param));
    }

    private ChatLanguageModel createOpenAiModel() {
        String baseUrl = this.resolve(this.meta.getOpenAiBaseUrl());
        String apiKey = StringUtils.trimToNull((String)this.resolve(this.meta.getOpenAiApiKey()));
        apiKey = StringUtils.isBlank((CharSequence)apiKey) ? StringUtils.trimToNull((String)System.getenv(this.meta.getOpenAiApiKey())) : apiKey;
        String organizationId = this.resolve(this.meta.getOpenAiOrganizationId());
        String modelName = this.resolve(this.meta.getOpenAiModelName());
        String responseFormat = this.resolve(this.meta.getOpenAiResponseFormat());
        String user = this.resolve(this.meta.getOpenAiUser());
        Double temperature = this.meta.getOpenAiTemperature();
        Double topP = this.meta.getOpenAiTopP();
        Double presencePenalty = this.meta.getOpenAiPresencePenalty();
        Double frequencyPenalty = this.meta.getOpenAiFrequencyPenalty();
        Integer maxTokens = this.meta.getOpenAiMaxTokens();
        Integer seed = this.meta.getOpenAiSeed();
        Integer timeout = this.meta.getOpenAiTimeout();
        Integer maxRetries = this.meta.getOpenAiMaxRetries();
        boolean logRequests = this.meta.isOpenAiLogRequests();
        boolean logResponses = this.meta.isOpenAiLogResponses();
        OpenAiChatModel.OpenAiChatModelBuilder builder = OpenAiChatModel.builder().baseUrl(baseUrl).apiKey(apiKey).organizationId(organizationId).modelName(modelName).temperature(temperature).topP(topP).maxTokens(maxTokens).presencePenalty(presencePenalty).frequencyPenalty(frequencyPenalty).responseFormat(responseFormat).seed(seed).user(user).timeout(timeout == null ? null : Duration.ofSeconds(timeout.intValue())).maxRetries(maxRetries).logRequests(Boolean.valueOf(logRequests)).logResponses(Boolean.valueOf(logResponses));
        if (this.meta.isOpenAiUseProxy()) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.meta.getOpenAiProxyHost(), (int)this.meta.getOpenAiProxyPort())));
        }
        return builder.build();
    }

    private ChatLanguageModel createHuggingFaceModel() {
        String modelResource = this.resolve(this.meta.getHuggingFaceModelId());
        boolean dedicated = StringUtils.startsWithIgnoreCase((CharSequence)modelResource, (CharSequence)"http://") || StringUtils.startsWithIgnoreCase((CharSequence)modelResource, (CharSequence)"https://");
        String accessToken = StringUtils.trimToNull((String)this.resolve(this.meta.getHuggingFaceAccessToken()));
        accessToken = StringUtils.isBlank((CharSequence)accessToken) ? StringUtils.trimToNull((String)System.getenv(this.meta.getHuggingFaceAccessToken())) : accessToken;
        Integer timeout = this.meta.getHuggingFaceTimeout();
        Double temperature = this.meta.getHuggingFaceTemperature();
        Integer maxNewTokens = this.meta.getHuggingFaceMaxNewTokens();
        boolean returnFullText = this.meta.isHuggingFaceReturnFullText();
        boolean waitForModel = this.meta.isHuggingFaceWaitForModel();
        if (dedicated) {
            return DedicatedEndpointHuggingFaceChatModel.builder().accessToken(accessToken).endpointUrl(modelResource).timeout(timeout == null ? null : Duration.ofSeconds(timeout.intValue())).temperature(temperature).maxNewTokens(maxNewTokens).returnFullText(returnFullText).waitForModel(waitForModel).build();
        }
        return HuggingFaceChatModel.builder().accessToken(accessToken).modelId(modelResource).timeout(timeout == null ? null : Duration.ofSeconds(timeout.intValue())).temperature(temperature).maxNewTokens(maxNewTokens).returnFullText(Boolean.valueOf(returnFullText)).waitForModel(Boolean.valueOf(waitForModel)).build();
    }

    private ChatLanguageModel createOllamaModel() {
        String imageEndpoint;
        String modelName = this.resolve(this.meta.getOllamaModelName());
        if (StringUtils.isBlank((CharSequence)modelName)) {
            modelName = "phi3";
        }
        if (StringUtils.isBlank((CharSequence)(imageEndpoint = this.resolve(this.meta.getOllamaImageEndpoint())))) {
            switch (modelName) {
                case "mistral": 
                case "llama3": 
                case "llama2": 
                case "codellama": 
                case "phi": 
                case "orca-mini": 
                case "tinyllama": {
                    imageEndpoint = String.format("langchain4j/ollama-%s:latest", modelName);
                    break;
                }
                default: {
                    imageEndpoint = "ollama/ollama";
                }
            }
        }
        Double temperature = this.meta.getOllamaTemperature();
        Double topP = this.meta.getOllamaTopP();
        Integer topK = this.meta.getOllamaTopK();
        Double repeatPenalty = this.meta.getOllamaRepeatPenalty();
        Integer seed = this.meta.getOllamaSeed();
        Integer numPredict = this.meta.getOllamaNumPredict();
        Integer numCtx = this.meta.getOllamaNumCtx();
        String format = this.meta.getOllamaFormat();
        Integer timeout = this.meta.getOllamaTimeout();
        Integer maxRetries = this.meta.getOllamaMaxRetries();
        return OllamaChatModel.builder().baseUrl(imageEndpoint).modelName(modelName).temperature(temperature).topP(topP).topK(topK).repeatPenalty(repeatPenalty).seed(seed).numPredict(numPredict).numCtx(numCtx).format(format).timeout(timeout == null ? null : Duration.ofSeconds(timeout.intValue())).maxRetries(maxRetries).build();
    }

    private ChatLanguageModel createAnthropicModel() {
        String baseUrl = this.resolve(this.meta.getAnthropicBaseUrl());
        String apiKey = StringUtils.trimToNull((String)this.resolve(this.meta.getAnthropicApiKey()));
        apiKey = StringUtils.isBlank((CharSequence)apiKey) ? StringUtils.trimToNull((String)System.getenv(this.meta.getAnthropicApiKey())) : apiKey;
        String version = this.resolve(this.meta.getAnthropicVersion());
        String modelName = this.resolve(this.meta.getAnthropicModelName());
        Double temperature = this.meta.getAnthropicTemperature();
        Double topP = this.meta.getAnthropicTopP();
        Integer topK = this.meta.getAnthropicTopK();
        Integer maxTokens = this.meta.getAnthropicMaxTokens();
        Integer timeout = this.meta.getAnthropicTimeout();
        Integer maxRetries = this.meta.getAnthropicMaxRetries();
        boolean logRequests = this.meta.isAnthropicLogRequests();
        boolean logResponses = this.meta.isAnthropicLogResponses();
        return AnthropicChatModel.builder().baseUrl(baseUrl).apiKey(apiKey).version(version).modelName(modelName).temperature(temperature).topP(topP).topK(topK).maxTokens(maxTokens).timeout(timeout == null ? null : Duration.ofSeconds(timeout.intValue())).maxRetries(maxRetries).logRequests(Boolean.valueOf(logRequests)).logResponses(Boolean.valueOf(logResponses)).build();
    }

    private ChatLanguageModel createMistralModel() {
        String baseUrl = this.resolve(this.meta.getMistralBaseUrl());
        String apiKey = StringUtils.trimToNull((String)this.resolve(this.meta.getMistralApiKey()));
        apiKey = StringUtils.isBlank((CharSequence)apiKey) ? StringUtils.trimToNull((String)System.getenv(this.meta.getMistralApiKey())) : apiKey;
        String modelName = this.resolve(this.meta.getMistralModelName());
        Double temperature = this.meta.getMistralTemperature();
        Double topP = this.meta.getMistralTopP();
        Integer maxTokens = this.meta.getMistralMaxTokens();
        Integer randomSeed = this.meta.getMistralRandomSeed();
        String responseFormat = this.resolve(this.meta.getMistralResponseFormat());
        Integer timeout = this.meta.getMistralTimeout();
        Integer maxRetries = this.meta.getMistralMaxRetries();
        boolean safePrompt = this.meta.isMistralSafePrompt();
        boolean logRequests = this.meta.isMistralLogRequests();
        boolean logResponses = this.meta.isMistralLogResponses();
        return MistralAiChatModel.builder().baseUrl(baseUrl).apiKey(apiKey).modelName(modelName).temperature(temperature).topP(topP).maxTokens(maxTokens).safePrompt(Boolean.valueOf(safePrompt)).randomSeed(randomSeed).responseFormat(responseFormat).timeout(timeout == null ? null : Duration.ofSeconds(timeout.intValue())).logRequests(Boolean.valueOf(logRequests)).logResponses(Boolean.valueOf(logResponses)).maxRetries(maxRetries).build();
    }

    public String messagesToOutput(List<ChatMessage> chat, String assistant) {
        String systemRoleName = "system";
        String userRoleName = "user";
        String assistantRoleName = "assistant";
        ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
        for (ChatMessage c : chat) {
            String text = c.text();
            switch (c.type()) {
                case SYSTEM: {
                    messages.add(new BaseMessage(systemRoleName, text));
                    break;
                }
                case USER: {
                    messages.add(new BaseMessage(userRoleName, text));
                    break;
                }
                case AI: {
                    messages.add(new BaseMessage(assistantRoleName, text));
                }
            }
        }
        messages.add(new BaseMessage(assistantRoleName, assistant));
        return this.outputJsonAdapter.toJson(messages);
    }

    public List<Message> readMessagesJson(String json) throws HopValueException {
        try {
            return (List)this.inputJsonAdapter.fromJson(json);
        }
        catch (Exception e) {
            throw new HopValueException((Throwable)e);
        }
    }

    public List<ChatMessage> inputToChatMessages(String input) throws HopValueException {
        input = StringUtils.trimToNull((String)input);
        Validate.notNull((Object)input, (String)"Message is not set", (Object[])new Object[0]);
        ArrayList<ChatMessage> messageList = new ArrayList<ChatMessage>();
        if (this.meta.isInputChatJson()) {
            List<Message> messages = this.readMessagesJson(input);
            Validate.isTrue((!messages.isEmpty() ? 1 : 0) != 0, (String)("No messages were read from the json: " + input), (Object[])new Object[0]);
            List<ChatMessage> chatMessages = Message.toChatMessages(messages);
            Validate.isTrue((!chatMessages.isEmpty() ? 1 : 0) != 0, (String)("No valid chat messages were read from the json: " + input), (Object[])new Object[0]);
            messageList.addAll(chatMessages);
        } else {
            messageList.add((ChatMessage)UserMessage.userMessage((String)input));
        }
        return messageList;
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.model().generate(messages);
    }

    public ChatLanguageModel model() {
        if (this.model == null) {
            this.createModel();
        }
        return this.model;
    }
}

