/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.search.BaseMetadataSearchableAnalyser;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.SearchableAnalyserPlugin;

@SearchableAnalyserPlugin(id="DatabaseMetaSearchableAnalyser", name="Search in relational database metadata")
public class DatabaseMetaSearchableAnalyser
extends BaseMetadataSearchableAnalyser<DatabaseMeta>
implements ISearchableAnalyser<DatabaseMeta> {
    @Override
    public Class<DatabaseMeta> getSearchableClass() {
        return DatabaseMeta.class;
    }

    public List<ISearchResult> search(ISearchable<DatabaseMeta> searchable, ISearchQuery searchQuery) {
        DatabaseMeta databaseMeta = (DatabaseMeta)searchable.getSearchableObject();
        ArrayList<ISearchResult> results = new ArrayList<ISearchResult>();
        this.matchProperty(searchable, results, searchQuery, "database name", databaseMeta.getName(), null);
        this.matchObjectFields(searchable, results, searchQuery, databaseMeta.getIDatabase(), "database '" + databaseMeta.getName() + "' property", this.getMetadataComponent());
        return results;
    }
}

