/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.singlestore;

import java.sql.DatabaseMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.metadata.api.HopMetadataProperty;

@DatabaseMetaPlugin(type="SINGLESTORE", typeDescription="SingleStore (MemSQL)", documentationUrl="/database/databases/singlestore.html")
@GuiPlugin(id="GUI-SingleStoreDatabaseMeta")
public class SingleStoreDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public static final String CONST_ALTER_TABLE = "ALTER TABLE ";
    private static final int VARCHAR_LIMIT = 21844;
    @GuiWidgetElement(id="singleStoreConnectionMode", order="10", parentId="DatabaseMeta-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::SingleStoreDatabaseMeta.label.ConnectionMode", toolTip="i18n::SingleStoreDatabaseMeta.toolTip.ConnectionMode")
    @HopMetadataProperty(key="connectionMode")
    private String connectionMode;

    public String getExtraOptionSeparator() {
        return "&";
    }

    public String getExtraOptionIndicator() {
        return "?";
    }

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 3306;
        }
        return -1;
    }

    public String getDriverClass() {
        return "com.singlestore.jdbc.Driver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        Object url = "jdbc:singlestore:";
        if (StringUtils.isNotEmpty((String)this.connectionMode)) {
            url = (String)url + this.connectionMode;
        }
        url = (String)url + "//" + hostname + ":" + port + "/" + databaseName;
        return url;
    }

    public boolean isFetchSizeSupported() {
        return true;
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public boolean isSupportsSynonyms() {
        return false;
    }

    public boolean isSupportsSequences() {
        return false;
    }

    public boolean isSupportsSequenceNoMaxValueOption() {
        return false;
    }

    public boolean isStreamingResults() {
        return false;
    }

    public boolean isSupportsAutoInc() {
        return true;
    }

    public String getLimitClause(int nrRows) {
        return " limit " + nrRows;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + this.getLimitClause(1);
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnName, String tableName) {
        return this.getSqlQueryColumnFields(columnName, tableName);
    }

    public String getSqlQueryColumnFields(String columnName, String tableName) {
        return "SELECT " + columnName + " FROM " + tableName + this.getLimitClause(1);
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoIncrement, true, false);
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " DROP COLUMN " + v.getName();
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoIncrement, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoIncrement, boolean addFieldName, boolean addCR) {
        Object fieldClause = "";
        String fieldName = v.getName();
        if (v.getLength() == 9999999) {
            v.setLength(this.getMaxTextFieldLength());
        }
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            fieldClause = (String)fieldClause + fieldName + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                fieldClause = (String)fieldClause + "DATETIME(6)";
                break;
            }
            case 4: {
                if (this.isSupportsBooleanDataType()) {
                    fieldClause = (String)fieldClause + "BOOLEAN";
                    break;
                }
                fieldClause = (String)fieldClause + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldName.equalsIgnoreCase(tk) || fieldName.equalsIgnoreCase(pk)) {
                    if (useAutoIncrement) {
                        fieldClause = (String)fieldClause + "BIGINT AUTO_INCREMENT NOT NULL PRIMARY KEY";
                        break;
                    }
                    fieldClause = (String)fieldClause + "BIGINT NOT NULL PRIMARY KEY";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            fieldClause = (String)fieldClause + "BIGINT";
                            break;
                        }
                        fieldClause = (String)fieldClause + "DECIMAL(" + length + ")";
                        break;
                    }
                    fieldClause = (String)fieldClause + "INT";
                    break;
                }
                if (length > 15) {
                    fieldClause = (String)fieldClause + "DECIMAL(" + length;
                    if (precision > 0) {
                        fieldClause = (String)fieldClause + ", " + precision;
                    }
                    fieldClause = (String)fieldClause + ")";
                    break;
                }
                fieldClause = (String)fieldClause + "DOUBLE";
                break;
            }
            case 2: {
                if (length > 0) {
                    if (length == 1) {
                        fieldClause = (String)fieldClause + "CHAR(1)";
                        break;
                    }
                    if (length < 21844) {
                        fieldClause = (String)fieldClause + "VARCHAR(" + length + ")";
                        break;
                    }
                    if (length < 65536) {
                        fieldClause = (String)fieldClause + "TEXT";
                        break;
                    }
                    if (length < 0x1000000) {
                        fieldClause = (String)fieldClause + "MEDIUMTEXT";
                        break;
                    }
                    fieldClause = (String)fieldClause + "LONGTEXT";
                    break;
                }
                fieldClause = (String)fieldClause + "TINYTEXT";
                break;
            }
            case 8: {
                fieldClause = (String)fieldClause + "VARBINARY";
                break;
            }
            default: {
                fieldClause = (String)fieldClause + " UNKNOWN";
            }
        }
        if (addCR) {
            fieldClause = (String)fieldClause + Const.CR;
        }
        return fieldClause;
    }

    public String[] getReservedWords() {
        return new String[]{"ADD", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOTH", "BY", "CALL", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "CONDITION", "CONNECTION", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DATABASES", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELAYED", "DELETE", "DESC", "DESCRIBE", "DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE", "DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "ENCLOSED", "ESCAPED", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH", "FLOAT", "FOR", "FORCE", "FOREIGN", "FROM", "FULLTEXT", "GOTO", "GRANT", "GROUP", "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF", "IGNORE", "IN", "INDEX", "INFILE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERVAL", "INTO", "IS", "ITERATE", "JOIN", "KEY", "KEYS", "KILL", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LINES", "LOAD", "LOCALTIME", "LOCALTIMESTAMP", "LOCATE", "LOCK", "LONG", "LONGBLOB", "LONGTEXT", "LOOP", "LOW_PRIORITY", "MATCH", "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NOT", "NO_WRITE_TO_BINLOG", "NULL", "NUMERIC", "ON", "OPTIMIZE", "OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "POSITION", "PRECISION", "PRIMARY", "PROCEDURE", "PURGE", "READ", "READS", "REAL", "REFERENCES", "REGEXP", "RENAME", "REPEAT", "REPLACE", "REQUIRE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "RLIKE", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SELECT", "SENSITIVE", "SEPARATOR", "SET", "SHOW", "SMALLINT", "SONAME", "SPATIAL", "SPECIFIC", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT", "SSL", "STARTING", "STRAIGHT_JOIN", "TABLE", "TERMINATED", "THEN", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK", "UNSIGNED", "UPDATE", "USAGE", "USE", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARYING", "WHEN", "WHERE", "WHILE", "WITH", "WRITE", "XOR", "YEAR_MONTH", "ZEROFILL"};
    }

    public String getStartQuote() {
        return "`";
    }

    public String getEndQuote() {
        return "`";
    }

    public String getSqlLockTables(String[] tableNames) {
        StringBuilder sql = new StringBuilder("LOCK TABLES ");
        for (int i = 0; i < tableNames.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(tableNames[i]).append(" WRITE");
        }
        sql.append(";").append(Const.CR);
        return sql.toString();
    }

    public String getSqlUnlockTables(String[] tableName) {
        return "UNLOCK TABLES";
    }

    public String getExtraOptionsHelpText() {
        return "https://docs.singlestore.com/cloud/developer-resources/connect-with-application-development-tools/connect-with-java-jdbc/the-singlestore-jdbc-driver/";
    }

    public boolean isSystemTable(String tableName) {
        return tableName.startsWith("sys") || tableName.equals("dtproperties");
    }

    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + keyField + ", " + versionField + ") values (1, 1)";
    }

    public String quoteSqlString(String string) {
        string = string.replace("'", "\\\\'");
        string = string.replace("\\n", "\\\\n");
        string = string.replace("\\r", "\\\\r");
        return "'" + string + "'";
    }

    public boolean isMySqlVariant() {
        return true;
    }

    public String getLegacyColumnName(DatabaseMetaData dbMetaData, ResultSetMetaData rsMetaData, int index) throws HopDatabaseException {
        try {
            return rsMetaData.getColumnName(index);
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Error retrieving column index " + index + " from SingleStore result set", (Throwable)e);
        }
    }

    public int getNotFoundTK(boolean useAutoIncrement) {
        if (useAutoIncrement) {
            return 1;
        }
        return 0;
    }

    public boolean IsSupportsErrorHandlingOnBatchUpdates() {
        return true;
    }

    public boolean isRequiringTransactionsOnQueries() {
        return false;
    }

    public void addDefaultOptions() {
        this.addExtraOption(this.getPluginId(), "defaultFetchSize", "500");
        this.setSupportsTimestampDataType(true);
        this.setSupportsBooleanDataType(true);
    }

    public int getMaxVARCHARLength() {
        return 21844;
    }

    public int getMaxTextFieldLength() {
        return Integer.MAX_VALUE;
    }

    @Generated
    public void setConnectionMode(String connectionMode) {
        this.connectionMode = connectionMode;
    }

    @Generated
    public String getConnectionMode() {
        return this.connectionMode;
    }
}

