/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.List;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.projects.config.ProjectsConfig;

public class ProjectsConfigSingleton {
    private static ProjectsConfigSingleton configSingleton;
    private ProjectsConfig projectsConfig;

    private ProjectsConfigSingleton() {
        Object configObject = HopConfig.getInstance().getConfigMap().get("projectsConfig");
        if (configObject == null) {
            this.projectsConfig = new ProjectsConfig();
        } else {
            try {
                ObjectMapper mapper = HopJson.newMapper();
                this.projectsConfig = (ProjectsConfig)mapper.readValue(new Gson().toJson(configObject), ProjectsConfig.class);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error reading environments configuration, check property 'projectsConfig' in the Hop config json file", (Throwable)e);
                this.projectsConfig = new ProjectsConfig();
            }
        }
        HopConfig.getInstance().getConfigMap().put("projectsConfig", this.projectsConfig);
    }

    public static ProjectsConfigSingleton getInstance() {
        return configSingleton;
    }

    public static ProjectsConfig getConfig() {
        if (configSingleton == null) {
            configSingleton = new ProjectsConfigSingleton();
        }
        return ProjectsConfigSingleton.configSingleton.projectsConfig;
    }

    public static void saveConfig() throws HopException {
        HopConfig.getInstance().saveOption("projectsConfig", (Object)ProjectsConfigSingleton.configSingleton.projectsConfig);
        HopConfig.getInstance().saveToFile();
    }

    public List<String> listProjectNames() {
        return this.projectsConfig.listProjectConfigNames();
    }

    public List<String> listEnvironmentNames() {
        return this.projectsConfig.listEnvironmentNames();
    }
}

