/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.loginfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfo;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoData;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoField;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoTypes;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="GetLoggingInfo", name="i18n::GetLoggingInfoDialog.DialogTitle", description="i18n::GetLoggingInfoDialog.Description", categoryDescription="Neo4j", image="systeminfo.svg", keywords={"i18n::GetLoggingInfoMeta.keyword"}, documentationUrl="/pipeline/transforms/neo4j-getloginfo.html")
public class GetLoggingInfoMeta
extends BaseTransformMeta<GetLoggingInfo, GetLoggingInfoData> {
    private static final Class<?> PKG = GetLoggingInfoMeta.class;
    public static final String CONST_SPACES = "        ";
    @HopMetadataProperty(key="field", groupKey="fields", injectionKey="FIELD", injectionGroupKey="FIELDS")
    private List<GetLoggingInfoField> fields = new ArrayList<GetLoggingInfoField>();

    public Object clone() {
        GetLoggingInfoMeta retval = (GetLoggingInfoMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.fields = new ArrayList<GetLoggingInfoField>();
        GetLoggingInfoField f1 = new GetLoggingInfoField();
        f1.setFieldName("startOfPipelineDelta");
        f1.setFieldType(GetLoggingInfoTypes.TYPE_SYSTEM_INFO_PIPELINE_DATE_FROM.getCode());
        this.fields.add(f1);
        GetLoggingInfoField f2 = new GetLoggingInfoField();
        f2.setFieldName("endOfPipelineDelta");
        f2.setFieldType(GetLoggingInfoTypes.TYPE_SYSTEM_INFO_PIPELINE_DATE_TO.getCode());
        this.fields.add(f2);
        GetLoggingInfoField f3 = new GetLoggingInfoField();
        f3.setFieldName("startOfWorkflowDelta");
        f3.setFieldType(GetLoggingInfoTypes.TYPE_SYSTEM_INFO_WORKFLOW_DATE_TO.getCode());
        this.fields.add(f3);
        GetLoggingInfoField f4 = new GetLoggingInfoField();
        f4.setFieldName("endOfWorkflowDelta");
        f4.setFieldType(GetLoggingInfoTypes.TYPE_SYSTEM_INFO_WORKFLOW_DATE_TO.getCode());
        this.fields.add(f4);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables space, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (GetLoggingInfoField field : this.fields) {
            ValueMetaDate v = switch (GetLoggingInfoTypes.getTypeFromString(field.getFieldType())) {
                case GetLoggingInfoTypes.TYPE_SYSTEM_INFO_PIPELINE_DATE_FROM, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_PIPELINE_DATE_TO, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_WORKFLOW_DATE_FROM, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_WORKFLOW_DATE_TO, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_PIPELINE_PREVIOUS_EXECUTION_DATE, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_PIPELINE_PREVIOUS_SUCCESS_DATE, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_WORKFLOW_PREVIOUS_EXECUTION_DATE, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_WORKFLOW_PREVIOUS_SUCCESS_DATE -> new ValueMetaDate(field.getFieldName());
                default -> new ValueMetaNone(field.getFieldName());
            };
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables space, IHopMetadataProvider metadataProvider) {
        int nrRemarks = remarks.size();
        for (GetLoggingInfoField field : this.fields) {
            if (GetLoggingInfoTypes.getTypeFromString(field.getFieldType()).ordinal() > GetLoggingInfoTypes.TYPE_SYSTEM_INFO_NONE.ordinal()) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SystemDataMeta.CheckResult.FieldHasNoType", (String[])new String[]{field.getFieldName()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SystemDataMeta.CheckResult.AllTypesSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetLoggingInfoMeta)) {
            return false;
        }
        GetLoggingInfoMeta that = (GetLoggingInfoMeta)((Object)o);
        return this.fields.equals(that.fields);
    }

    public int hashCode() {
        int result = Arrays.asList(this.fields).hashCode();
        result = 31 * result + Arrays.asList(new Object[0]).hashCode();
        return result;
    }

    @Generated
    public List<GetLoggingInfoField> getFields() {
        return this.fields;
    }

    @Generated
    public void setFields(List<GetLoggingInfoField> fields) {
        this.fields = fields;
    }
}

