/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.gencsv;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.neo4j.core.data.GraphData;
import org.apache.hop.neo4j.core.data.GraphNodeData;
import org.apache.hop.neo4j.core.data.GraphPropertyData;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.apache.hop.neo4j.core.data.GraphRelationshipData;
import org.apache.hop.neo4j.core.value.ValueMetaGraph;
import org.apache.hop.neo4j.transforms.gencsv.CsvFile;
import org.apache.hop.neo4j.transforms.gencsv.GenerateCsvData;
import org.apache.hop.neo4j.transforms.gencsv.GenerateCsvMeta;
import org.apache.hop.neo4j.transforms.gencsv.IdType;
import org.apache.hop.neo4j.transforms.gencsv.IndexedGraphData;
import org.apache.hop.neo4j.transforms.gencsv.UniquenessStrategy;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

public class GenerateCsv
extends BaseTransform<GenerateCsvMeta, GenerateCsvData> {
    public static final String CONST_IMPORT = "import/";

    public GenerateCsv(TransformMeta transformMeta, GenerateCsvMeta meta, GenerateCsvData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.writeBufferToCsv();
            if (((GenerateCsvData)this.data).fileMap != null) {
                for (CsvFile csvFile : ((GenerateCsvData)this.data).fileMap.values()) {
                    try {
                        csvFile.closeFile();
                    }
                    catch (Exception e) {
                        this.setErrors(1L);
                        this.logError("Error flushing/closing file '" + csvFile.getFilename() + "'", e);
                    }
                    Object[] nodeFileRow = RowDataUtil.allocateRowData((int)((GenerateCsvData)this.data).outputRowMeta.size());
                    nodeFileRow[0] = csvFile.getShortFilename();
                    nodeFileRow[1] = csvFile.getFileType();
                    this.putRow(((GenerateCsvData)this.data).outputRowMeta, nodeFileRow);
                }
            }
            if (this.getErrors() > 0L) {
                this.stopAll();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((GenerateCsvData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((GenerateCsvMeta)this.meta).getFields(((GenerateCsvData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((GenerateCsvData)this.data).fileMap = new HashMap<String, CsvFile>();
            ((GenerateCsvData)this.data).graphFieldIndex = this.getInputRowMeta().indexOfValue(((GenerateCsvMeta)this.meta).getGraphFieldName());
            if (((GenerateCsvData)this.data).graphFieldIndex < 0) {
                throw new HopException("Unable to find graph field " + ((GenerateCsvMeta)this.meta).getGraphFieldName() + "' in the transform input");
            }
            if (this.getInputRowMeta().getValueMeta(((GenerateCsvData)this.data).graphFieldIndex).getType() != 303) {
                throw new HopException("Field " + ((GenerateCsvMeta)this.meta).getGraphFieldName() + "' needs to be of type Graph");
            }
            ((GenerateCsvData)this.data).indexedGraphData = ((GenerateCsvMeta)this.meta).getUniquenessStrategy() != UniquenessStrategy.None ? new IndexedGraphData(((GenerateCsvMeta)this.meta).getUniquenessStrategy(), ((GenerateCsvMeta)this.meta).getUniquenessStrategy()) : null;
            ((GenerateCsvData)this.data).filesPrefix = this.resolve(((GenerateCsvMeta)this.meta).getFilesPrefix());
            ((GenerateCsvData)this.data).filenameField = this.resolve(((GenerateCsvMeta)this.meta).getFilenameField());
            ((GenerateCsvData)this.data).fileTypeField = this.resolve(((GenerateCsvMeta)this.meta).getFileTypeField());
            ((GenerateCsvData)this.data).baseFolder = this.resolve(((GenerateCsvMeta)this.meta).getBaseFolder());
            if (!((GenerateCsvData)this.data).baseFolder.endsWith(File.separator)) {
                ((GenerateCsvData)this.data).baseFolder = ((GenerateCsvData)this.data).baseFolder + File.separator;
            }
            ((GenerateCsvData)this.data).importFolder = ((GenerateCsvData)this.data).baseFolder + CONST_IMPORT;
        }
        if (((GenerateCsvMeta)this.meta).getUniquenessStrategy() != UniquenessStrategy.None) {
            this.addRowToBuffer(this.getInputRowMeta(), row);
        } else {
            ValueMetaGraph valueMetaGraph = (ValueMetaGraph)this.getInputRowMeta().getValueMeta(((GenerateCsvData)this.data).graphFieldIndex);
            GraphData graphData = valueMetaGraph.getGraphData(row[((GenerateCsvData)this.data).graphFieldIndex]);
            if (((GenerateCsvData)this.data).fileMap == null) {
                ((GenerateCsvData)this.data).fileMap = new HashMap<String, CsvFile>();
            }
            this.writeGraphDataToCsvFiles(graphData);
        }
        return true;
    }

    protected void writeGraphDataToCsvFiles(GraphData graphData) throws HopException {
        if (graphData == null) {
            return;
        }
        this.writeNodesToCsvFiles(graphData);
        this.writeRelationshipsToCsvFiles(graphData);
    }

    protected void writeNodesToCsvFiles(GraphData graphData) throws HopException {
        for (GraphNodeData nodeData : graphData.getNodes()) {
            String propertySetKey = GenerateCsvData.getPropertySetKey(graphData.getSourcePipelineName(), graphData.getSourceTransformName(), nodeData.getPropertySetId());
            CsvFile csvFile = ((GenerateCsvData)this.data).fileMap.get(propertySetKey);
            if (csvFile == null) {
                String filename = this.calculateNodeFilename(propertySetKey);
                String shortFilename = this.calculateNodeShortFilename(propertySetKey);
                csvFile = new CsvFile(filename, shortFilename, "Nodes");
                ((GenerateCsvData)this.data).fileMap.put(propertySetKey, csvFile);
                try {
                    csvFile.openFile();
                }
                catch (Exception e) {
                    throw new HopException("Unable to create nodes CSV file '" + csvFile.getFilename() + "'", (Throwable)e);
                }
                List<GraphPropertyData> properties = nodeData.getProperties();
                for (GraphPropertyData graphPropertyData : properties) {
                    csvFile.getPropsList().add(new IdType(graphPropertyData.getId(), graphPropertyData.getType()));
                }
                for (int i = 0; i < properties.size(); ++i) {
                    csvFile.getPropsIndexes().put(properties.get(i).getId(), i);
                }
                csvFile.setIdFieldName("id");
                for (GraphPropertyData property : properties) {
                    if (!property.isPrimary()) continue;
                    csvFile.setIdFieldName(property.getId());
                    break;
                }
                try {
                    this.writeNodeCsvHeader(csvFile.getOutputStream(), csvFile.getPropsList(), csvFile.getIdFieldName());
                }
                catch (Exception e) {
                    throw new HopException("Unable to write node header to file '" + csvFile.getFilename() + "'", (Throwable)e);
                }
            }
            try {
                this.writeNodeCsvRows(csvFile.getOutputStream(), Arrays.asList(nodeData), csvFile.getPropsList(), csvFile.getPropsIndexes(), csvFile.getIdFieldName());
            }
            catch (Exception e) {
                throw new HopException("Unable to write node header to file '" + csvFile.getFilename() + "'", (Throwable)e);
            }
        }
    }

    protected void writeRelationshipsToCsvFiles(GraphData graphData) throws HopException {
        for (GraphRelationshipData relationshipData : graphData.getRelationships()) {
            String propertySetKey = GenerateCsvData.getPropertySetKey(graphData.getSourcePipelineName(), graphData.getSourceTransformName(), relationshipData.getPropertySetId());
            CsvFile csvFile = ((GenerateCsvData)this.data).fileMap.get(propertySetKey);
            if (csvFile == null) {
                String filename = this.calculateRelatiohshipsFilename(propertySetKey);
                String shortFilename = this.calculateRelatiohshipsShortFilename(propertySetKey);
                csvFile = new CsvFile(filename, shortFilename, "Relationships");
                ((GenerateCsvData)this.data).fileMap.put(propertySetKey, csvFile);
                try {
                    csvFile.openFile();
                }
                catch (Exception e) {
                    throw new HopException("Unable to create relationships CSV file '" + csvFile.getFilename() + "'", (Throwable)e);
                }
                List<GraphPropertyData> properties = relationshipData.getProperties();
                for (GraphPropertyData graphPropertyData : properties) {
                    csvFile.getPropsList().add(new IdType(graphPropertyData.getId(), graphPropertyData.getType()));
                }
                for (int i = 0; i < properties.size(); ++i) {
                    csvFile.getPropsIndexes().put(properties.get(i).getId(), i);
                }
                csvFile.setIdFieldName("id");
                for (GraphPropertyData property : properties) {
                    if (!property.isPrimary()) continue;
                    csvFile.setIdFieldName(property.getId());
                    break;
                }
                try {
                    this.writeRelsCsvHeader(csvFile.getOutputStream(), csvFile.getPropsList(), csvFile.getPropsIndexes());
                }
                catch (Exception e) {
                    throw new HopException("Unable to write relationships header to file '" + csvFile.getFilename() + "'", (Throwable)e);
                }
            }
            try {
                this.writeRelsCsvRows(csvFile.getOutputStream(), Arrays.asList(relationshipData), csvFile.getPropsList(), csvFile.getPropsIndexes());
            }
            catch (Exception e) {
                throw new HopException("Unable to write relationships header to file '" + csvFile.getFilename() + "'", (Throwable)e);
            }
        }
    }

    protected void writeBufferToCsv() throws HopException {
        try {
            if (((GenerateCsvMeta)this.meta).getUniquenessStrategy() != UniquenessStrategy.None) {
                this.writeGraphDataToCsvFiles(((GenerateCsvData)this.data).indexedGraphData);
            }
        }
        catch (Exception e) {
            throw new HopException("Unable to generate CSV data for Neo4j import", (Throwable)e);
        }
    }

    private String calculateNodeShortFilename(String propertySetKey) {
        return CONST_IMPORT + Const.NVL((String)(((GenerateCsvData)this.data).filesPrefix + "-"), (String)"") + "nodes-" + propertySetKey + "-" + this.resolve("${Internal.Transform.CopyNr}") + ".csv";
    }

    private String calculateNodeFilename(String propertySetKey) {
        return ((GenerateCsvData)this.data).importFolder + Const.NVL((String)(((GenerateCsvData)this.data).filesPrefix + "-"), (String)"") + "nodes-" + propertySetKey + "-" + this.resolve("${Internal.Transform.CopyNr}") + ".csv";
    }

    private String calculateRelatiohshipsShortFilename(String propertySetKey) {
        return CONST_IMPORT + Const.NVL((String)(((GenerateCsvData)this.data).filesPrefix + "-"), (String)"") + "rels-" + propertySetKey + "-" + this.resolve("${Internal.Transform.CopyNr}") + ".csv";
    }

    private String calculateRelatiohshipsFilename(String propertySetKey) {
        return ((GenerateCsvData)this.data).importFolder + Const.NVL((String)(((GenerateCsvData)this.data).filesPrefix + "-"), (String)"") + "rels-" + propertySetKey + "-" + this.resolve("${Internal.Transform.CopyNr}") + ".csv";
    }

    private void writeNodeCsvHeader(OutputStream os, List<IdType> props, String idFieldName) throws HopException, IOException {
        StringBuffer header = new StringBuffer();
        header.append(idFieldName).append(":ID");
        for (IdType prop : props) {
            if (prop.getId().equals(idFieldName)) continue;
            header.append(",");
            header.append(prop.getId());
            if (prop.getType() == null) {
                throw new HopException("This transform doesn't support importing data type '" + prop.getType().name() + "' yet.");
            }
            header.append(":").append(prop.getType().getImportType());
        }
        header.append(",:LABEL");
        header.append(Const.CR);
        System.out.println("NODES HEADER: '" + String.valueOf(header) + "'");
        os.write(header.toString().getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - void declaration
     */
    private void writeNodeCsvRows(OutputStream os, List<GraphNodeData> nodes, List<IdType> props, Map<String, Integer> propertyIndexes, String idFieldName) throws IOException {
        for (GraphNodeData node : nodes) {
            void var11_12;
            StringBuffer row = new StringBuffer();
            GraphPropertyData[] sortedProperties = new GraphPropertyData[props.size()];
            for (GraphPropertyData graphPropertyData : node.getProperties()) {
                int index = propertyIndexes.get(graphPropertyData.getId());
                sortedProperties[index] = graphPropertyData;
            }
            boolean indexFound = false;
            for (GraphPropertyData prop : sortedProperties) {
                if (!prop.isPrimary()) continue;
                if (prop.getType() == GraphPropertyDataType.String) {
                    row.append('\"').append(prop.toString()).append('\"');
                } else {
                    row.append(prop.toString());
                }
                indexFound = true;
                break;
            }
            if (!indexFound) {
                row.append('\"').append(GraphPropertyData.escapeString(node.getId())).append('\"');
            }
            for (GraphPropertyData prop : sortedProperties) {
                if (prop.isPrimary()) continue;
                row.append(",");
                if (prop == null) continue;
                if (prop.getType() == GraphPropertyDataType.String) {
                    row.append('\"').append(prop.toString()).append('\"');
                    continue;
                }
                row.append(prop.toString());
            }
            boolean bl = false;
            while (var11_12 < node.getLabels().size()) {
                if (var11_12 == false) {
                    row.append(",");
                } else {
                    row.append(";");
                }
                String label = node.getLabels().get((int)var11_12);
                row.append(label);
                ++var11_12;
            }
            row.append(Const.CR);
            os.write(row.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private void writeRelsCsvRows(OutputStream os, List<GraphRelationshipData> relationships, List<IdType> props, Map<String, Integer> propertyIndexes) throws IOException, HopException {
        for (GraphRelationshipData relationship : relationships) {
            StringBuffer row = new StringBuffer();
            row.append('\"').append(GraphPropertyData.escapeString(relationship.getSourceNodeId())).append('\"');
            GraphPropertyData[] sortedProperties = new GraphPropertyData[props.size()];
            for (GraphPropertyData prop : relationship.getProperties()) {
                int index = propertyIndexes.get(prop.getId());
                sortedProperties[index] = prop;
            }
            for (GraphPropertyData prop : sortedProperties) {
                row.append(",");
                if (prop == null) continue;
                if (prop.getType() == GraphPropertyDataType.String) {
                    row.append('\"').append(prop.toString()).append('\"');
                    continue;
                }
                row.append(prop.toString());
            }
            row.append(",").append('\"').append(GraphPropertyData.escapeString(relationship.getTargetNodeId())).append('\"');
            String relationshipLabel = relationship.getLabel();
            if (StringUtils.isEmpty((String)relationshipLabel)) {
                throw new HopException("Relationship label/type cannot be null or empty. All relationships must have a type specified.");
            }
            row.append(",").append(relationshipLabel);
            row.append(Const.CR);
            os.write(row.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private void writeRelsCsvHeader(OutputStream os, List<IdType> props, Map<String, Integer> propertyIndexes) throws HopException, IOException {
        StringBuffer header = new StringBuffer();
        header.append(":START_ID");
        for (IdType prop : props) {
            header.append(",");
            header.append(prop.getId());
            if (prop.getType() == null) {
                throw new HopException("This transform doesn't support importing data type '" + prop.getType().name() + "' yet.");
            }
            header.append(":").append(prop.getType().getImportType());
            GraphPropertyDataType graphPropertyDataType = prop.getType();
        }
        header.append(",:END_ID,:TYPE").append(Const.CR);
        os.write(header.toString().getBytes(StandardCharsets.UTF_8));
    }

    protected void addRowToBuffer(IRowMeta inputRowMeta, Object[] row) throws HopException {
        try {
            ValueMetaGraph valueMetaGraph = (ValueMetaGraph)inputRowMeta.getValueMeta(((GenerateCsvData)this.data).graphFieldIndex);
            GraphData graphData = valueMetaGraph.getGraphData(row[((GenerateCsvData)this.data).graphFieldIndex]);
            for (GraphNodeData node : graphData.getNodes()) {
                GraphNodeData nodeCopy = new GraphNodeData(node);
                nodeCopy.setPropertySetId(graphData.getSourcePipelineName() + "-" + graphData.getSourceTransformName() + "-" + node.getPropertySetId());
                ((GenerateCsvData)this.data).indexedGraphData.addAndIndexNode(nodeCopy);
            }
            for (GraphRelationshipData relationship : graphData.getRelationships()) {
                GraphRelationshipData relationshipCopy = new GraphRelationshipData(relationship);
                relationshipCopy.setPropertySetId(graphData.getSourcePipelineName() + "-" + graphData.getSourceTransformName() + "-" + relationship.getPropertySetId());
                ((GenerateCsvData)this.data).indexedGraphData.addAndIndexRelationship(relationshipCopy);
            }
        }
        catch (Exception e) {
            throw new HopException("Error adding row to gencsv buffer", (Throwable)e);
        }
    }
}

