/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai;

import dev.langchain4j.model.mistralai.DefaultMistralAiHelper;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MistralAiResponseLoggingInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MistralAiResponseLoggingInterceptor.class);

    MistralAiResponseLoggingInterceptor() {
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        this.log(response);
        return response;
    }

    private void log(Response response) {
        try {
            LOGGER.debug("Response:\n- status code: {}\n- headers: {}\n- body: {}", new Object[]{response.code(), DefaultMistralAiHelper.getHeaders(response.headers()), this.getBody(response)});
        }
        catch (Exception e) {
            LOGGER.warn("Error while logging response: {}", (Object)e.getMessage());
        }
    }

    private String getBody(Response response) throws IOException {
        return MistralAiResponseLoggingInterceptor.isEventStream(response) ? "[skipping response body due to streaming]" : response.peekBody(Long.MAX_VALUE).string();
    }

    private static boolean isEventStream(Response response) {
        String contentType = response.header("Content-Type");
        return contentType != null && contentType.contains("event-stream");
    }
}

