/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.options.BlockBlobCommitBlockListOptions;
import com.azure.storage.blob.options.BlockBlobStageBlockOptions;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.common.implementation.StorageSeekableByteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class StorageSeekableByteChannelBlockBlobWriteBehavior
implements StorageSeekableByteChannel.WriteBehavior {
    private static final ClientLogger LOGGER = new ClientLogger(StorageSeekableByteChannelBlockBlobWriteBehavior.class);
    private final BlockBlobClient client;
    private final BlobHttpHeaders headers;
    private final Map<String, String> metadata;
    private final Map<String, String> tags;
    private final AccessTier tier;
    private final BlobRequestConditions conditions;
    private final WriteMode mode;
    private final List<String> existingBlockIds;
    private final List<String> newBlockIds = new ArrayList<String>();

    StorageSeekableByteChannelBlockBlobWriteBehavior(BlockBlobClient client, BlobHttpHeaders headers, Map<String, String> metadata, Map<String, String> tags, AccessTier tier, BlobRequestConditions conditions, WriteMode mode, List<String> existingBlockIds) {
        this.client = Objects.requireNonNull(client);
        this.headers = headers;
        this.metadata = metadata;
        this.tags = tags;
        this.tier = tier;
        this.conditions = conditions;
        this.mode = Objects.requireNonNull(mode);
        this.existingBlockIds = existingBlockIds != null ? existingBlockIds : Collections.emptyList();
    }

    BlockBlobClient getClient() {
        return this.client;
    }

    BlobHttpHeaders getHeaders() {
        return this.headers;
    }

    Map<String, String> getMetadata() {
        return this.metadata != null ? Collections.unmodifiableMap(this.metadata) : null;
    }

    Map<String, String> getTags() {
        return this.tags != null ? Collections.unmodifiableMap(this.tags) : null;
    }

    AccessTier getTier() {
        return this.tier;
    }

    BlobRequestConditions getRequestConditions() {
        return this.conditions;
    }

    WriteMode getWriteMode() {
        return this.mode;
    }

    List<String> getExistingBlockIds() {
        return this.existingBlockIds != null ? Collections.unmodifiableList(this.existingBlockIds) : null;
    }

    List<String> getNewBlockIds() {
        return this.newBlockIds != null ? Collections.unmodifiableList(this.newBlockIds) : null;
    }

    public void write(ByteBuffer src, long destOffset) throws IOException {
        String blockId = Base64.getEncoder().encodeToString(CoreUtils.randomUuid().toString().getBytes(StandardCharsets.UTF_8));
        BlockBlobStageBlockOptions options = new BlockBlobStageBlockOptions(blockId, BinaryData.fromByteBuffer((ByteBuffer)src));
        if (this.conditions != null) {
            options.setLeaseId(this.conditions.getLeaseId());
        }
        this.client.stageBlockWithResponse(options, null, null);
        this.newBlockIds.add(blockId);
    }

    public void commit(long totalLength) {
        List<String> commitList;
        switch (this.mode) {
            case OVERWRITE: {
                commitList = this.newBlockIds;
                break;
            }
            case APPEND: {
                commitList = Stream.of(this.existingBlockIds, this.newBlockIds).flatMap(Collection::stream).collect(Collectors.toList());
                break;
            }
            case PREPEND: {
                commitList = Stream.of(this.newBlockIds, this.existingBlockIds).flatMap(Collection::stream).collect(Collectors.toList());
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Commit not supported with the configured BlockBlobSeekableByteChannelWriteMode."));
            }
        }
        this.client.commitBlockListWithResponse(new BlockBlobCommitBlockListOptions(commitList).setHeaders(this.headers).setMetadata(this.metadata).setTags(this.tags).setTier(this.tier).setRequestConditions(this.conditions), null, null);
    }

    public void assertCanSeek(long position) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Block blob write channels support sequential write only."));
    }

    public void resize(long newSize) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Block blobs cannot have size explicitly set."));
    }

    static enum WriteMode {
        OVERWRITE,
        APPEND,
        PREPEND;

    }
}

