/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.serializer.xml;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.HopMetadataObject;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataWrapper;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataObjectFactory;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IIntCodeConverter;
import org.apache.hop.metadata.serializer.xml.MetadataPropertyKeyFunction;
import org.apache.hop.metadata.util.ReflectionUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlMetadataUtil {
    public static String serializeObjectToXml(Object object) throws HopException {
        Class<?> objectClass = object.getClass();
        StringBuilder xml = new StringBuilder();
        HopMetadataWrapper wrapper = objectClass.getAnnotation(HopMetadataWrapper.class);
        if (wrapper != null) {
            xml.append(XmlHandler.openTag(wrapper.tag()));
        }
        List<Field> fields = ReflectionUtil.findAllFields(objectClass, new MetadataPropertyKeyFunction());
        for (Field field : fields) {
            Class<?> fieldType;
            HopMetadataProperty property;
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isVolatile(field.getModifiers()) || (property = field.getAnnotation(HopMetadataProperty.class)) == null) continue;
            String groupKey = property.groupKey();
            String tag = property.key();
            if (StringUtils.isEmpty((String)tag)) {
                tag = field.getName();
            }
            boolean isBoolean = Boolean.class.equals(fieldType = field.getType()) || Boolean.TYPE.equals(fieldType);
            boolean isPassword = property.password();
            boolean storeWithCode = property.storeWithCode();
            Object value = ReflectionUtil.getFieldValue(object, field.getName(), isBoolean);
            if (value == null) continue;
            if (property.storeWithName()) {
                xml.append(XmlHandler.addTagValue(tag, ((IHopMetadata)value).getName()));
                continue;
            }
            xml.append(XmlMetadataUtil.serializeObjectToXml(property, value, groupKey, tag, isPassword, storeWithCode, property.intCodeConverter()));
        }
        if (wrapper != null) {
            xml.append(XmlHandler.closeTag(wrapper.tag()));
        }
        return xml.toString();
    }

    private static String serializeObjectToXml(HopMetadataProperty property, Object value, String groupKey, String tag, boolean password, boolean storeWithCode, Class<? extends IIntCodeConverter> intCodeConverterClass) throws HopException {
        StringBuilder xml = new StringBuilder();
        if (value == null) {
            xml.append(XmlHandler.addTagValue(tag, (String)null));
        } else if (value instanceof String) {
            String string = (String)value;
            if (password) {
                xml.append(XmlHandler.addTagValue(tag, Encr.encryptPasswordIfNotUsingVariables(string)));
            } else {
                xml.append(XmlHandler.addTagValue(tag, string));
            }
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            xml.append(XmlHandler.addTagValue(tag, (boolean)bool));
        } else if (value instanceof Integer) {
            Integer integer = (Integer)value;
            if (intCodeConverterClass.equals(IIntCodeConverter.None.class)) {
                xml.append(XmlHandler.addTagValue(tag, (int)integer));
            } else {
                try {
                    IIntCodeConverter converter = intCodeConverterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    xml.append(XmlHandler.addTagValue(tag, converter.getCode((Integer)value)));
                }
                catch (Exception e) {
                    throw new HopException("Error converting int to String code using converter class " + String.valueOf(intCodeConverterClass), e);
                }
            }
        } else if (value instanceof Long) {
            Long longValue = (Long)value;
            xml.append(XmlHandler.addTagValue(tag, longValue));
        } else if (value instanceof Double) {
            Double doubleValue = (Double)value;
            xml.append(XmlHandler.addTagValue(tag, doubleValue));
        } else if (value instanceof Date) {
            Date date = (Date)value;
            xml.append(XmlHandler.addTagValue(tag, date));
        } else if (value.getClass().isEnum()) {
            if (storeWithCode) {
                xml.append(XmlHandler.addTagValue(tag, ((IEnumHasCode)value).getCode()));
            } else {
                xml.append(XmlHandler.addTagValue(tag, ((Enum)value).name()));
            }
        } else if (value instanceof List) {
            List list = (List)value;
            if (StringUtils.isNotEmpty((String)groupKey)) {
                xml.append(XmlHandler.openTag(groupKey)).append(Const.CR);
            }
            List listItems = list;
            for (Object listItem : listItems) {
                xml.append(XmlMetadataUtil.serializeObjectToXml(property, listItem, groupKey, tag, password, storeWithCode, property.intCodeConverter()));
            }
            if (StringUtils.isNotEmpty((String)groupKey)) {
                xml.append(XmlHandler.closeTag(groupKey)).append(Const.CR);
            }
        } else {
            if (!property.inline()) {
                xml.append(XmlHandler.openTag(tag)).append(Const.CR);
            }
            xml.append(XmlMetadataUtil.serializeObjectToXml(value));
            if (!property.inline()) {
                xml.append(XmlHandler.closeTag(tag)).append(Const.CR);
            }
        }
        return xml.toString();
    }

    public static <T> T deSerializeFromXml(Node node, Class<? extends T> clazz, IHopMetadataProvider metadataProvider) throws HopXmlException {
        return XmlMetadataUtil.deSerializeFromXml(null, node, clazz, null, metadataProvider);
    }

    public static <T> T deSerializeFromXml(Object parentObject, Node node, Class<? extends T> clazz, IHopMetadataProvider metadataProvider) throws HopXmlException {
        return XmlMetadataUtil.deSerializeFromXml(parentObject, node, clazz, null, metadataProvider);
    }

    public static <T> T deSerializeFromXml(Node node, Class<? extends T> clazz, T object, IHopMetadataProvider metadataProvider) throws HopXmlException {
        return XmlMetadataUtil.deSerializeFromXml(null, node, clazz, object, metadataProvider);
    }

    public static <T> T deSerializeFromXml(Object parentObject, Node node, Class<? extends T> clazz, T object, IHopMetadataProvider metadataProvider) throws HopXmlException {
        HopMetadataWrapper wrapper;
        if (object == null) {
            try {
                if (node == null) {
                    return null;
                }
                HopMetadataObject metadataObject = clazz.getAnnotation(HopMetadataObject.class);
                if (metadataObject != null) {
                    String xmlKey = metadataObject.xmlKey();
                    if (StringUtils.isEmpty((String)xmlKey)) {
                        throw new HopXmlException("Please specify which XML attribute to consider the key.  Hop will use this key to create the appropriate class instance of type " + String.valueOf(clazz));
                    }
                    String objectId = XmlHandler.getNodeValue(XmlHandler.getSubNode(node, xmlKey));
                    if (StringUtils.isEmpty((String)objectId)) {
                        throw new HopXmlException("XML attribute " + xmlKey + " is needed to instantiate type " + String.valueOf(clazz) + " but it wasn't provided");
                    }
                    IHopMetadataObjectFactory factory = metadataObject.objectFactory().getConstructor(new Class[0]).newInstance(new Object[0]);
                    object = factory.createObject(objectId, parentObject);
                } else {
                    object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                throw new HopXmlException("Unable to create a new instance of class " + clazz.getName() + " while de-serializing XML: make sure you have a public empty constructor for this class.", e);
            }
        }
        if ((wrapper = clazz.getAnnotation(HopMetadataWrapper.class)) != null) {
            node = XmlHandler.getSubNode(node, wrapper.tag());
        }
        List<Field> fields = ReflectionUtil.findAllFields(object.getClass(), new MetadataPropertyKeyFunction());
        for (Field field : fields) {
            HopMetadataProperty property;
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isVolatile(field.getModifiers()) || (property = field.getAnnotation(HopMetadataProperty.class)) == null) continue;
            String tag = property.key();
            String groupKey = property.groupKey();
            if (StringUtils.isEmpty((String)tag)) {
                tag = field.getName();
            }
            Class<?> fieldType = field.getType();
            boolean defaultBoolean = property.defaultBoolean();
            boolean storeWithName = property.storeWithName();
            boolean password = property.password();
            boolean storeWithCode = property.storeWithCode();
            String[] inlineListTags = property.inlineListTags();
            Node tagNode = property.inline() ? node : XmlHandler.getSubNode(node, tag);
            Node groupNode = StringUtils.isEmpty((String)groupKey) ? node : XmlHandler.getSubNode(node, groupKey);
            Object value = XmlMetadataUtil.deSerializeFromXml(object, fieldType, groupNode, tagNode, tag, field, defaultBoolean, storeWithName, metadataProvider, password, storeWithCode, property.intCodeConverter(), inlineListTags);
            try {
                if (value == null) continue;
                ReflectionUtil.setFieldValue(object, field.getName(), fieldType, value);
            }
            catch (HopException e) {
                throw new HopXmlException("Unable to set value " + String.valueOf(value) + " on field " + field.getName() + " in class " + fieldType.getName(), e);
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object deSerializeFromXml(Object parentObject, Class<?> fieldType, Node groupNode, Node elementNode, String tag, Field field, boolean defaultBoolean, boolean storeWithName, IHopMetadataProvider metadataProvider, boolean password, boolean storeWithCode, Class<? extends IIntCodeConverter> intCodeConverterClass, String[] inlineListTags) throws HopXmlException {
        List<Node> itemNodes;
        ArrayList<Object> list;
        block37: {
            Node parentNode;
            int listSize;
            String elementString = XmlHandler.getNodeValue(elementNode);
            if (storeWithName) {
                if (StringUtils.isEmpty((String)elementString)) {
                    return null;
                }
                try {
                    return metadataProvider.getSerializer(fieldType).load(elementString);
                }
                catch (Exception e) {
                    throw new HopXmlException("Unable to load reference by name '" + elementString + "' for type " + fieldType.getName() + ". Does this class implement IHopMetadata?", e);
                }
            }
            if (fieldType.equals(String.class)) {
                if (elementNode == null) return null;
                if (!password) return elementString;
                return Encr.decryptPasswordOptionallyEncrypted(elementString);
            }
            if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
                if (elementNode == null) return null;
                if (intCodeConverterClass.equals(IIntCodeConverter.None.class)) {
                    return Integer.valueOf(elementString);
                }
                try {
                    IIntCodeConverter converter = intCodeConverterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    return converter.getType(elementString);
                }
                catch (Exception e) {
                    throw new HopXmlException("Error converting String code " + elementString + " to integer using converter class " + String.valueOf(intCodeConverterClass), e);
                }
            }
            if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                if (elementNode == null) return null;
                return Long.valueOf(elementString);
            }
            if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
                if (elementNode == null) return null;
                return Double.valueOf(elementString);
            }
            if (fieldType.equals(Date.class)) {
                if (elementNode == null) return null;
                return XmlHandler.stringToDate(elementString);
            }
            if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
                if (elementNode == null) return defaultBoolean;
                return Const.toBoolean(elementString);
            }
            if (fieldType.isEnum()) {
                Class<?> enumerationClass = field.getType();
                if (!StringUtils.isNotEmpty((String)elementString)) return null;
                if (storeWithCode) {
                    try {
                        IEnumHasCodeAndDescription[] vals;
                        IEnumHasCode[] values;
                        for (IEnumHasCode value : values = (IEnumHasCode[])enumerationClass.getEnumConstants()) {
                            if (!value.getCode().equals(elementString)) continue;
                            return value;
                        }
                        if (!enumerationClass.isInstance(IEnumHasCodeAndDescription.class)) return null;
                        for (IEnumHasCodeAndDescription value : vals = (IEnumHasCodeAndDescription[])enumerationClass.getEnumConstants()) {
                            if (!value.getDescription().equals(elementString)) continue;
                            return value;
                        }
                        return null;
                    }
                    catch (Exception e) {
                        throw new HopXmlException("Unable to get values() of enumeration to look up code value " + elementString, e);
                    }
                } else {
                    try {
                        return Enum.valueOf(enumerationClass, elementString);
                    }
                    catch (IllegalArgumentException e) {
                        String nameNotFound = field.getAnnotation(HopMetadataProperty.class).enumNameWhenNotFound();
                        if (!StringUtils.isEmpty((String)nameNotFound)) return Enum.valueOf(enumerationClass, nameNotFound);
                        throw e;
                    }
                }
            }
            if (!fieldType.equals(List.class)) {
                return XmlMetadataUtil.deSerializeFromXml(parentObject, elementNode, fieldType, metadataProvider);
            }
            list = new ArrayList<Object>();
            itemNodes = XmlHandler.getNodes(groupNode, tag);
            if (inlineListTags.length <= 0 || itemNodes.isEmpty() || (listSize = XmlHandler.countNodes(parentNode = itemNodes.get(0), inlineListTags[0])) <= 1) break block37;
            itemNodes.clear();
            for (int i = 0; i < listSize; ++i) {
                Element node = parentNode.getOwnerDocument().createElement(tag);
                for (String inlineTag : inlineListTags) {
                    Node n = XmlHandler.getSubNodeByNr(parentNode, inlineTag, i);
                    if (n == null) continue;
                    node.appendChild(n);
                }
                itemNodes.add(node);
            }
        }
        Iterator<Node> iterator = itemNodes.iterator();
        while (iterator.hasNext()) {
            Node itemNode = iterator.next();
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Class listClass = (Class)parameterizedType.getActualTypeArguments()[0];
            try {
                Object newItem = XmlMetadataUtil.deSerializeFromXml(parentObject, listClass, null, itemNode, null, null, false, false, metadataProvider, password, storeWithCode, intCodeConverterClass, inlineListTags);
                list.add(newItem);
            }
            catch (Exception e) {
                throw new HopXmlException("Unable to instantiate a new instance of class " + listClass.getName() + ": make sure there is an empty public constructor available to allow XML de-serialization", e);
            }
        }
        return list;
    }
}

