/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs.providers;

import com.google.auto.service.AutoService;
import java.util.List;
import org.apache.beam.sdk.io.aws2.sqs.SqsIO;
import org.apache.beam.sdk.io.aws2.sqs.SqsMessage;
import org.apache.beam.sdk.io.aws2.sqs.providers.SqsReadConfiguration;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@AutoService(value={SchemaTransformProvider.class})
public class SqsReadSchemaTransformProvider
extends TypedSchemaTransformProvider<SqsReadConfiguration> {
    public static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_TAG = "output";
    public static final @UnknownKeyFor @NonNull @Initialized Schema OUTPUT_ROW_SCHEMA = Schema.builder().addNullableStringField("body").addNullableStringField("message_id").addNullableStringField("receipt_handle").addNullableInt64Field("timestamp").addNullableInt64Field("request_timestamp").build();

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized SqsReadConfiguration configuration) {
        return new SqsReadSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:aws:sqs_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized String description() {
        return "Expose the SQS read functionality implemented in the Java SDK.";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return ImmutableList.of((Object)OUTPUT_TAG);
    }

    public static class SqsMessageToBeamRow
    implements SerializableFunction<SqsMessage, Row> {
        public @UnknownKeyFor @NonNull @Initialized Row apply(@UnknownKeyFor @NonNull @Initialized SqsMessage input) {
            return Row.withSchema((Schema)OUTPUT_ROW_SCHEMA).withFieldValue("body", (Object)input.getBody()).withFieldValue("message_id", (Object)input.getMessageId()).withFieldValue("receipt_handle", (Object)input.getReceiptHandle()).withFieldValue("timestamp", (Object)input.getTimeStamp()).withFieldValue("request_timestamp", (Object)input.getRequestTimeStamp()).build();
        }
    }

    private static class SqsReadSchemaTransform
    extends SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized SqsReadConfiguration configuration;

        SqsReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized SqsReadConfiguration config) {
            this.configuration = config;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Preconditions.checkArgument((boolean)input.getAll().isEmpty(), (Object)String.format("Input to %s should be empty but it is not.", ((Object)((Object)this)).getClass().getSimpleName()));
            SqsIO.Read sqsRead = SqsIO.read().withQueueUrl(this.configuration.getQueueUrl()).withMaxNumRecords(this.configuration.maxNumRecords());
            Long maxReadtimeSecs = this.configuration.getMaxReadTimeSecs();
            if (maxReadtimeSecs != null) {
                sqsRead = sqsRead.withMaxReadTime(Duration.standardSeconds((long)maxReadtimeSecs));
            }
            return PCollectionRowTuple.of((String)SqsReadSchemaTransformProvider.OUTPUT_TAG, (PCollection)((PCollection)((PCollection)input.getPipeline().apply("ReadFromSqs", (PTransform)sqsRead)).apply("SqsMessageToRow", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction)new SqsMessageToBeamRow()))).setRowSchema(OUTPUT_ROW_SCHEMA));
        }
    }
}

