/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.reactivestreams;

import java.util.Map;
import java.util.Set;
import org.neo4j.driver.BaseSession;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.reactivestreams.ReactiveQueryRunner;
import org.neo4j.driver.reactivestreams.ReactiveResult;
import org.neo4j.driver.reactivestreams.ReactiveTransaction;
import org.neo4j.driver.reactivestreams.ReactiveTransactionCallback;
import org.reactivestreams.Publisher;

public interface ReactiveSession
extends BaseSession,
ReactiveQueryRunner {
    default public Publisher<ReactiveTransaction> beginTransaction() {
        return this.beginTransaction(TransactionConfig.empty());
    }

    public Publisher<ReactiveTransaction> beginTransaction(TransactionConfig var1);

    default public <T> Publisher<T> executeRead(ReactiveTransactionCallback<? extends Publisher<T>> callback) {
        return this.executeRead(callback, TransactionConfig.empty());
    }

    public <T> Publisher<T> executeRead(ReactiveTransactionCallback<? extends Publisher<T>> var1, TransactionConfig var2);

    default public <T> Publisher<T> executeWrite(ReactiveTransactionCallback<? extends Publisher<T>> callback) {
        return this.executeWrite(callback, TransactionConfig.empty());
    }

    public <T> Publisher<T> executeWrite(ReactiveTransactionCallback<? extends Publisher<T>> var1, TransactionConfig var2);

    default public Publisher<ReactiveResult> run(String query, TransactionConfig config) {
        return this.run(new Query(query), config);
    }

    default public Publisher<ReactiveResult> run(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.run(new Query(query, parameters), config);
    }

    public Publisher<ReactiveResult> run(Query var1, TransactionConfig var2);

    public Set<Bookmark> lastBookmarks();

    public <T> Publisher<T> close();
}

