/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PubsubMessageWithMessageIdCoder
extends CustomCoder<PubsubMessage> {
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> PAYLOAD_CODER = ByteArrayCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> MESSAGE_ID_CODER = StringUtf8Coder.of();

    public static @UnknownKeyFor @NonNull @Initialized PubsubMessageWithMessageIdCoder of() {
        return new PubsubMessageWithMessageIdCoder();
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized PubsubMessage value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        PAYLOAD_CODER.encode((Object)value.getPayload(), outStream);
        MESSAGE_ID_CODER.encode((Object)value.getMessageId(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized PubsubMessage decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] payload = (byte[])PAYLOAD_CODER.decode(inStream);
        String messageId = (String)MESSAGE_ID_CODER.decode(inStream);
        return new PubsubMessage(payload, (Map<String, String>)ImmutableMap.of(), messageId);
    }
}

