/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.SerializationException;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.SerializationUtils;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.TimestampConverter;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.BigtableChangeStreamAccessor;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.MetadataTableAdminDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.encoder.MetadataTableEncoder;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.DetectNewPartitionsState;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.NewPartition;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.StreamPartitionWithWatermark;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Longs;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MetadataTableDao {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MetadataTableDao.class);
    private static final @UnknownKeyFor @NonNull @Initialized Duration DELETED_NEW_PARTITION_REEVALUATE_DELAY = Duration.standardMinutes((long)1L);
    private final @UnknownKeyFor @NonNull @Initialized BigtableDataClient dataClient;
    private final @UnknownKeyFor @NonNull @Initialized String tableId;
    private final @UnknownKeyFor @NonNull @Initialized ByteString changeStreamNamePrefix;

    public MetadataTableDao(@UnknownKeyFor @NonNull @Initialized BigtableDataClient dataClient, @UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized ByteString changeStreamNamePrefix) {
        this.dataClient = dataClient;
        this.tableId = tableId;
        this.changeStreamNamePrefix = changeStreamNamePrefix;
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString getChangeStreamNamePrefix() {
        return this.changeStreamNamePrefix;
    }

    private @UnknownKeyFor @NonNull @Initialized ByteString getFullNewPartitionPrefix() {
        return this.changeStreamNamePrefix.concat(MetadataTableAdminDao.NEW_PARTITION_PREFIX);
    }

    private @UnknownKeyFor @NonNull @Initialized ByteString getFullStreamPartitionPrefix() {
        return this.changeStreamNamePrefix.concat(MetadataTableAdminDao.STREAM_PARTITION_PREFIX);
    }

    private @UnknownKeyFor @NonNull @Initialized ByteString getFullDetectNewPartition() {
        return this.changeStreamNamePrefix.concat(MetadataTableAdminDao.DETECT_NEW_PARTITION_SUFFIX);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange convertStreamPartitionRowKeyToPartition(@UnknownKeyFor @NonNull @Initialized ByteString rowKey) throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        int prefixLength = this.changeStreamNamePrefix.size() + MetadataTableAdminDao.STREAM_PARTITION_PREFIX.size();
        return Range.ByteStringRange.toByteStringRange((ByteString)rowKey.substring(prefixLength));
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString convertPartitionToStreamPartitionRowKey(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition) {
        return this.getFullStreamPartitionPrefix().concat(Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)partition));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange convertNewPartitionRowKeyToPartition(@UnknownKeyFor @NonNull @Initialized ByteString rowKey) throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        int prefixLength = this.changeStreamNamePrefix.size() + MetadataTableAdminDao.NEW_PARTITION_PREFIX.size();
        return Range.ByteStringRange.toByteStringRange((ByteString)rowKey.substring(prefixLength));
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString convertPartitionToNewPartitionRowKey(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition) {
        return this.getFullNewPartitionPrefix().concat(Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)partition));
    }

    @javax.annotation.Nullable
    public @UnknownKeyFor @Nullable @Initialized DetectNewPartitionsState readDetectNewPartitionsState() {
        Row row = this.dataClient.readRow(this.tableId, this.getFullDetectNewPartition(), (Filters.Filter)Filters.FILTERS.chain().filter(Filters.FILTERS.family().exactMatch("watermark")).filter(Filters.FILTERS.qualifier().exactMatch("latest")).filter(Filters.FILTERS.limit().cellsPerColumn(1)));
        if (row == null) {
            return null;
        }
        Instant watermark = MetadataTableEncoder.parseWatermarkFromRow(row);
        Instant timestamp = MetadataTableEncoder.parseWatermarkLastUpdatedFromRow(row);
        if (watermark == null || timestamp == null) {
            return null;
        }
        return new DetectNewPartitionsState(watermark, timestamp);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewPartition> readNewPartitionsIncludingDeleted() throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        ArrayList<NewPartition> newPartitions = new ArrayList<NewPartition>();
        Query query = Query.create((String)this.tableId).prefix(this.getFullNewPartitionPrefix()).filter(Filters.FILTERS.limit().cellsPerColumn(1));
        ServerStream rows = this.dataClient.readRows(query);
        for (Row row : rows) {
            Object cell2;
            Range.ByteStringRange childPartition = this.convertNewPartitionRowKeyToPartition(row.getKey());
            ArrayList<ChangeStreamContinuationToken> tokens = new ArrayList<ChangeStreamContinuationToken>();
            for (Object cell2 : row.getCells("initial_continuation_token")) {
                ChangeStreamContinuationToken changeStreamContinuationToken = ChangeStreamContinuationToken.fromByteString((ByteString)cell2.getValue());
                tokens.add(changeStreamContinuationToken);
            }
            if (tokens.isEmpty()) continue;
            ArrayList<Long> parentLowWatermark = new ArrayList<Long>();
            cell2 = row.getCells("parent_low_watermarks").iterator();
            while (cell2.hasNext()) {
                RowCell cell3 = (RowCell)cell2.next();
                parentLowWatermark.add(Longs.fromByteArray((byte[])cell3.getValue().toByteArray()));
            }
            Instant lowWatermark = Instant.ofEpochMilli((long)((Long)Collections.min(parentLowWatermark)));
            newPartitions.add(new NewPartition(childPartition, tokens, lowWatermark));
        }
        return newPartitions;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewPartition> readNewPartitions() throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        ArrayList<NewPartition> newPartitions = new ArrayList<NewPartition>();
        Query query = Query.create((String)this.tableId).prefix(this.getFullNewPartitionPrefix()).filter(Filters.FILTERS.limit().cellsPerColumn(1));
        ServerStream rows = this.dataClient.readRows(query);
        for (Row row : rows) {
            Object cell3;
            long lastUpdatedMicro = 0L;
            HashSet<Range.ByteStringRange> deletedParentPartitions = new HashSet<Range.ByteStringRange>();
            for (RowCell cell2 : row.getCells("should_delete")) {
                lastUpdatedMicro = Math.max(lastUpdatedMicro, cell2.getTimestamp());
                if (!TimestampConverter.microsecondToInstant(cell2.getTimestamp()).plus((ReadableDuration)DELETED_NEW_PARTITION_REEVALUATE_DELAY).isAfterNow()) continue;
                deletedParentPartitions.add(Range.ByteStringRange.toByteStringRange((ByteString)cell2.getQualifier()));
            }
            Range.ByteStringRange childPartition = this.convertNewPartitionRowKeyToPartition(row.getKey());
            ArrayList<ChangeStreamContinuationToken> tokens = new ArrayList<ChangeStreamContinuationToken>();
            for (Object cell3 : row.getCells("initial_continuation_token")) {
                if (deletedParentPartitions.contains(Range.ByteStringRange.toByteStringRange((ByteString)cell3.getQualifier()))) continue;
                ChangeStreamContinuationToken changeStreamContinuationToken = ChangeStreamContinuationToken.fromByteString((ByteString)cell3.getValue());
                tokens.add(changeStreamContinuationToken);
                lastUpdatedMicro = Math.max(lastUpdatedMicro, cell3.getTimestamp());
            }
            if (tokens.isEmpty()) continue;
            ArrayList<Long> parentLowWatermark = new ArrayList<Long>();
            cell3 = row.getCells("parent_low_watermarks").iterator();
            while (cell3.hasNext()) {
                RowCell cell4 = (RowCell)cell3.next();
                if (deletedParentPartitions.contains(Range.ByteStringRange.toByteStringRange((ByteString)cell4.getQualifier()))) continue;
                parentLowWatermark.add(Longs.fromByteArray((byte[])cell4.getValue().toByteArray()));
                lastUpdatedMicro = Math.max(lastUpdatedMicro, cell4.getTimestamp());
            }
            Instant lowWatermark = Instant.ofEpochMilli((long)((Long)Collections.min(parentLowWatermark)));
            newPartitions.add(new NewPartition(childPartition, tokens, lowWatermark, TimestampConverter.microsecondToInstant(lastUpdatedMicro)));
        }
        return newPartitions;
    }

    public void writeNewPartition(@UnknownKeyFor @NonNull @Initialized NewPartition newPartition) {
        ByteString rowKey = this.convertPartitionToNewPartitionRowKey(newPartition.getPartition());
        Range.ByteStringRange parentPartition = newPartition.getChangeStreamContinuationTokens().get(0).getPartition();
        RowMutation rowMutation = RowMutation.create((String)this.tableId, (ByteString)rowKey).setCell("initial_continuation_token", Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)parentPartition), newPartition.getChangeStreamContinuationTokens().get(0).toByteString()).setCell("parent_low_watermarks", Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)parentPartition), newPartition.getLowWatermark().getMillis()).deleteCells("should_delete", Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)parentPartition));
        this.mutateRowWithHardTimeout(rowMutation);
    }

    public void markNewPartitionForDeletion(@UnknownKeyFor @NonNull @Initialized NewPartition newPartition) {
        ByteString rowKey = this.convertPartitionToNewPartitionRowKey(newPartition.getPartition());
        RowMutation rowMutation = RowMutation.create((String)this.tableId, (ByteString)rowKey);
        for (ChangeStreamContinuationToken token : newPartition.getChangeStreamContinuationTokens()) {
            rowMutation.setCell("should_delete", Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)token.getPartition()), 1L);
        }
        this.mutateRowWithHardTimeout(rowMutation);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean deleteNewPartition(@UnknownKeyFor @NonNull @Initialized NewPartition newPartition) {
        ByteString rowKey = this.convertPartitionToNewPartitionRowKey(newPartition.getPartition());
        boolean success = true;
        for (ChangeStreamContinuationToken token : newPartition.getChangeStreamContinuationTokens()) {
            Filters.ChainFilter shouldDelete = Filters.FILTERS.chain().filter(Filters.FILTERS.family().exactMatch("should_delete")).filter(Filters.FILTERS.qualifier().exactMatch(Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)token.getPartition()))).filter(Filters.FILTERS.value().exactMatch(ByteString.copyFrom((byte[])Longs.toByteArray((long)1L))));
            Mutation mutation = Mutation.create().deleteCells("initial_continuation_token", Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)token.getPartition())).deleteCells("parent_low_watermarks", Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)token.getPartition())).deleteCells("should_delete", Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)token.getPartition()));
            ConditionalRowMutation conditionalRowMutation = ConditionalRowMutation.create((String)this.tableId, (ByteString)rowKey).condition((Filters.Filter)shouldDelete).then(mutation);
            success = this.dataClient.checkAndMutateRow(conditionalRowMutation) != false && success;
        }
        return success;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized StreamPartitionWithWatermark> readStreamPartitionsWithWatermark() throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        LOG.debug("Reading stream partitions from metadata table: " + this.getFullStreamPartitionPrefix().toStringUtf8());
        Filters.ChainFilter filterForWatermark = Filters.FILTERS.chain().filter(Filters.FILTERS.limit().cellsPerColumn(1)).filter(Filters.FILTERS.family().exactMatch("watermark")).filter(Filters.FILTERS.qualifier().exactMatch("latest"));
        Filters.ChainFilter filterForLock = Filters.FILTERS.chain().filter(Filters.FILTERS.limit().cellsPerColumn(1)).filter(Filters.FILTERS.family().exactMatch("lock")).filter(Filters.FILTERS.qualifier().exactMatch("latest"));
        Query query = Query.create((String)this.tableId).prefix(this.getFullStreamPartitionPrefix()).filter((Filters.Filter)Filters.FILTERS.interleave().filter((Filters.Filter)filterForWatermark).filter((Filters.Filter)filterForLock));
        ServerStream rows = this.dataClient.readRows(query);
        ArrayList<StreamPartitionWithWatermark> partitions = new ArrayList<StreamPartitionWithWatermark>();
        for (Row row : rows) {
            Instant watermark;
            if (!MetadataTableEncoder.isRowLocked(row) || (watermark = MetadataTableEncoder.parseWatermarkFromRow(row)) == null) continue;
            Range.ByteStringRange partition = this.convertStreamPartitionRowKeyToPartition(row.getKey());
            partitions.add(new StreamPartitionWithWatermark(partition, watermark));
        }
        return partitions;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionRecord> readAllStreamPartitions() throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        Query query = Query.create((String)this.tableId).prefix(this.getFullStreamPartitionPrefix());
        ServerStream rows = this.dataClient.readRows(query);
        ArrayList<PartitionRecord> partitions = new ArrayList<PartitionRecord>();
        for (Row row : rows) {
            PartitionRecord partitionRecord;
            Instant watermark = MetadataTableEncoder.parseWatermarkFromRow(row);
            String uuid = MetadataTableEncoder.parseLockUuid(row);
            Range.ByteStringRange partition = this.convertStreamPartitionRowKeyToPartition(row.getKey());
            String currentToken = MetadataTableEncoder.parseTokenFromRow(row);
            List<ChangeStreamContinuationToken> initialTokens = MetadataTableEncoder.parseInitialContinuationTokens(row);
            if (watermark == null) {
                if (uuid != null) {
                    this.releaseStreamPartitionLockForDeletion(partition, uuid);
                }
                this.deleteStreamPartitionRow(partition);
                LOG.error("Cleaning up corrupted StreamPartition {}", (Object)ByteStringRangeHelper.formatByteStringRange(partition));
                continue;
            }
            if (currentToken != null) {
                ChangeStreamContinuationToken token = ChangeStreamContinuationToken.create((Range.ByteStringRange)partition, (String)currentToken);
                partitionRecord = new PartitionRecord(partition, Collections.singletonList(token), watermark, Collections.emptyList());
            } else {
                partitionRecord = !initialTokens.isEmpty() ? new PartitionRecord(partition, initialTokens, watermark, Collections.emptyList()) : new PartitionRecord(partition, watermark, watermark, Collections.emptyList());
            }
            if (uuid != null) {
                partitionRecord.setUuid(uuid);
            }
            partitions.add(partitionRecord);
        }
        return partitions;
    }

    private void writeToMdTableWatermarkHelper(@UnknownKeyFor @NonNull @Initialized ByteString rowKey, @UnknownKeyFor @NonNull @Initialized Instant watermark, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized ChangeStreamContinuationToken currentToken) {
        RowMutation rowMutation = RowMutation.create((String)this.tableId, (ByteString)rowKey).setCell("watermark", "latest", watermark.getMillis());
        if (currentToken != null) {
            rowMutation.setCell("continuation_token", "latest", currentToken.getToken());
        }
        this.mutateRowWithHardTimeout(rowMutation);
    }

    public void updateDetectNewPartitionWatermark(@UnknownKeyFor @NonNull @Initialized Instant watermark) {
        this.writeToMdTableWatermarkHelper(this.getFullDetectNewPartition(), watermark, null);
    }

    public void updateWatermark(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized Instant watermark, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized ChangeStreamContinuationToken currentToken) {
        this.writeToMdTableWatermarkHelper(this.convertPartitionToStreamPartitionRowKey(partition), watermark, currentToken);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean releaseStreamPartitionLockForDeletion(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized String uuid) {
        ByteString rowKey = this.convertPartitionToStreamPartitionRowKey(partition);
        Filters.ChainFilter lockCellFilter = Filters.FILTERS.chain().filter(Filters.FILTERS.family().exactMatch("lock")).filter(Filters.FILTERS.qualifier().exactMatch("latest")).filter(Filters.FILTERS.value().exactMatch(uuid));
        Mutation deleteCell = Mutation.create().deleteCells("lock", "latest").setCell("should_delete", "latest", 1L);
        ConditionalRowMutation rowMutation = ConditionalRowMutation.create((String)this.tableId, (ByteString)rowKey).condition((Filters.Filter)lockCellFilter).then(deleteCell);
        return this.dataClient.checkAndMutateRow(rowMutation);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean deleteStreamPartitionRow(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition) {
        LOG.debug("Delete metadata row");
        ByteString rowKey = this.convertPartitionToStreamPartitionRowKey(partition);
        Filters.ChainFilter shouldDeleteFilter = Filters.FILTERS.chain().filter(Filters.FILTERS.family().exactMatch("should_delete")).filter(Filters.FILTERS.qualifier().exactMatch("latest")).filter(Filters.FILTERS.value().exactMatch(ByteString.copyFrom((byte[])Longs.toByteArray((long)1L))));
        Mutation deleteRow = Mutation.create().deleteRow();
        ConditionalRowMutation rowMutation = ConditionalRowMutation.create((String)this.tableId, (ByteString)rowKey).condition((Filters.Filter)shouldDeleteFilter).then(deleteRow);
        return this.dataClient.checkAndMutateRow(rowMutation);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean doHoldLock(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized String uuid) {
        Filters.ChainFilter lockCellFilter;
        ByteString rowKey = this.convertPartitionToStreamPartitionRowKey(partition);
        Row row = this.dataClient.readRow(this.tableId, rowKey, (Filters.Filter)(lockCellFilter = Filters.FILTERS.chain().filter(Filters.FILTERS.family().exactMatch("lock")).filter(Filters.FILTERS.qualifier().exactMatch("latest")).filter(Filters.FILTERS.limit().cellsPerRow(1))));
        if (row != null) {
            return ((RowCell)row.getCells().get(0)).getValue().toStringUtf8().equals(uuid);
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean lockAndRecordPartition(@UnknownKeyFor @NonNull @Initialized PartitionRecord partitionRecord) {
        boolean lockAcquired;
        if (this.doHoldLock(partitionRecord.getPartition(), partitionRecord.getUuid())) {
            return true;
        }
        Mutation mutation = Mutation.create().setCell("lock", "latest", partitionRecord.getUuid()).setCell("watermark", "latest", partitionRecord.getParentLowWatermark().getMillis()).deleteCells("should_delete", "latest");
        List<ChangeStreamContinuationToken> tokens = partitionRecord.getChangeStreamContinuationTokens();
        if (tokens != null) {
            for (ChangeStreamContinuationToken token : tokens) {
                mutation.setCell("initial_continuation_token", Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)token.getPartition()), token.toByteString());
            }
        }
        Filters.ChainFilter matchAnyString = Filters.FILTERS.chain().filter(Filters.FILTERS.family().exactMatch("lock")).filter(Filters.FILTERS.qualifier().exactMatch("latest")).filter(Filters.FILTERS.value().regex("\\C*"));
        ConditionalRowMutation rowMutation = ConditionalRowMutation.create((String)this.tableId, (ByteString)this.convertPartitionToStreamPartitionRowKey(partitionRecord.getPartition())).condition((Filters.Filter)matchAnyString).otherwise(mutation);
        boolean bl = lockAcquired = this.dataClient.checkAndMutateRow(rowMutation) == false;
        if (lockAcquired) {
            LOG.info("RCSP: {} acquired lock for uid: {}", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()), (Object)partitionRecord.getUuid());
            return true;
        }
        return this.doHoldLock(partitionRecord.getPartition(), partitionRecord.getUuid());
    }

    public void writeDetectNewPartitionVersion() {
        RowMutation rowMutation = RowMutation.create((String)this.tableId, (ByteString)this.getFullDetectNewPartition()).setCell("version", "latest", 1L);
        this.mutateRowWithHardTimeout(rowMutation);
    }

    public @UnknownKeyFor @NonNull @Initialized HashMap<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange, @UnknownKeyFor @NonNull @Initialized Instant> readDetectNewPartitionMissingPartitions() {
        HashMap missingPartitions = new HashMap();
        Filters.ChainFilter missingPartitionsFilter = Filters.FILTERS.chain().filter(Filters.FILTERS.family().exactMatch("missing_partitions")).filter(Filters.FILTERS.qualifier().exactMatch("latest")).filter(Filters.FILTERS.limit().cellsPerColumn(1));
        Row row = this.dataClient.readRow(this.tableId, this.getFullDetectNewPartition(), (Filters.Filter)missingPartitionsFilter);
        if (row == null || row.getCells("missing_partitions", "latest").isEmpty()) {
            return missingPartitions;
        }
        ByteString serializedMissingPartition = ((RowCell)row.getCells("missing_partitions", "latest").get(0)).getValue();
        try {
            missingPartitions = (HashMap)SerializationUtils.deserialize((byte[])serializedMissingPartition.toByteArray());
        }
        catch (NullPointerException | SerializationException exception) {
            LOG.warn("Failed to deserialize missingPartitions: {}", (Object)exception.toString());
        }
        return missingPartitions;
    }

    public void writeDetectNewPartitionMissingPartitions(@UnknownKeyFor @NonNull @Initialized HashMap<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange, @UnknownKeyFor @NonNull @Initialized Instant> missingPartitionDurations) {
        byte[] serializedMissingPartition = SerializationUtils.serialize(missingPartitionDurations);
        RowMutation rowMutation = RowMutation.create((String)this.tableId, (ByteString)this.getFullDetectNewPartition()).setCell("missing_partitions", ByteString.copyFromUtf8((String)"latest"), ByteString.copyFrom((byte[])serializedMissingPartition));
        this.mutateRowWithHardTimeout(rowMutation);
    }

    @VisibleForTesting
    void mutateRowWithHardTimeout(@UnknownKeyFor @NonNull @Initialized RowMutation rowMutation) {
        ApiFuture mutateRowFuture = this.dataClient.mutateRowAsync(rowMutation);
        try {
            mutateRowFuture.get(BigtableChangeStreamAccessor.MUTATE_ROW_DEADLINE.getSeconds() + 10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            mutateRowFuture.cancel(true);
            throw new RuntimeException("Cancelled mutateRow request after exceeding deadline", timeoutException);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)executionException.getCause();
            }
            throw new RuntimeException(executionException);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(interruptedException);
        }
    }
}

