/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.redshift.bulkloader;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.redshift.bulkloader.RedshiftBulkLoaderData;
import org.apache.hop.pipeline.transforms.redshift.bulkloader.RedshiftBulkLoaderField;
import org.apache.hop.pipeline.transforms.redshift.bulkloader.RedshiftBulkLoaderMeta;

public class RedshiftBulkLoader
extends BaseTransform<RedshiftBulkLoaderMeta, RedshiftBulkLoaderData> {
    private static final Class<?> PKG = RedshiftBulkLoader.class;

    public RedshiftBulkLoader(TransformMeta transformMeta, RedshiftBulkLoaderMeta meta, RedshiftBulkLoaderData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        if (super.init()) {
            try {
                this.verifyDatabaseConnection();
                ((RedshiftBulkLoaderData)this.data).databaseMeta = this.getPipelineMeta().findDatabase(((RedshiftBulkLoaderMeta)this.meta).getConnection(), this.variables);
                if (((RedshiftBulkLoaderMeta)this.meta).isStreamToS3Csv()) {
                    ((RedshiftBulkLoaderData)this.data).writer = HopVfs.getOutputStream((String)this.resolve(((RedshiftBulkLoaderMeta)this.meta).getCopyFromFilename()), (boolean)false, (IVariables)this.variables);
                }
                ((RedshiftBulkLoaderData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, ((RedshiftBulkLoaderData)this.data).databaseMeta);
                ((RedshiftBulkLoaderData)this.data).db.connect();
                this.getDbFields();
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"RedshiftBulkLoader.Connection.Connected", (Object[])new Object[]{((RedshiftBulkLoaderData)this.data).db.getDatabaseMeta()}));
                }
                this.initBinaryDataFields();
                ((RedshiftBulkLoaderData)this.data).db.setAutoCommit(false);
                return true;
            }
            catch (HopException e) {
                this.logError("An error occurred initializing this transform: " + e.getMessage());
                this.stopAll();
                this.setErrors(1L);
            }
        }
        return false;
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            if (this.first && ((RedshiftBulkLoaderMeta)this.meta).isTruncateTable() && !((RedshiftBulkLoaderMeta)this.meta).isOnlyWhenHaveRows()) {
                this.truncateTable();
            }
            if (!this.first) {
                try {
                    ((RedshiftBulkLoaderData)this.data).close();
                    this.closeFile();
                    String copyStmt = this.buildCopyStatementSqlString();
                    Connection conn = ((RedshiftBulkLoaderData)this.data).db.getConnection();
                    Statement stmt = conn.createStatement();
                    stmt.executeUpdate(copyStmt);
                    conn.commit();
                    stmt.close();
                    conn.close();
                }
                catch (SQLException sqle) {
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    throw new HopDatabaseException("Error executing COPY statements", (Throwable)sqle);
                }
                catch (IOException ioe) {
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    throw new HopTransformException("Error releasing resources", (Throwable)ioe);
                }
            }
            return false;
        }
        if (this.first && ((RedshiftBulkLoaderMeta)this.meta).isStreamToS3Csv()) {
            this.first = false;
            ((RedshiftBulkLoaderData)this.data).fieldnrs = new HashMap<String, Integer>();
            if (((RedshiftBulkLoaderMeta)this.meta).isTruncateTable()) {
                this.truncateTable();
            }
            ((RedshiftBulkLoaderData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((RedshiftBulkLoaderMeta)this.meta).getFields(((RedshiftBulkLoaderData)this.data).insertRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            if (((RedshiftBulkLoaderMeta)this.meta).isStreamToS3Csv()) {
                // empty if block
            }
            if (!((RedshiftBulkLoaderMeta)this.meta).specifyFields()) {
                ((RedshiftBulkLoaderData)this.data).insertRowMeta = this.getInputRowMeta().clone();
                ((RedshiftBulkLoaderData)this.data).selectedRowFieldIndices = new int[((RedshiftBulkLoaderData)this.data).insertRowMeta.size()];
                try {
                    this.getDbFields();
                }
                catch (HopException e) {
                    this.logError("Error getting database fields", e);
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                for (int i = 0; i < ((RedshiftBulkLoaderMeta)this.meta).getFields().size(); ++i) {
                    int streamFieldLocation = ((RedshiftBulkLoaderData)this.data).insertRowMeta.indexOfValue(((RedshiftBulkLoaderMeta)this.meta).getFields().get(i).getStreamField());
                    if (streamFieldLocation < 0) {
                        throw new HopTransformException("Field [" + ((RedshiftBulkLoaderMeta)this.meta).getFields().get(i).getStreamField() + "] couldn't be found in the input stream!");
                    }
                    int dbFieldLocation = -1;
                    for (int e = 0; e < ((RedshiftBulkLoaderData)this.data).dbFields.size(); ++e) {
                        String[] field = ((RedshiftBulkLoaderData)this.data).dbFields.get(e);
                        if (!field[0].equalsIgnoreCase(((RedshiftBulkLoaderMeta)this.meta).getFields().get(i).getDatabaseField())) continue;
                        dbFieldLocation = e;
                        break;
                    }
                    if (dbFieldLocation < 0) {
                        throw new HopException("Field [" + ((RedshiftBulkLoaderMeta)this.meta).getFields().get(i).getDatabaseField() + "] couldn't be found in the table!");
                    }
                    ((RedshiftBulkLoaderData)this.data).fieldnrs.put(((RedshiftBulkLoaderMeta)this.meta).getFields().get(i).getDatabaseField().toUpperCase(), streamFieldLocation);
                }
            } else {
                int numberOfInsertFields = ((RedshiftBulkLoaderMeta)this.meta).getFields().size();
                ((RedshiftBulkLoaderData)this.data).insertRowMeta = new RowMeta();
                ((RedshiftBulkLoaderData)this.data).selectedRowFieldIndices = new int[numberOfInsertFields];
                for (int i = 0; i < ((RedshiftBulkLoaderMeta)this.meta).getFields().size(); ++i) {
                    RedshiftBulkLoaderField vbf = ((RedshiftBulkLoaderMeta)this.meta).getFields().get(i);
                    String inputFieldName = vbf.getStreamField();
                    int inputFieldIdx = i;
                    if (inputFieldIdx < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"RedshiftBulkLoader.Exception.FieldRequired", (String[])new String[]{inputFieldName}));
                    }
                    ((RedshiftBulkLoaderData)this.data).selectedRowFieldIndices[i] = inputFieldIdx;
                    String insertFieldName = vbf.getDatabaseField();
                    IValueMeta inputValueMeta = this.getInputRowMeta().getValueMeta(inputFieldIdx);
                    if (inputValueMeta == null) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"RedshiftBulkLoader.Exception.FailedToFindField", (String[])new String[]{vbf.getStreamField()}));
                    }
                    IValueMeta insertValueMeta = inputValueMeta.clone();
                    insertValueMeta.setName(insertFieldName);
                    ((RedshiftBulkLoaderData)this.data).insertRowMeta.addValueMeta(insertValueMeta);
                    ((RedshiftBulkLoaderData)this.data).fieldnrs.put(((RedshiftBulkLoaderMeta)this.meta).getFields().get(i).getDatabaseField().toUpperCase(), inputFieldIdx);
                }
            }
        }
        if (((RedshiftBulkLoaderMeta)this.meta).isStreamToS3Csv()) {
            this.writeRowToFile(((RedshiftBulkLoaderData)this.data).outputRowMeta, r);
            this.putRow(((RedshiftBulkLoaderData)this.data).outputRowMeta, r);
        }
        return true;
    }

    private boolean closeFile() {
        boolean returnValue = false;
        try {
            if (((RedshiftBulkLoaderData)this.data).writer != null) {
                ((RedshiftBulkLoaderData)this.data).writer.flush();
                ((RedshiftBulkLoaderData)this.data).writer.close();
            }
            ((RedshiftBulkLoaderData)this.data).writer = null;
            if (this.isDebug()) {
                this.logDebug("Closing normal file ...");
            }
            returnValue = true;
        }
        catch (Exception e) {
            this.logError("Exception trying to close file: " + e.toString());
            this.setErrors(1L);
            returnValue = false;
        }
        return returnValue;
    }

    private String buildCopyStatementSqlString() {
        DatabaseMeta databaseMeta = ((RedshiftBulkLoaderData)this.data).db.getDatabaseMeta();
        StringBuilder sb = new StringBuilder(150);
        sb.append("COPY ");
        sb.append(databaseMeta.getQuotedSchemaTableCombination(this.variables, ((RedshiftBulkLoaderData)this.data).db.resolve(((RedshiftBulkLoaderMeta)this.meta).getSchemaName()), ((RedshiftBulkLoaderData)this.data).db.resolve(((RedshiftBulkLoaderMeta)this.meta).getTableName())));
        if (((RedshiftBulkLoaderMeta)this.meta).isStreamToS3Csv() || ((RedshiftBulkLoaderMeta)this.meta).getLoadFromExistingFileFormat().equals("CSV")) {
            sb.append(" (");
            List<RedshiftBulkLoaderField> fieldList = ((RedshiftBulkLoaderMeta)this.meta).getFields();
            for (int i = 0; i < fieldList.size(); ++i) {
                RedshiftBulkLoaderField field = fieldList.get(i);
                if (i > 0) {
                    sb.append(", ").append(field.getDatabaseField());
                    continue;
                }
                sb.append(field.getDatabaseField());
            }
            sb.append(")");
        }
        sb.append(" FROM '" + this.resolve(((RedshiftBulkLoaderMeta)this.meta).getCopyFromFilename()) + "'");
        if (((RedshiftBulkLoaderMeta)this.meta).isStreamToS3Csv() || ((RedshiftBulkLoaderMeta)this.meta).getLoadFromExistingFileFormat().equals("CSV")) {
            sb.append(" DELIMITER ',' ");
            sb.append(" CSV QUOTE AS '\"'");
            sb.append(" NULL '' ");
            sb.append(" EMPTYASNULL ");
            sb.append("DATEFORMAT AS 'YYYY/MM/DD' ");
            sb.append("TIMEFORMAT AS 'YYYY/MM/DD HH:MI:SS'");
        }
        if (((RedshiftBulkLoaderMeta)this.meta).isUseAwsIamRole()) {
            sb.append(" iam_role '" + ((RedshiftBulkLoaderMeta)this.meta).getAwsIamRole() + "'");
        } else if (((RedshiftBulkLoaderMeta)this.meta).isUseCredentials()) {
            String awsAccessKeyId = "";
            String awsSecretAccessKey = "";
            if (((RedshiftBulkLoaderMeta)this.meta).isUseSystemEnvVars()) {
                awsAccessKeyId = System.getenv("AWS_ACCESS_KEY_ID");
                awsSecretAccessKey = System.getenv("AWS_SECRET_ACCESS_KEY");
            } else {
                awsAccessKeyId = this.resolve(((RedshiftBulkLoaderMeta)this.meta).getAwsAccessKeyId());
                awsSecretAccessKey = this.resolve(((RedshiftBulkLoaderMeta)this.meta).getAwsSecretAccessKey());
            }
            sb.append(" CREDENTIALS 'aws_access_key_id=" + awsAccessKeyId + ";aws_secret_access_key=" + awsSecretAccessKey + "'");
        }
        if (!StringUtils.isEmpty((CharSequence)((RedshiftBulkLoaderMeta)this.meta).getLoadFromExistingFileFormat()) && ((RedshiftBulkLoaderMeta)this.meta).getLoadFromExistingFileFormat().equals("Parquet")) {
            sb.append(" FORMAT AS PARQUET;");
        }
        if (this.isDebug()) {
            this.logDebug("copy stmt: " + String.valueOf(sb));
        }
        return sb.toString();
    }

    private Object[] writeToOutputStream(Object[] r) {
        assert (r != null);
        Object[] insertRowData = r;
        Object[] outputRowData = r;
        if (((RedshiftBulkLoaderMeta)this.meta).specifyFields()) {
            insertRowData = new Object[((RedshiftBulkLoaderData)this.data).selectedRowFieldIndices.length];
            for (int idx = 0; idx < ((RedshiftBulkLoaderData)this.data).selectedRowFieldIndices.length; ++idx) {
                insertRowData[idx] = r[((RedshiftBulkLoaderData)this.data).selectedRowFieldIndices[idx]];
            }
        }
        return outputRowData;
    }

    private void getDbFields() throws HopException {
        ((RedshiftBulkLoaderData)this.data).dbFields = new ArrayList();
        IRowMeta rowMeta = null;
        rowMeta = !StringUtils.isEmpty((CharSequence)this.resolve(((RedshiftBulkLoaderMeta)this.meta).getSchemaName())) ? ((RedshiftBulkLoaderData)this.data).db.getTableFields(((RedshiftBulkLoaderMeta)this.meta).getSchemaName() + "." + ((RedshiftBulkLoaderMeta)this.meta).getTableName()) : ((RedshiftBulkLoaderData)this.data).db.getTableFields(((RedshiftBulkLoaderMeta)this.meta).getTableName());
        try {
            if (rowMeta.isEmpty()) {
                throw new HopException("No fields found in table");
            }
            for (int i = 0; i < rowMeta.size(); ++i) {
                String[] field = new String[]{rowMeta.getValueMeta(i).getName().toUpperCase(), rowMeta.getValueMeta(i).getTypeDesc().toUpperCase()};
                ((RedshiftBulkLoaderData)this.data).dbFields.add(field);
            }
        }
        catch (Exception ex) {
            throw new HopException("Error getting database fields", (Throwable)ex);
        }
    }

    protected void verifyDatabaseConnection() throws HopException {
        if (((RedshiftBulkLoaderMeta)this.meta).getConnection() == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.Error.NoConnection", (String[])new String[0]));
        }
    }

    private void initBinaryDataFields() throws HopException {
        try {
            ((RedshiftBulkLoaderData)this.data).binarySeparator = new byte[0];
            ((RedshiftBulkLoaderData)this.data).binaryEnclosure = new byte[0];
            ((RedshiftBulkLoaderData)this.data).binaryNewline = new byte[0];
            ((RedshiftBulkLoaderData)this.data).escapeCharacters = new byte[0];
            ((RedshiftBulkLoaderData)this.data).binarySeparator = this.resolve(",").getBytes(StandardCharsets.UTF_8);
            ((RedshiftBulkLoaderData)this.data).binaryEnclosure = this.resolve("\"").getBytes(StandardCharsets.UTF_8);
            ((RedshiftBulkLoaderData)this.data).binaryNewline = "\n".getBytes(StandardCharsets.UTF_8);
            ((RedshiftBulkLoaderData)this.data).escapeCharacters = "\"".getBytes(StandardCharsets.UTF_8);
            ((RedshiftBulkLoaderData)this.data).binaryNullValue = "".getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new HopException("Unexpected error while encoding binary fields", (Throwable)e);
        }
    }

    private void writeRowToFile(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        try {
            if (((RedshiftBulkLoaderMeta)this.meta).isStreamToS3Csv() && !((RedshiftBulkLoaderMeta)this.meta).isSpecifyFields()) {
                for (int i = 0; i < rowMeta.size(); ++i) {
                    if (i > 0 && ((RedshiftBulkLoaderData)this.data).binarySeparator.length > 0) {
                        ((RedshiftBulkLoaderData)this.data).writer.write(((RedshiftBulkLoaderData)this.data).binarySeparator);
                    }
                    IValueMeta v = rowMeta.getValueMeta(i);
                    Object valueData = row[i];
                    this.writeField(v, valueData, null);
                }
                ((RedshiftBulkLoaderData)this.data).writer.write(((RedshiftBulkLoaderData)this.data).binaryNewline);
            } else if (((RedshiftBulkLoaderMeta)this.meta).isStreamToS3Csv() && ((RedshiftBulkLoaderMeta)this.meta).isSpecifyFields()) {
                for (int i = 0; i < ((RedshiftBulkLoaderMeta)this.meta).getFields().size(); ++i) {
                    if (((RedshiftBulkLoaderMeta)this.meta).getFields().get(i).getDatabaseField() == null) continue;
                    if (i > 0 && ((RedshiftBulkLoaderData)this.data).binarySeparator.length > 0) {
                        ((RedshiftBulkLoaderData)this.data).writer.write(((RedshiftBulkLoaderData)this.data).binarySeparator);
                    }
                    IValueMeta v = null;
                    String streamFieldName = ((RedshiftBulkLoaderMeta)this.meta).getFields().get(i).getStreamField();
                    String[] rowFields = ((RedshiftBulkLoaderData)this.data).outputRowMeta.getFieldNames();
                    String streamFieldType = "";
                    int streamIndex = -1;
                    for (int j = 0; j < rowFields.length; ++j) {
                        if (!streamFieldName.equals(rowFields[j])) continue;
                        v = rowMeta.getValueMeta(j);
                        streamIndex = j;
                    }
                    boolean needConversion = false;
                    if (v.getType() == 9) {
                        v = new ValueMetaDate();
                        v.setConversionMask("yyyy/MM/dd HH:mm:ss.SSS");
                        needConversion = true;
                    } else if (v.getType() == 3) {
                        v = new ValueMetaDate();
                        v.setConversionMask("yyyy/MM/dd");
                        needConversion = true;
                    }
                    Object valueData = null;
                    if (streamIndex >= 0) {
                        if (needConversion) {
                            IValueMeta valueMeta = rowMeta.getValueMeta(streamIndex);
                            Object obj = row[streamIndex];
                            valueData = v.convertData(valueMeta, obj);
                        } else {
                            valueData = row[streamIndex];
                        }
                    } else if (((RedshiftBulkLoaderMeta)this.meta).isErrorColumnMismatch()) {
                        throw new HopException("Error column mismatch: Database streamField " + ((RedshiftBulkLoaderMeta)this.meta).getFields().get(i).getStreamField() + " not found on stream.");
                    }
                    this.writeField(v, valueData, ((RedshiftBulkLoaderData)this.data).binaryNullValue);
                }
                ((RedshiftBulkLoaderData)this.data).writer.write(((RedshiftBulkLoaderData)this.data).binaryNewline);
            } else {
                int jsonField = ((RedshiftBulkLoaderData)this.data).fieldnrs.get("json");
                ((RedshiftBulkLoaderData)this.data).writer.write(((RedshiftBulkLoaderData)this.data).insertRowMeta.getString(row, jsonField).getBytes(StandardCharsets.UTF_8));
                ((RedshiftBulkLoaderData)this.data).writer.write(((RedshiftBulkLoaderData)this.data).binaryNewline);
            }
        }
        catch (Exception e) {
            throw new HopTransformException("Error writing line", (Throwable)e);
        }
    }

    private void writeField(IValueMeta v, Object valueData, byte[] nullString) throws HopTransformException {
        try {
            byte[] str = nullString != null && v.isNull(valueData) ? nullString : this.formatField(v, valueData);
            if (str != null && str.length > 0) {
                List<Integer> enclosures = null;
                boolean writeEnclosures = false;
                if (v.isString()) {
                    writeEnclosures = true;
                    if (this.containsSeparatorOrEnclosure(str, ((RedshiftBulkLoaderData)this.data).binarySeparator, ((RedshiftBulkLoaderData)this.data).binaryEnclosure, ((RedshiftBulkLoaderData)this.data).escapeCharacters)) {
                        writeEnclosures = true;
                    }
                }
                if (writeEnclosures) {
                    ((RedshiftBulkLoaderData)this.data).writer.write(((RedshiftBulkLoaderData)this.data).binaryEnclosure);
                    enclosures = this.getEnclosurePositions(str);
                }
                if (enclosures == null) {
                    ((RedshiftBulkLoaderData)this.data).writer.write(str);
                } else {
                    int from = 0;
                    for (Integer enclosure : enclosures) {
                        int position = enclosure;
                        ((RedshiftBulkLoaderData)this.data).writer.write(str, from, position - from);
                        ((RedshiftBulkLoaderData)this.data).writer.write(((RedshiftBulkLoaderData)this.data).escapeCharacters);
                        from = position;
                    }
                    if (from < str.length) {
                        ((RedshiftBulkLoaderData)this.data).writer.write(str, from, str.length - from);
                    }
                }
                if (writeEnclosures) {
                    ((RedshiftBulkLoaderData)this.data).writer.write(((RedshiftBulkLoaderData)this.data).binaryEnclosure);
                }
            }
        }
        catch (Exception e) {
            throw new HopTransformException("Error writing field content to file", (Throwable)e);
        }
    }

    private byte[] formatField(IValueMeta v, Object valueData) throws HopValueException {
        if (v.isString()) {
            String string;
            if (v.isStorageBinaryString() && v.getTrimType() == 0 && v.getLength() < 0 && StringUtils.isEmpty((CharSequence)v.getStringEncoding())) {
                return (byte[])valueData;
            }
            String svalue = valueData instanceof String ? (string = (String)valueData) : v.getString(valueData);
            return this.convertStringToBinaryString(v, Const.trimToType((String)svalue, (int)v.getTrimType()));
        }
        return v.getBinaryString(valueData);
    }

    private byte[] convertStringToBinaryString(IValueMeta v, String string) {
        int length = v.getLength();
        if (string == null) {
            return new byte[0];
        }
        if (length > -1 && length < string.length()) {
            String tmp = string.substring(0, length);
            return tmp.getBytes(StandardCharsets.UTF_8);
        }
        byte[] text = string.getBytes(StandardCharsets.UTF_8);
        return text;
    }

    private boolean containsSeparatorOrEnclosure(byte[] source, byte[] separator, byte[] enclosure, byte[] escape) {
        boolean escapeExists;
        boolean result = false;
        boolean enclosureExists = enclosure != null && enclosure.length > 0;
        boolean separatorExists = separator != null && separator.length > 0;
        boolean bl = escapeExists = escape != null && escape.length > 0;
        if (separatorExists || enclosureExists || escapeExists) {
            block0: for (int index = 0; !result && index < source.length; ++index) {
                int i;
                if (enclosureExists && source[index] == enclosure[0]) {
                    if (index + enclosure.length > source.length) continue;
                    result = true;
                    for (i = 1; i < enclosure.length; ++i) {
                        if (source[index + i] == enclosure[i]) continue;
                        result = false;
                        continue block0;
                    }
                    continue;
                }
                if (separatorExists && source[index] == separator[0]) {
                    if (index + separator.length > source.length) continue;
                    result = true;
                    for (i = 1; i < separator.length; ++i) {
                        if (source[index + i] == separator[i]) continue;
                        result = false;
                        continue block0;
                    }
                    continue;
                }
                if (!escapeExists || source[index] != escape[0] || index + escape.length > source.length) continue;
                result = true;
                for (i = 1; i < escape.length; ++i) {
                    if (source[index + i] == escape[i]) continue;
                    result = false;
                    continue block0;
                }
            }
        }
        return result;
    }

    private List<Integer> getEnclosurePositions(byte[] str) {
        ArrayList<Integer> positions = null;
        int len = str.length;
        for (int i = 0; i < len; ++i) {
            int x;
            boolean found = true;
            for (x = 0; found && x < ((RedshiftBulkLoaderData)this.data).binaryEnclosure.length; ++x) {
                if (str[i + x] == ((RedshiftBulkLoaderData)this.data).binaryEnclosure[x]) continue;
                found = false;
            }
            if (!found) {
                found = true;
                for (x = 0; found && x < ((RedshiftBulkLoaderData)this.data).escapeCharacters.length; ++x) {
                    if (str[i + x] == ((RedshiftBulkLoaderData)this.data).escapeCharacters[x]) continue;
                    found = false;
                }
            }
            if (!found) continue;
            if (positions == null) {
                positions = new ArrayList<Integer>();
            }
            positions.add(i);
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunning() throws HopException {
        this.setStopped(true);
        if (((RedshiftBulkLoaderData)this.data).workerThread != null) {
            Thread thread = ((RedshiftBulkLoaderData)this.data).workerThread;
            synchronized (thread) {
                if (((RedshiftBulkLoaderData)this.data).workerThread.isAlive() && !((RedshiftBulkLoaderData)this.data).workerThread.isInterrupted()) {
                    try {
                        ((RedshiftBulkLoaderData)this.data).workerThread.interrupt();
                        ((RedshiftBulkLoaderData)this.data).workerThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        super.stopRunning();
    }

    void truncateTable() throws HopDatabaseException {
        if (((RedshiftBulkLoaderMeta)this.meta).isTruncateTable() && (this.getCopy() == 0 || !Utils.isEmpty((CharSequence)this.getPartitionId()))) {
            ((RedshiftBulkLoaderData)this.data).db.truncateTable(this.resolve(((RedshiftBulkLoaderMeta)this.meta).getSchemaName()), this.resolve(((RedshiftBulkLoaderMeta)this.meta).getTableName()));
        }
    }

    public void dispose() {
        this.setOutputDone();
        try {
            if (this.getErrors() > 0L) {
                ((RedshiftBulkLoaderData)this.data).db.rollback();
            }
        }
        catch (HopDatabaseException e) {
            this.logError("Unexpected error rolling back the database connection.", e);
        }
        if (((RedshiftBulkLoaderData)this.data).workerThread != null) {
            try {
                ((RedshiftBulkLoaderData)this.data).workerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (((RedshiftBulkLoaderData)this.data).db != null) {
            ((RedshiftBulkLoaderData)this.data).db.disconnect();
        }
        super.dispose();
    }
}

