/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WithKeys<@UnknownKeyFor T>
extends PTransform<PCollection<T>, PCollection<KV<Row, T>>> {
    private final @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor;

    public static <T> @UnknownKeyFor @NonNull @Initialized WithKeys<T> of(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
        return new WithKeys<T>(fieldAccessDescriptor);
    }

    private WithKeys(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
        this.fieldAccessDescriptor = fieldAccessDescriptor;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, T>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
        Schema schema = input.getSchema();
        TypeDescriptor<T> typeDescriptor = input.getTypeDescriptor();
        if (typeDescriptor == null) {
            throw new RuntimeException("Null type descriptor on input.");
        }
        SerializableFunction<T, Row> toRowFunction = input.getToRowFunction();
        SerializableFunction<Row, T> fromRowFunction = input.getFromRowFunction();
        FieldAccessDescriptor resolved = this.fieldAccessDescriptor.resolve(schema);
        final SelectHelpers.RowSelectorContainer rowSelector = new SelectHelpers.RowSelectorContainer(schema, resolved, true);
        Schema keySchema = SelectHelpers.getOutputSchema(schema, resolved);
        return ((PCollection)input.apply("selectKeys", ParDo.of(new DoFn<T, KV<Row, T>>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, @DoFn.Element T element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, T>> o) {
                o.output(KV.of(rowSelector.select(row), element));
            }
        }))).setCoder(KvCoder.of(SchemaCoder.of(keySchema), SchemaCoder.of(schema, typeDescriptor, toRowFunction, fromRowFunction)));
    }
}

