/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.sdk.harness.JvmInitializer;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmInitializers {
    private static final @UnknownKeyFor @NonNull @Initialized AtomicBoolean initialized = new AtomicBoolean(false);

    public static void runOnStartup() {
        for (JvmInitializer initializer : ReflectHelpers.loadServicesOrdered(JvmInitializer.class)) {
            System.out.format("Running JvmInitializer#onStartup for %s%n", initializer);
            initializer.onStartup();
            System.out.format("Completed JvmInitializer#onStartup for %s%n", initializer);
        }
    }

    public static void runBeforeProcessing(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        Logger logger = LoggerFactory.getLogger(JvmInitializers.class);
        try {
            for (JvmInitializer initializer : ReflectHelpers.loadServicesOrdered(JvmInitializer.class)) {
                logger.info("Running JvmInitializer#beforeProcessing for {}", (Object)initializer);
                initializer.beforeProcessing(options);
                logger.info("Completed JvmInitializer#beforeProcessing for {}", (Object)initializer);
            }
            initialized.compareAndSet(false, true);
        }
        catch (Error e) {
            if (initialized.get()) {
                logger.warn("Error at JvmInitializer#beforeProcessing. This error is suppressed after previous success runs. It is expected on Embedded environment", (Throwable)e);
            }
            throw e;
        }
    }
}

