/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput;

import java.io.InputStream;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.spreadsheet.IKWorkbook;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transforms.excelinput.SpreadSheetType;
import org.apache.hop.pipeline.transforms.excelinput.ods.OdfWorkbook;
import org.apache.hop.pipeline.transforms.excelinput.poi.PoiWorkbook;
import org.apache.hop.pipeline.transforms.excelinput.staxpoi.StaxPoiWorkbook;

public class WorkbookFactory {
    private WorkbookFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static IKWorkbook getWorkbook(SpreadSheetType type, String filename, String encoding, IVariables variables) throws HopException {
        return switch (type) {
            case SpreadSheetType.POI -> new PoiWorkbook(filename, encoding, variables);
            case SpreadSheetType.SAX_POI -> new StaxPoiWorkbook(filename, encoding, variables);
            case SpreadSheetType.ODS -> new OdfWorkbook(filename, encoding, variables);
            default -> throw new HopException("Sorry, spreadsheet type " + type.getDescription() + " is not yet supported");
        };
    }

    public static IKWorkbook getWorkbook(SpreadSheetType type, InputStream inputStream, String encoding) throws HopException {
        return switch (type) {
            case SpreadSheetType.POI -> new PoiWorkbook(inputStream, encoding);
            case SpreadSheetType.SAX_POI -> new StaxPoiWorkbook(inputStream, encoding);
            case SpreadSheetType.ODS -> new OdfWorkbook(inputStream, encoding);
            default -> throw new HopException("Sorry, spreadsheet type " + type.getDescription() + " is not yet supported");
        };
    }
}

