/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import io.github.spannm.jackcess.TableBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.ucanaccess.converters.DFunction;
import net.ucanaccess.converters.Pivot;
import net.ucanaccess.converters.TypesMap;
import net.ucanaccess.exception.InvalidCreateStatementException;
import net.ucanaccess.jdbc.NormalizedSQL;
import net.ucanaccess.jdbc.UcanaccessConnection;

public final class SQLConverter {
    private static final String NAME_PAT = "(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)";
    private static final int NAME_PAT_STEP = 4;
    private static final String UNION = "(;)(\\s*)((?i)UNION)(\\s*)";
    private static final String BACKTICK = "(`)([^`]*)(`)";
    private static final String DELETE_ALL = "((?i)DELETE\\s+)(\\*)(\\s+(?i)FROM\\s+)";
    private static final String PARAMETERS = "(?i)PARAMETERS([^;]*);";
    private static final String BIG_BANG = "1899-12-30";
    private static final List<String> KEYWORDS_LIST = List.of("ALL", "AND", "ANY", "ALTER", "AS", "AT", "AVG", "BETWEEN", "BOTH", "BY", "CALL", "CASE", "CAST", "CHECK", "COALESCE", "CORRESPONDING", "CONVERT", "COUNT", "CREATE", "CROSS", "DEFAULT", "DISTINCT", "DROP", "ELSE", "EVERY", "EXISTS", "EXCEPT", "FOR", "FOREIGN", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "IN", "INNER", "INTERSECT", "INTO", "IS", "JOIN", "LEFT", "LEADING", "LIKE", "MAX", "MIN", "NATURAL", "NOT", "NULLIF", "ON", "ORDER", "OR", "OUTER", "PRIMARY", "REFERENCES", "RIGHT", "SELECT", "SET", "SOME", "STDDEV_POP", "STDDEV_SAMP", "SUM", "TABLE", "THEN", "TO", "TRAILING", "TRIGGER", "UNION", "UNIQUE", "USING", "VALUES", "VAR_POP", "VAR_SAMP", "WHEN", "WHERE", "WITH", "END", "DO", "CONSTRAINT", "USER", "ROW");
    private static final Pattern PAT_KEYWORD_ALIAS = Pattern.compile("(\\s+AS\\s+)(" + KEYWORDS_LIST.stream().filter(s -> !"SELECT".equals(s)).collect(Collectors.joining("|")) + ")(\\W)", 2);
    public static final String DATE_ACCESS_FORMAT = "(0[1-9]|[1-9]|1[012])/(0[1-9]|[1-9]|[12][0-9]|3[01])/(\\d\\d\\d\\d)";
    public static final String DATE_FORMAT = "(\\d\\d\\d\\d)-(0[1-9]|[1-9]|1[012])-(0[1-9]|[1-9]|[12][0-9]|3[01])";
    public static final String HHMMSS_ACCESS_FORMAT = "([0-9]|0[0-9]|1[0-9]|2[0-4]):([0-9]|[0-5][0-9]):([0-9]|[0-5][0-9])";
    public static final String HHMMSS_FORMAT = "([0-9]|0[0-9]|1[0-9]|2[0-4]):([0-9]|[0-5][0-9]):([0-5][0-9]|[0-9])";
    private static final List<String> PROCEDURE_KEYWORDS = List.of("NEW", "ROW");
    private static final List<String> WHITE_SPACED_TABLE_NAMES = new ArrayList<String>();
    private static final Set<String> ESCAPED_IDENTIFIERS = new HashSet<String>();
    private static final Set<String> ALREADY_ESCAPED_IDENTIFIERS = new HashSet<String>();
    private static final Map<String, String> IDENTIFIERS_CONTAINING_KEYWORD = new HashMap<String, String>();
    private static final Set<String> APOSTROPHISED_NAMES = new HashSet<String>();
    private static final Set<String> WORKAROUND_FUNCTIONS = new HashSet<String>();
    private static boolean supportsAccessLike = true;
    private static boolean dualUsedAsTableName = false;

    private SQLConverter() {
    }

    public static boolean hasIdentity(String sql) {
        return sql.indexOf("@@") > 0 && sql.toUpperCase(Locale.US).indexOf("@@IDENTITY") > 0;
    }

    private static void aliases(String sql, NormalizedSQL nsql) {
        int init;
        Matcher m = Patterns.SELECT_FROM_START.matcher((CharSequence)sql);
        if (m.find() && (m = Patterns.SELECT_FROM_END.matcher((CharSequence)(sql = ((String)sql).substring(init = m.end())))).find()) {
            int end = m.start();
            sql = ((String)sql).substring(0, end);
            m = Patterns.UNESCAPED_ALIAS.matcher((CharSequence)sql);
            while (m.find()) {
                int e = m.end();
                char[] sqlc = ((String)(sql = ((String)sql).substring(e) + " ")).toCharArray();
                if (sqlc[0] != '[') {
                    StringBuilder sb = new StringBuilder();
                    for (char c : sqlc) {
                        if (c == ' ' || c == '\n' || c == '\r' || c == ',') {
                            String key = SQLConverter.preEscapingIdentifier(sb.toString());
                            nsql.put(key, sb.toString());
                            break;
                        }
                        sb.append(c);
                    }
                }
                m = Patterns.UNESCAPED_ALIAS.matcher((CharSequence)sql);
            }
        }
    }

    public static String preprocess(String sql, Object key) {
        String end;
        Matcher m1 = Patterns.SELECT_IDENTITY.matcher(sql);
        Matcher m2 = Patterns.HAS_FROM.matcher(sql);
        String string = end = m1.matches() && !m2.find() ? " FROM DUAL" : "";
        if (key instanceof String) {
            key = "'" + key + "'";
        }
        return Patterns.IDENTITY.matcher(sql).replaceAll("$1" + key + "$3") + end;
    }

    public static boolean isListedAsKeyword(String s) {
        return s != null && KEYWORDS_LIST.contains(s.toUpperCase());
    }

    private static int[] getQuoteGroup(String _s) {
        if (!_s.contains("''")) {
            Matcher m = Patterns.QUOTE_M.matcher(_s);
            if (m.find()) {
                return new int[]{m.start(), m.end()};
            }
        } else {
            int[] ret = new int[]{-1, -1};
            Matcher m = Patterns.QUOTE_S.matcher(_s);
            while (m.find()) {
                int start = m.start();
                int end = m.end();
                if ((end - start) % 2 == 0) {
                    if (ret[0] != -1) continue;
                    return new int[]{m.start(), m.end()};
                }
                if (ret[0] == -1) {
                    ret[0] = m.start();
                    continue;
                }
                ret[1] = m.end();
                return ret;
            }
        }
        return new int[0];
    }

    private static int[] getDoubleQuoteGroup(String _s) {
        if (!_s.contains("\"\"")) {
            Matcher m = Patterns.DOUBLE_QUOTE_M.matcher(_s);
            if (m.find()) {
                return new int[]{m.start(), m.end()};
            }
        } else {
            int[] ret = new int[]{-1, -1};
            Matcher mc = Patterns.DOUBLE_QUOTE_S.matcher(_s);
            while (mc.find()) {
                int start = mc.start();
                int end = mc.end();
                if ((end - start) % 2 == 0) {
                    if (ret[0] != -1) continue;
                    return new int[]{mc.start(), mc.end()};
                }
                if (ret[0] == -1) {
                    ret[0] = mc.start();
                    continue;
                }
                ret[1] = mc.end();
                return ret;
            }
        }
        return new int[0];
    }

    static void addWAFunctionName(String name) {
        WORKAROUND_FUNCTIONS.add(name);
    }

    public static DDLType getDDLType(String s) {
        return DDLType.getDDLType(s);
    }

    private static String replaceWorkAroundFunctions(String sql) {
        for (String waFun : WORKAROUND_FUNCTIONS) {
            sql = sql.replaceAll("(\\W)(?i)" + waFun + "\\s*\\(", "$1" + waFun + "WA(");
        }
        sql = sql.replaceAll("(\\W)(?i)STDEV\\s*\\(", "$1STDDEV_SAMP(");
        sql = sql.replaceAll("(\\W)(?i)STDEVP\\s*\\(", "$1STDDEV_POP(");
        sql = sql.replaceAll("(\\W)(?i)VAR\\s*\\(", "$1VAR_SAMP(");
        sql = sql.replaceAll("(\\W)(?i)VARP\\s*\\(", "$1VAR_POP(");
        return sql.replaceAll("(\\W)(?i)currentUser\\s*\\(", "$1user(");
    }

    public static String restoreWorkAroundFunctions(String sql) {
        for (String waFun : WORKAROUND_FUNCTIONS) {
            sql = sql.replaceAll("(\\W)(?i)" + waFun + "WA\\s*\\(", "$1" + waFun + "(");
        }
        sql = sql.replaceAll("(\\W)(?i)STDDEV_SAMP\\s*\\(", "$1STDEV(");
        sql = sql.replaceAll("(\\W)(?i)STDDEV_POP\\s*\\(", "$1STDEVP(");
        sql = sql.replaceAll("(\\W)(?i)VAR_SAMP\\s*\\(", "$1VAR(");
        sql = sql.replaceAll("(\\W)(?i)VAR_POP\\s*\\(", "$1VARP(");
        return sql.replaceAll("(\\W)(?i)user\\s*\\(", "$1currentUser(");
    }

    private static String replaceBacktick(String sql) {
        return sql.replaceAll(BACKTICK, "[$2]");
    }

    private static String replaceAposNames(String sql) {
        for (String an : APOSTROPHISED_NAMES) {
            sql = sql.replaceAll("(?i)" + Pattern.quote("[" + an + "]"), "[" + SQLConverter.basicEscapingIdentifier(an) + "]");
        }
        return sql;
    }

    public static NormalizedSQL convertSQL(String sql, boolean creatingQuery) {
        return SQLConverter.convertSQL(sql, null, creatingQuery);
    }

    public static NormalizedSQL convertSQL(String _sql, UcanaccessConnection _conn, boolean _creatingQuery) {
        NormalizedSQL nsql = new NormalizedSQL();
        Object sql = _sql + " ";
        SQLConverter.aliases((String)sql, nsql);
        sql = SQLConverter.replaceBacktick((String)sql);
        sql = SQLConverter.replaceAposNames((String)sql);
        sql = SQLConverter.convertUnion((String)sql);
        sql = SQLConverter.convertAccessDate((String)sql);
        sql = SQLConverter.convertQuotedAliases((String)sql, nsql);
        sql = SQLConverter.escape((String)sql);
        sql = SQLConverter.convertLike((String)sql);
        sql = SQLConverter.replaceWhiteSpacedTables((String)sql);
        if (!_creatingQuery) {
            Pivot.checkAndRefreshPivot((String)sql, _conn);
            sql = DFunction.convertDFunctions((String)sql, _conn);
        }
        sql = ((String)sql).trim();
        nsql.setSql((String)sql);
        return nsql;
    }

    private static String replaceExclamationPoints(String sql) {
        return Patterns.EXCLAM_POINT.matcher(sql).replaceAll(".$2$3");
    }

    private static String convertOwnerAccess(String sql) {
        return Patterns.WITH_OWNERACCESS_OPTION.matcher(sql).replaceAll("");
    }

    private static String convertDeleteAll(String sql) {
        return sql.replaceAll(DELETE_ALL, "$1$3");
    }

    private static String convertUnion(String sql) {
        return sql.replaceAll(UNION, "$2$3$4");
    }

    private static String convertYesNo(String sql) {
        Matcher m = Patterns.NO_DATA.matcher((CharSequence)(sql = Patterns.YES.matcher((CharSequence)sql).replaceAll("$1true$2")));
        sql = m.find() ? Patterns.NO.matcher(((String)sql).substring(0, m.start())).replaceAll("$1false$2") + ((String)sql).substring(m.start()) : Patterns.NO.matcher((CharSequence)sql).replaceAll("$1false$2");
        return sql;
    }

    private static String convertQuotedAliases(String sql, NormalizedSQL nsql) {
        Matcher m = Patterns.KIND_OF_SUBQUERY.matcher((CharSequence)sql);
        while (m.find()) {
            String g2 = m.group(2).trim();
            if (g2.endsWith(";")) {
                g2 = g2.substring(0, g2.length() - 1);
            }
            sql = ((String)sql).substring(0, m.start()) + "(" + g2 + ")" + ((String)sql).substring(m.end());
            m = Patterns.KIND_OF_SUBQUERY.matcher((CharSequence)sql);
        }
        HashSet<String> hs = new HashSet<String>();
        String sqle = sql;
        Object sqlN = "";
        Matcher m2 = Patterns.QUOTED_ALIAS.matcher(sqle);
        while (m2.find()) {
            String g2 = m2.group(2);
            if (g2.indexOf(39) >= 0 || g2.indexOf(34) >= 0) {
                hs.add(g2);
            }
            String value = g2.substring(1, g2.length() - 1);
            nsql.put(SQLConverter.preEscapingIdentifier(value), value);
            sqlN = (String)sqlN + sqle.substring(0, m2.start()) + m2.group(1) + g2.replaceAll("['\"]", "") + m2.group(3);
            sqle = sqle.substring(m2.end());
            m2 = Patterns.QUOTED_ALIAS.matcher(sqle);
        }
        sql = (String)sqlN + sqle;
        for (String escaped : hs) {
            sql = ((String)sql).replaceAll("\\[" + escaped.substring(1, escaped.length() - 1) + "\\]", escaped.replaceAll("['\"]", ""));
        }
        return sql;
    }

    private static String replaceDistinctRow(String sql) {
        return Patterns.DISTINCT_ROW.matcher(sql).replaceAll(" DISTINCT ");
    }

    static void addWhiteSpacedTableNames(String _name) {
        if (_name == null) {
            return;
        }
        String name = SQLConverter.basicEscapingIdentifier(_name);
        if (name == null || WHITE_SPACED_TABLE_NAMES.contains(name)) {
            return;
        }
        for (String alrIn : WHITE_SPACED_TABLE_NAMES) {
            if (!name.contains(alrIn)) continue;
            WHITE_SPACED_TABLE_NAMES.add(WHITE_SPACED_TABLE_NAMES.indexOf(alrIn), name);
            return;
        }
        WHITE_SPACED_TABLE_NAMES.add(name);
    }

    public static NormalizedSQL convertSQL(String sql) {
        return SQLConverter.convertSQL(sql, null, false);
    }

    public static NormalizedSQL convertSQL(String sql, UcanaccessConnection conn) {
        return SQLConverter.convertSQL(sql, conn, false);
    }

    public static String convertAccessDate(String sql) {
        sql = sql.replaceAll("#(0[1-9]|[1-9]|1[012])/(0[1-9]|[1-9]|[12][0-9]|3[01])/(\\d\\d\\d\\d)#", "Timestamp('$3-$1-$2 00:00:00')").replaceAll("#(0[1-9]|[1-9]|1[012])/(0[1-9]|[1-9]|[12][0-9]|3[01])/(\\d\\d\\d\\d)\\s*(([0-9]|0[0-9]|1[0-9]|2[0-4]):([0-9]|[0-5][0-9]):([0-9]|[0-5][0-9]))#", "Timestamp0('$3-$1-$2 $4')").replaceAll("#(0[1-9]|[1-9]|1[012])/(0[1-9]|[1-9]|[12][0-9]|3[01])/(\\d\\d\\d\\d)\\s*(([0-9]|0[0-9]|1[0-9]|2[0-4]):([0-9]|[0-5][0-9]):([0-9]|[0-5][0-9]))\\s*(?i)AM#", "Timestamp0('$3-$1-$2 $4')").replaceAll("#(0[1-9]|[1-9]|1[012])/(0[1-9]|[1-9]|[12][0-9]|3[01])/(\\d\\d\\d\\d)\\s*(([0-9]|0[0-9]|1[0-9]|2[0-4]):([0-9]|[0-5][0-9]):([0-9]|[0-5][0-9]))\\s*(?i)PM#", "(Timestamp0('$3-$1-$2 $4')+ 12 Hour) ").replaceAll("#(\\d\\d\\d\\d)-(0[1-9]|[1-9]|1[012])-(0[1-9]|[1-9]|[12][0-9]|3[01])#", "Timestamp0('$1-$2-$3 00:00:00')").replaceAll("#(\\d\\d\\d\\d)-(0[1-9]|[1-9]|1[012])-(0[1-9]|[1-9]|[12][0-9]|3[01])\\s*(([0-9]|0[0-9]|1[0-9]|2[0-4]):([0-9]|[0-5][0-9]):([0-9]|[0-5][0-9]))#", "Timestamp0('$1-$2-$3 $4')").replaceAll("#(\\d\\d\\d\\d)-(0[1-9]|[1-9]|1[012])-(0[1-9]|[1-9]|[12][0-9]|3[01])\\s*(([0-9]|0[0-9]|1[0-9]|2[0-4]):([0-9]|[0-5][0-9]):([0-9]|[0-5][0-9]))\\s*(?i)AM#", "Timestamp0('$1-$2-$3 $4')").replaceAll("#(\\d\\d\\d\\d)-(0[1-9]|[1-9]|1[012])-(0[1-9]|[1-9]|[12][0-9]|3[01])\\s*(([0-9]|0[0-9]|1[0-9]|2[0-4]):([0-9]|[0-5][0-9]):([0-9]|[0-5][0-9]))\\s*(?i)PM#", "(Timestamp0('$1-$2-$3 $4')+ 12 Hour)").replaceAll("#(([0-9]|0[0-9]|1[0-9]|2[0-4]):([0-9]|[0-5][0-9]):([0-9]|[0-5][0-9]))#", "Timestamp'1899-12-30 $1'").replaceAll("#(([0-9]|0[0-9]|1[0-9]|2[0-4]):([0-9]|[0-5][0-9]):([0-9]|[0-5][0-9]))\\s*(?i)AM#", "Timestamp'1899-12-30 $1'").replaceAll("#(([0-9]|0[0-9]|1[0-9]|2[0-4]):([0-9]|[0-5][0-9]):([0-9]|[0-5][0-9]))\\s*(?i)PM#", "(Timestamp'1899-12-30 $1'+ 12 Hour)");
        return sql;
    }

    private static String replaceWhiteSpacedTables(String sql) {
        String[] sqls = sql.split("'", -1);
        StringBuilder sb = new StringBuilder();
        String cm = "";
        for (int i = 0; i < sqls.length; ++i) {
            sb.append(cm).append(i % 2 == 0 ? SQLConverter.replaceWhiteSpacedTables(sqls[i], "\"") : sqls[i]);
            cm = "'";
        }
        return sb.toString();
    }

    private static String replaceWhiteSpacedTables(String sql, String character) {
        String[] sqls = sql.split(character, -1);
        StringBuilder sb = new StringBuilder();
        String cm = "";
        for (int i = 0; i < sqls.length; ++i) {
            sb.append(cm).append(i % 2 == 0 ? SQLConverter.replaceWhiteSpacedTableNames0(sqls[i]) : sqls[i]);
            cm = character;
        }
        return sb.toString();
    }

    private static String replaceWhiteSpacedTableNames0(String sql) {
        if (WHITE_SPACED_TABLE_NAMES.isEmpty()) {
            return sql;
        }
        StringBuilder sb = new StringBuilder("(");
        String or = "";
        for (String bst : WHITE_SPACED_TABLE_NAMES) {
            sb.append(or).append("(?i)").append(Pattern.quote(bst));
            or = "|";
        }
        for (String bst : WHITE_SPACED_TABLE_NAMES) {
            String dw = bst.replace(" ", "  ");
            sql = sql.replaceAll(Pattern.quote(dw), bst);
        }
        sb.append(")");
        sql = sql.replaceAll("([^A-Za-z0-9\"])" + sb + "([^A-Za-z0-9\"])", " $1\"$2\"$3");
        return sql;
    }

    private static String convertIdentifiers(String _sql) {
        int init = ((String)_sql).indexOf(91);
        if (init != -1) {
            String tryContent;
            String tryConversion;
            int end = ((String)_sql).indexOf(93);
            if (end < init) {
                return SQLConverter.convertResidualSql((String)_sql);
            }
            String content = ((String)_sql).substring(init + 1, end);
            if (content.indexOf(32) > 0 && !(tryConversion = SQLConverter.convertXescaped(tryContent = " " + content + " ")).equalsIgnoreCase(tryContent)) {
                IDENTIFIERS_CONTAINING_KEYWORD.put(tryConversion.trim(), content.toUpperCase());
            }
            boolean isKeyword = SQLConverter.isListedAsKeyword(content);
            content = SQLConverter.basicEscapingIdentifier(content).toUpperCase();
            String subs = " ";
            if (content != null && !isKeyword && (content.indexOf(32) > 0 || Patterns.NO_ALPHANUMERIC.matcher(content).find())) {
                subs = "\"";
            }
            _sql = SQLConverter.convertResidualSql(((String)_sql).substring(0, init)) + subs + content + subs + SQLConverter.convertIdentifiers(((String)_sql).substring(end + 1));
        } else {
            _sql = SQLConverter.convertResidualSql((String)_sql);
        }
        return _sql;
    }

    private static String convertResidualSql(String sql) {
        if ("!".equals(sql = SQLConverter.convertSQLTokens(sql))) {
            return ".";
        }
        return SQLConverter.replaceExclamationPoints(SQLConverter.replaceDigitStartingIdentifiers(Patterns.UNDERSCORE_IDENTIFIERS.matcher(sql).replaceAll("$1Z$2$5")));
    }

    private static String convertSQLTokens(String sql) {
        return SQLConverter.convertDeleteAll(SQLConverter.replaceWorkAroundFunctions(SQLConverter.convertOwnerAccess(SQLConverter.replaceDistinctRow(SQLConverter.convertYesNo(sql.replace("&", "||"))))));
    }

    private static String replaceDigitStartingIdentifiers(String sql) {
        Matcher m = Patterns.DIGIT_STARTING_IDENTIFIERS.matcher((CharSequence)sql);
        if (m.find()) {
            String grp0 = m.group(0);
            if (Character.isLetter(grp0.charAt(0))) {
                return sql;
            }
            String prefix = grp0.matches("\\.([0-9])+[Ee]([0-9])+\\s") || grp0.matches("\\.([0-9])+[Ee][-+]") ? "" : "Z_";
            String build = m.group(1) + prefix + m.group(2);
            sql = ((String)sql).substring(0, m.start()) + build + SQLConverter.replaceDigitStartingIdentifiers(m.group(7) + ((String)sql).substring(m.end()));
        }
        return sql;
    }

    private static String convertXescaped(String sqlc) {
        for (String xidt : ESCAPED_IDENTIFIERS) {
            sqlc = sqlc.replaceAll("(\\W)((?i)X)((?i)_)(\\W)".replace("_", xidt), "$1$3$4");
        }
        return sqlc;
    }

    private static String convertPartIdentifiers(String sql) {
        String sqlc = SQLConverter.convertIdentifiers(sql);
        sqlc = SQLConverter.convertXescaped(sqlc);
        for (Map.Entry<String, String> entry : IDENTIFIERS_CONTAINING_KEYWORD.entrySet()) {
            sqlc = sqlc.replaceAll("(?i)\"" + entry.getKey() + "\"", "\"" + entry.getValue() + "\"");
        }
        sqlc = PAT_KEYWORD_ALIAS.matcher(sqlc).replaceAll("$1\"$2\"$3");
        return sqlc;
    }

    private static String escape(String sql) {
        int li = Math.max(sql.lastIndexOf(34), sql.lastIndexOf(39));
        boolean enddq = sql.endsWith("\"") || sql.endsWith("'");
        String suff = enddq ? "" : sql.substring(li + 1);
        suff = SQLConverter.convertPartIdentifiers(suff);
        Object tsql = enddq ? sql : sql.substring(0, li + 1);
        int[] fd = SQLConverter.getDoubleQuoteGroup((String)tsql);
        int[] fs = SQLConverter.getQuoteGroup((String)tsql);
        if (fd.length > 0 || fs.length > 0) {
            boolean inid = fs.length == 0 || fd.length > 0 && fd[0] < fs[0];
            int[] mcr = inid ? fd : fs;
            String group = ((String)tsql).substring(mcr[0] + 1, mcr[1] - 1);
            if (inid) {
                group = group.replace("'", "''").replace("\"\"", "\"");
            }
            String str = ((String)tsql).substring(0, mcr[0]);
            str = SQLConverter.convertPartIdentifiers(str);
            tsql = str + "'" + group + "'" + SQLConverter.escape(((String)tsql).substring(mcr[1]));
        } else {
            tsql = SQLConverter.convertPartIdentifiers((String)tsql);
        }
        return (String)tsql + suff;
    }

    public static void cleanEscaped() {
        ESCAPED_IDENTIFIERS.removeAll(ALREADY_ESCAPED_IDENTIFIERS);
    }

    public static String procedureEscapingIdentifier(String name) {
        if (PROCEDURE_KEYWORDS.contains(((String)name).toUpperCase())) {
            name = "\"" + ((String)name).toUpperCase() + "\"";
        }
        return name;
    }

    public static String preEscapingIdentifier(String _name) {
        if (_name.isEmpty()) {
            return _name;
        }
        if (_name.startsWith("~")) {
            return null;
        }
        String nl = _name.toUpperCase(Locale.US);
        if (TableBuilder.isReservedWord((String)nl)) {
            ESCAPED_IDENTIFIERS.add(nl);
        }
        if (_name.contains("'") || _name.indexOf(34) > 0) {
            APOSTROPHISED_NAMES.add(_name);
        }
        if (nl.startsWith("X") && TableBuilder.isReservedWord((String)nl.substring(1))) {
            ALREADY_ESCAPED_IDENTIFIERS.add(nl.substring(1));
        }
        Object escaped = _name;
        escaped = _name.replace("'", "").replace("\"", "").replaceAll(Pattern.quote("\\"), "_");
        if (!((String)escaped).isEmpty() && Character.isDigit(((String)escaped).trim().charAt(0))) {
            escaped = "Z_" + ((String)escaped).trim();
        }
        if (!((String)escaped).isEmpty() && ((String)escaped).charAt(0) == '_') {
            escaped = "Z" + (String)escaped;
        }
        if (dualUsedAsTableName && "DUAL".equalsIgnoreCase((String)escaped)) {
            escaped = "DUAL_13031971";
        }
        return ((String)escaped).toUpperCase(Locale.US);
    }

    private static String escapeKeywordIdentifier(String _escaped, boolean _quote) {
        if (SQLConverter.isListedAsKeyword(_escaped)) {
            return _quote ? "\"" + _escaped + "\"" : "[" + _escaped + "]";
        }
        return _escaped;
    }

    public static String basicEscapingIdentifier(String name) {
        return SQLConverter.escapeKeywordIdentifier(SQLConverter.preEscapingIdentifier(name), true);
    }

    public static String escapeIdentifier(String name, Connection conn) {
        return SQLConverter.checkLang(SQLConverter.escapeIdentifier(name), conn, true);
    }

    public static String completeEscaping(String escaped, boolean quote) {
        return SQLConverter.hsqlEscape(SQLConverter.escapeKeywordIdentifier(escaped, quote), quote);
    }

    public static String completeEscaping(String escaped) {
        return SQLConverter.completeEscaping(escaped, true);
    }

    private static String hsqlEscape(String escaped, boolean quote) {
        if (escaped != null && (((String)escaped).indexOf(32) > 0 || ((String)escaped).contains("$"))) {
            escaped = quote ? "\"" + (String)escaped + "\"" : "[" + (String)escaped + "]";
        }
        return escaped;
    }

    public static String checkLang(String _name, Connection _conn) {
        return SQLConverter.checkLang(_name, _conn, true);
    }

    public static String checkLang(String _name, Connection _conn, boolean _quote) {
        String string;
        block9: {
            String name = _name;
            if (!_quote) {
                name = _name.replace(Pattern.quote("["), "\"").replace(Pattern.quote("]"), "\"");
            }
            Statement st = _conn.createStatement();
            try {
                st.execute(String.format("SELECT 1 AS %s FROM dual", name));
                string = _name;
                if (st == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException _ex) {
                    return _quote ? "\"" + _name + "\"" : "[" + _name + "]";
                }
            }
            st.close();
        }
        return string;
    }

    public static String escapeIdentifier(String name) {
        String escaped = SQLConverter.basicEscapingIdentifier(name);
        if (escaped == null) {
            return null;
        }
        return SQLConverter.hsqlEscape(escaped, true);
    }

    public static boolean couldNeedDefault(String typeDeclaration) {
        Matcher m = Patterns.DEFAULT_CATCH_0.matcher(typeDeclaration);
        return !m.find() && Patterns.NOT_NULL.matcher(typeDeclaration).find();
    }

    public static String convertAddColumn(String tableName, String columnName, String _typeDeclaration) {
        String typeDeclaration = SQLConverter.convertTypeDeclaration(_typeDeclaration);
        Matcher m = Patterns.DEFAULT_CATCH_0.matcher(typeDeclaration = Patterns.NOT_NULL.matcher(typeDeclaration).replaceAll(""));
        if (m.find()) {
            typeDeclaration = typeDeclaration.substring(0, m.start());
        }
        return "ALTER TABLE " + tableName + " ADD COLUMN " + columnName + typeDeclaration;
    }

    private static String convertTypeDeclaration(String typeDecl) {
        typeDecl = " " + (String)typeDecl + " ";
        for (Map.Entry<String, String> entry : TypesMap.getAccess2HsqlTypesMap().entrySet()) {
            typeDecl = ((String)typeDecl).replaceAll("(\\s+)((?i)" + entry.getKey() + ")([\\s\\(]+)", "$1" + entry.getValue() + "$3");
        }
        return Patterns.DEFAULT_VARCHAR_0.matcher((CharSequence)typeDecl).replaceAll("$1VARCHAR(255)$2");
    }

    private static String convertCreateTable(String _sql, Map<String, String> _types2Convert) throws SQLException {
        if (_sql == null || _sql.isBlank()) {
            return _sql;
        }
        Object sql = _sql + " ";
        if (!((String)sql).contains("(")) {
            return sql;
        }
        String pre = ((String)sql).substring(0, ((String)sql).indexOf(40));
        sql = ((String)sql).substring(((String)sql).indexOf(40));
        String exprTypesTranslate = "(?i)_(\\W)";
        for (Map.Entry<String, String> entry : _types2Convert.entrySet()) {
            sql = ((String)sql).replaceAll("([,\\(]\\s*)" + exprTypesTranslate.replace("_", entry.getKey()), "$1___" + entry.getKey() + "___$2").replaceAll("(\\W)" + exprTypesTranslate.replace("_", entry.getKey()), "$1" + entry.getValue() + "$2").replaceAll("(\\W)" + exprTypesTranslate.replace("_", "___" + entry.getKey() + "___"), "$1" + entry.getKey() + "$2");
        }
        sql = Patterns.DEFAULT_VARCHAR.matcher((CharSequence)sql).replaceAll("$1VARCHAR(255)$2");
        sql = SQLConverter.clearDefaultsCreateStatement(pre + (String)sql);
        return sql;
    }

    public static String getDDLDefault(String ddlf) {
        for (Pattern pat : Patterns.DEFAULT_CATCH) {
            Matcher m = pat.matcher(ddlf + " ");
            if (!m.find()) continue;
            return m.group(2);
        }
        return null;
    }

    private static String clearDefaultsCreateStatement(String _sql) throws SQLException {
        int endDecl;
        if (!_sql.toUpperCase().contains("DEFAULT")) {
            return _sql;
        }
        int startDecl = _sql.indexOf(40);
        if (startDecl >= (endDecl = _sql.lastIndexOf(41))) {
            throw new InvalidCreateStatementException(_sql);
        }
        for (Pattern pat : Patterns.DEFAULT_CATCH) {
            _sql = pat.matcher(_sql).replaceAll("$3");
        }
        return _sql;
    }

    public static String convertCreateTable(String sql) throws SQLException {
        return SQLConverter.convertCreateTable(sql, TypesMap.getAccess2HsqlTypesMap());
    }

    public static boolean checkDDL(String sql) {
        return sql != null && Patterns.CHECK_DDL.matcher(sql.replaceAll("\\s+", " ")).matches();
    }

    private static String convertLike(String sql) {
        Matcher matcher = Patterns.FIND_LIKE.matcher(sql);
        if (matcher.find()) {
            return sql.substring(0, matcher.start(1)) + SQLConverter.convertLike(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4)) + SQLConverter.convertLike(sql.substring(matcher.end(0)));
        }
        return sql;
    }

    private static String convertToRegexMatches(String likeContent) {
        Matcher mtc = Patterns.ACCESS_LIKE_ESCAPE.matcher(likeContent);
        if (mtc.find()) {
            return SQLConverter.convertToRegexMatches(likeContent.substring(0, mtc.start(0))) + mtc.group(0).charAt(1) + SQLConverter.convertToRegexMatches(likeContent.substring(mtc.end(0)));
        }
        return likeContent.replaceAll("#", "\\\\d").replaceAll("\\*", ".*").replace('_', '.').replaceAll("(\\[)\\!(\\w\\-\\w\\])", "$1^$2");
    }

    private static String convertToLikeCondition(String likeContent) {
        Matcher mtc = Patterns.ACCESS_LIKE_ESCAPE.matcher(likeContent);
        if (mtc.find()) {
            return SQLConverter.convertToLikeCondition(likeContent.substring(0, mtc.start(0))) + mtc.group(0).charAt(1) + SQLConverter.convertToLikeCondition(likeContent.substring(mtc.end(0)));
        }
        return likeContent.replaceAll("\\*", "%").replaceAll("\\?", "_");
    }

    private static String convertLike(String conditionField, String closePar, String not, String likeContent) {
        int i = likeContent.replaceAll("\\[#\\]", "").indexOf(35);
        String string = not = not == null ? "" : " NOT ";
        if (i >= 0 || Patterns.ACCESS_LIKE_CHARINTERVAL.matcher(likeContent).find()) {
            return not + "REGEXP_MATCHES(" + conditionField + ",'" + SQLConverter.convertToRegexMatches(likeContent) + "')" + closePar + " ";
        }
        return " " + conditionField + closePar + not + " like '" + SQLConverter.convertToLikeCondition(likeContent) + "'";
    }

    public static boolean isSupportsAccessLike() {
        return supportsAccessLike;
    }

    public static void setSupportsAccessLike(boolean _supportsAccessLike) {
        supportsAccessLike = _supportsAccessLike;
    }

    public static boolean isXescaped(String identifier) {
        return ESCAPED_IDENTIFIERS.contains(identifier);
    }

    public static String convertFormula(String sql) {
        sql = SQLConverter.convertFormula0(SQLConverter.convertSQL(" " + sql).getSql());
        return sql;
    }

    private static String convertDigit(String sql) {
        Matcher mtc = Patterns.ESPRESSION_DIGIT.matcher(sql);
        char[] cq = sql.toCharArray();
        if (mtc.find()) {
            int idx = mtc.start();
            int idxe = mtc.end();
            boolean replace = true;
            for (int j = idx; j >= 0; --j) {
                if (Character.isDigit(cq[j])) continue;
                if (!Character.isLetter(cq[j])) break;
                replace = false;
                break;
            }
            if (replace) {
                return sql.substring(0, idx) + mtc.group(1) + "E0" + SQLConverter.convertDigit(sql.substring(idxe));
            }
            return sql.substring(0, idxe) + SQLConverter.convertDigit(sql.substring(idxe));
        }
        return sql;
    }

    private static String convertFormula0(String sql) {
        int li = Math.max(sql.lastIndexOf(34), sql.lastIndexOf(39));
        boolean enddq = sql.endsWith("\"") || sql.endsWith("'");
        String suff = enddq ? "" : sql.substring(li + 1);
        suff = SQLConverter.convertDigit(suff);
        Object tsql = enddq ? sql : sql.substring(0, li + 1);
        int[] fd = SQLConverter.getDoubleQuoteGroup((String)tsql);
        int[] fs = SQLConverter.getQuoteGroup((String)tsql);
        if (fd.length > 0 || fs.length > 0) {
            boolean inid = fs.length == 0 || fd.length > 0 && fd[0] < fs[0];
            int[] mcr = inid ? fd : fs;
            String group = ((String)tsql).substring(mcr[0], mcr[1]);
            String str = ((String)tsql).substring(0, mcr[0]);
            str = SQLConverter.convertDigit(str);
            tsql = str + group + SQLConverter.convertFormula0(((String)tsql).substring(mcr[1]));
        } else {
            tsql = SQLConverter.convertDigit((String)tsql);
        }
        return (String)tsql + suff;
    }

    public static String convertPowOperator(String sql) {
        int i = ((String)sql).indexOf(94);
        if (i < 0) {
            return sql;
        }
        while ((i = ((String)sql).indexOf(94)) >= 0) {
            int foi = SQLConverter.firstOperandIndex((String)sql, i);
            int loi = i + SQLConverter.secondOperandIndex((String)sql, i) + 1;
            sql = ((String)sql).substring(0, foi) + " (power(" + ((String)sql).substring(foi, i) + "," + ((String)sql).substring(i + 1, loi + 1) + "))" + ((String)sql).substring(loi + 1);
        }
        return sql;
    }

    private static int secondOperandIndex(String sql, int i) {
        int j;
        sql = sql.substring(i + 1);
        char[] ca = sql.toCharArray();
        boolean foundType = false;
        boolean field = false;
        boolean group = false;
        boolean digit = false;
        int countPar = 0;
        for (j = 0; j < ca.length; ++j) {
            char c = ca[j];
            if (c == ' ') continue;
            if (foundType) {
                if (field && c == ']') {
                    return j;
                }
                if (digit && !Character.isDigit(c) && c != '.') {
                    return j - 1;
                }
                if (!group) continue;
                if (c == '(') {
                    ++countPar;
                }
                if (c != ')' || --countPar != 0) continue;
                return j;
            }
            if (c == '[') {
                foundType = true;
                field = true;
                continue;
            }
            if (c == '(') {
                foundType = true;
                group = true;
                ++countPar;
                continue;
            }
            if (Character.isDigit(c)) {
                foundType = true;
                digit = true;
                continue;
            }
            if (c != '+' && c != '-' || j + 1 >= ca.length || ca[j + 1] == '(' || ca[j + 1] == '[') continue;
            foundType = true;
            digit = true;
        }
        return j - 1;
    }

    private static int firstOperandIndex(String sql, int i) {
        int j;
        sql = sql.substring(0, i);
        char[] ca = sql.toCharArray();
        boolean foundType = false;
        boolean field = false;
        boolean group = false;
        boolean digit = false;
        int countPar = 0;
        for (j = ca.length - 1; j >= 0; --j) {
            char c = ca[j];
            if (c == ' ') continue;
            if (foundType) {
                if (field && c == '[') {
                    return j;
                }
                if (digit && !Character.isDigit(c) && c != '.') {
                    if (!(c != '+' && c != '-' || j <= 0 || ca[j - 1] != '+' && ca[j - 1] != '-')) {
                        return j;
                    }
                    return j + 1;
                }
                if (!group) continue;
                if (c == ')') {
                    ++countPar;
                }
                if (c != '(' || --countPar != 0) continue;
                return j;
            }
            if (c == ']') {
                foundType = true;
                field = true;
                continue;
            }
            if (c == ')') {
                foundType = true;
                group = true;
                ++countPar;
                continue;
            }
            if (!Character.isDigit(c)) continue;
            foundType = true;
            digit = true;
        }
        return j + 1;
    }

    public static int asUnsigned(byte _a) {
        return _a & 0xFF;
    }

    public static Set<String> getFormulaDependencies(String formula) {
        Matcher mtc = Patterns.FORMULA_DEPS.matcher(formula);
        HashSet<String> fd = new HashSet<String>();
        while (mtc.find()) {
            fd.add(SQLConverter.escapeIdentifier(mtc.group(1)));
        }
        return fd;
    }

    static boolean isDualUsedAsTableName() {
        return dualUsedAsTableName;
    }

    static void setDualUsedAsTableName(boolean _dualUsedAsTableName) {
        dualUsedAsTableName = _dualUsedAsTableName;
    }

    public static String removeParameters(String qtxt) {
        return qtxt.replaceAll(PARAMETERS, "");
    }

    public static String getPreparedStatement(String qtxt, List<String> l) {
        String s = qtxt;
        for (String p : l) {
            s = s.replaceAll("(\\W)((?i)" + Pattern.quote(p) + ")(\\W)", "$1?$3");
        }
        return s.replaceAll(Pattern.quote("[?]"), "?");
    }

    public static List<String> getParameters(String s) {
        ArrayList<String> ar = new ArrayList<String>();
        Matcher m = Patterns.FORMULA_DEPS.matcher(s);
        while (m.find()) {
            ar.add(m.group());
            s = s.substring(m.end());
            m = Patterns.FORMULA_DEPS.matcher(s);
        }
        return ar;
    }

    public static final class Patterns {
        private static final Pattern SELECT_FROM_START = Pattern.compile("\\s*SELECT\\s+", 2);
        private static final Pattern SELECT_FROM_END = Pattern.compile("\\s*FROM[\\s\\[]+", 2);
        private static final Pattern UNESCAPED_ALIAS = Pattern.compile("\\s*AS\\s*", 2);
        private static final Pattern QUOTE_S = Pattern.compile("(')+");
        private static final Pattern DOUBLE_QUOTE_S = Pattern.compile("(\")+");
        private static final Pattern QUOTE_M = Pattern.compile("'(([^'])*)'");
        private static final Pattern DOUBLE_QUOTE_M = Pattern.compile("\"(([^\"])*)\"");
        private static final Pattern FIND_LIKE = Pattern.compile("[\\s\\(]*([\\w\\.]*)([\\s\\)]*)(NOT\\s*)*LIKE\\s*'([^']*(?:'')*)'", 2);
        private static final Pattern ACCESS_LIKE_CHARINTERVAL = Pattern.compile("\\[(?:\\!*[a-zA-Z0-9]\\-[a-zA-Z0-9])+\\]");
        private static final Pattern ACCESS_LIKE_ESCAPE = Pattern.compile("\\[[\\*|_|#]\\]");
        private static final Pattern CHECK_DDL = Pattern.compile("^(\\s*(CREATE|ALTER|DROP|ENABLE|DISABLE))\\s+.*", 2);
        private static final Pattern KIND_OF_SUBQUERY = Pattern.compile("(\\[)(( FROM )*(SELECT )*([^\\]])*)(\\]\\.\\s)", 2);
        private static final Pattern NO_DATA = Pattern.compile(" WITH\\s+NO\\s+DATA", 2);
        private static final Pattern NO_ALPHANUMERIC = Pattern.compile("\\W");
        private static final Pattern IDENTITY = Pattern.compile("(\\W+)(@@identity)(\\W*)", 2);
        private static final Pattern SELECT_IDENTITY = Pattern.compile("SELECT\\s+@@identity.*", 2);
        private static final Pattern HAS_FROM = Pattern.compile("\\s+FROM\\s+", 2);
        private static final Pattern FORMULA_DEPS = Pattern.compile("\\[([^\\]]*)\\]");
        private static final Pattern EXCLAM_POINT = Pattern.compile("(\\!)(\\s*)([^\\=])");
        private static final Pattern YES = Pattern.compile("(\\W)YES(\\W)", 2);
        private static final Pattern NO = Pattern.compile("(\\W)NO(\\W)", 2);
        private static final Pattern WITH_OWNERACCESS_OPTION = Pattern.compile("(\\W)WITH\\s+OWNERACCESS\\s+OPTION(\\W)", 2);
        private static final Pattern DIGIT_STARTING_IDENTIFIERS = Pattern.compile("(\\W)(([0-9])+(([_A-Z])+([0-9])*)+)(\\W)", 2);
        private static final Pattern UNDERSCORE_IDENTIFIERS = Pattern.compile("(\\W)((_)+([_A-Z0-9])+)(\\W)", 2);
        private static final List<Pattern> DEFAULT_CATCH = List.of(Pattern.compile("(\\s*DEFAULT\\s+)('(?:[^']*(?:'')*)*')([\\s\\)\\,])", 2), Pattern.compile("(\\s*DEFAULT\\s+)(\"(?:[^\"]*(?:\"\")*)*\")([\\s\\)\\,])", 2), Pattern.compile("(\\s*DEFAULT\\s+)([0-9\\.\\-\\+]+)([\\s\\)\\,])", 2), Pattern.compile("(\\s*DEFAULT\\s+)([_0-9a-zA-Z]*\\([^\\)]*\\))([\\s\\)\\,])", 2));
        private static final Pattern DEFAULT_CATCH_0 = Pattern.compile("(\\s*DEFAULT\\s+)", 2);
        public static final Pattern NOT_NULL = Pattern.compile("\\sNOT\\sNULL", 2);
        private static final Pattern QUOTED_ALIAS = Pattern.compile("(\\s+AS\\s*)(\\[[^\\]]*\\])(\\W)", 2);
        private static final Pattern DISTINCT_ROW = Pattern.compile("\\s+DISTINCTROW\\s+", 2);
        private static final Pattern DEFAULT_VARCHAR = Pattern.compile("(\\W)VARCHAR([\\s,\\)])", 2);
        private static final Pattern DEFAULT_VARCHAR_0 = Pattern.compile("(\\W)VARCHAR([^\\(])", 2);
        private static final Pattern ESPRESSION_DIGIT = Pattern.compile("([\\d]+)(?![\\.\\d])");

        private Patterns() {
        }
    }

    public static enum DDLType {
        CREATE_TABLE_AS_SELECT("\\s*create\\s+table\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)\\s*(?)AS\\s*\\(\\s*((?)SELECT)"),
        CREATE_TABLE("\\s*create\\s+table\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)"),
        DROP_TABLE_CASCADE("\\s*drop\\s+table\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)\\s+cascade"),
        DROP_TABLE("\\s*drop\\s+table\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)"),
        ALTER_RENAME("\\s*alter\\s+table\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)\\s+rename\\s+to\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)"),
        CREATE_PRIMARY_KEY("\\s*alter\\s+table\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)\\s+add\\s+(?:constraint\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)\\s+)?primary\\s+key(.*)"),
        CREATE_FOREIGN_KEY("\\s*alter\\s+table\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)\\s+add\\s+(?:constraint\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)\\s+)?foreign\\s+key\\s+(?:\\(.*\\))\\s*references\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)(.*)"),
        DROP_FOREIGN_KEY("\\s*alter\\s+table\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)\\s+drop\\s+constraint\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)"),
        ADD_COLUMN("\\s*alter\\s+table\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)\\s+add\\s+(?:column\\s+)?(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)(.*)"),
        CREATE_INDEX("CREATE\\s+(?:unique)?\\s*index\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)\\s+ON\\s+(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)\\s+"),
        DISABLE_AUTOINCREMENT("\\s*disable\\s+autoincrement\\s+on\\s*(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)"),
        ENABLE_AUTOINCREMENT("\\s*enable\\s+autoincrement\\s+on\\s*(([_a-zA-Z0-9])+|\\[([^\\]])*\\]|`([^`])*`)");

        private final Pattern pattern;
        private String ddl;

        private DDLType(String _regex) {
            this.pattern = Pattern.compile(_regex, 2);
        }

        public boolean in(DDLType ... types) {
            for (DDLType type : types) {
                if (!this.equals((Object)type)) continue;
                return true;
            }
            return false;
        }

        public static DDLType getDDLType(String s) {
            DDLType[] dts;
            for (DDLType cand : dts = DDLType.values()) {
                if (!cand.pattern.matcher(s).find()) continue;
                if (cand.equals((Object)DROP_TABLE_CASCADE)) {
                    return null;
                }
                cand.ddl = DDLType.elab(s);
                return cand;
            }
            return null;
        }

        private static String elab(String s) {
            if (!s.contains("[") || !s.contains("]")) {
                return s;
            }
            return s.replaceAll("\\[([^\\]]*)\\]", " $0 ");
        }

        public String getDBObjectName() {
            Matcher m = this.pattern.matcher(this.ddl);
            if (m.find()) {
                return m.group(1);
            }
            return null;
        }

        public String getSecondDBObjectName() {
            Matcher m = this.pattern.matcher(this.ddl);
            if (m.find()) {
                return m.group(5);
            }
            return null;
        }

        public String getThirdDBObjectName() {
            Matcher m = this.pattern.matcher(this.ddl);
            if (m.find()) {
                return m.group(9);
            }
            return null;
        }

        public String getColumnDefinition() {
            Matcher m = this.pattern.matcher(this.ddl);
            if (m.find()) {
                return m.group(9);
            }
            return null;
        }

        public String getSelect(String s) {
            Matcher m = this.pattern.matcher(s);
            if (m.find()) {
                return s.substring(m.start(m.groupCount()), s.lastIndexOf(41));
            }
            return null;
        }
    }
}

