/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.ArrayReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroFieldReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.MapReader;
import java.io.IOException;
import java.util.List;

public class StructDefaults {
    public static AvroFieldReader createObjectDefaults(String name, List<AvroFieldReader> fieldReaders) throws IOException {
        return AvroFieldReader.construct(name, new ObjectDefaults(null, null, fieldReaders.toArray(new AvroFieldReader[fieldReaders.size()])));
    }

    public static AvroFieldReader createArrayDefaults(String name, List<AvroFieldReader> fieldReaders) throws IOException {
        return AvroFieldReader.construct(name, new ArrayDefaults(null, null, fieldReaders.toArray(new AvroFieldReader[fieldReaders.size()])));
    }

    protected static class ArrayDefaults
    extends ArrayReader {
        protected final AvroFieldReader[] _valueReaders;

        public ArrayDefaults(AvroReadContext parent, AvroParserImpl parser, AvroFieldReader[] valueReaders) throws IOException {
            super(parent, parser, null, null);
            this._valueReaders = valueReaders;
        }

        @Override
        public ArrayReader newReader(AvroReadContext parent, AvroParserImpl parser) throws IOException {
            return new ArrayDefaults(parent, parser, this._valueReaders);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._state = 1;
                    this._currToken = JsonToken.START_ARRAY;
                    return this._currToken;
                }
                case 1: {
                    if (this._index < this._valueReaders.length) {
                        AvroFieldReader r = this._valueReaders[this._index++];
                        this._currToken = r.readValue(this, this._parser);
                        return this._currToken;
                    }
                    AvroReadContext parent = this.getParent();
                    this._state = 3;
                    this._parser.setAvroContext(parent);
                    this._currToken = JsonToken.END_ARRAY;
                    return this._currToken;
                }
            }
            this.throwIllegalState(this._state);
            return null;
        }

        @Override
        public void skipValue(AvroParserImpl parser) throws IOException {
        }
    }

    protected static class ObjectDefaults
    extends MapReader {
        protected final AvroFieldReader[] _fieldReaders;

        public ObjectDefaults(AvroReadContext parent, AvroParserImpl parser, AvroFieldReader[] fieldReaders) throws IOException {
            super(parent, parser, null, null, null);
            this._fieldReaders = fieldReaders;
        }

        @Override
        public long getRemainingElements() {
            return this._fieldReaders.length - this._index;
        }

        @Override
        public MapReader newReader(AvroReadContext parent, AvroParserImpl parser) throws IOException {
            return new ObjectDefaults(parent, parser, this._fieldReaders);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._state = 1;
                    this._currToken = JsonToken.START_OBJECT;
                    return this._currToken;
                }
                case 1: {
                    if (this._index < this._fieldReaders.length) {
                        this._state = 2;
                        this._currentName = this._fieldReaders[this._index].getName();
                        this._currToken = JsonToken.FIELD_NAME;
                        return this._currToken;
                    }
                    AvroReadContext parent = this.getParent();
                    this._state = 4;
                    this._parser.setAvroContext(parent);
                    this._currToken = JsonToken.END_OBJECT;
                    return this._currToken;
                }
                case 2: {
                    this._state = 1;
                    AvroFieldReader r = this._fieldReaders[this._index++];
                    this._currToken = r.readValue(this, this._parser);
                    return this._currToken;
                }
            }
            this.throwIllegalState(this._state);
            return null;
        }

        @Override
        public void skipValue(AvroParserImpl parser) throws IOException {
        }
    }
}

