/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.data;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.internal.core.util.Strings;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableListMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.ListMultimap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.jcip.annotations.Immutable;

@Immutable
public class IdentifierIndex {
    private final ListMultimap<CqlIdentifier, Integer> byId;
    private final ListMultimap<String, Integer> byCaseSensitiveName;
    private final ListMultimap<String, Integer> byCaseInsensitiveName;

    public IdentifierIndex(List<CqlIdentifier> ids) {
        ImmutableListMultimap.Builder byId = ImmutableListMultimap.builder();
        ImmutableListMultimap.Builder byCaseSensitiveName = ImmutableListMultimap.builder();
        ImmutableListMultimap.Builder byCaseInsensitiveName = ImmutableListMultimap.builder();
        int i = 0;
        for (CqlIdentifier id : ids) {
            byId.put((Object)id, (Object)i);
            byCaseSensitiveName.put((Object)id.asInternal(), (Object)i);
            byCaseInsensitiveName.put((Object)id.asInternal().toLowerCase(Locale.ROOT), (Object)i);
            ++i;
        }
        this.byId = byId.build();
        this.byCaseSensitiveName = byCaseSensitiveName.build();
        this.byCaseInsensitiveName = byCaseInsensitiveName.build();
    }

    public List<Integer> allIndicesOf(String name) {
        return Strings.isDoubleQuoted(name) ? this.byCaseSensitiveName.get((Object)Strings.unDoubleQuote(name)) : this.byCaseInsensitiveName.get((Object)name.toLowerCase(Locale.ROOT));
    }

    public int firstIndexOf(String name) {
        Iterator<Integer> indices = this.allIndicesOf(name).iterator();
        return indices.hasNext() ? indices.next() : -1;
    }

    public List<Integer> allIndicesOf(CqlIdentifier id) {
        return this.byId.get((Object)id);
    }

    public int firstIndexOf(CqlIdentifier id) {
        Iterator<Integer> indices = this.allIndicesOf(id).iterator();
        return indices.hasNext() ? indices.next() : -1;
    }
}

