/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.io.IOException;
import org.apache.hadoop.util.Time;
import org.apache.hive.jdbc.HttpResponseInterceptorBase;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

public class HttpDefaultResponseInterceptor
extends HttpResponseInterceptorBase {
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        String trackHeader = (String)context.getAttribute("X-Request-ID");
        if (trackHeader == null) {
            return;
        }
        String trackTimeHeader = trackHeader + "_TIME";
        long elapsed = Time.monotonicNow() - (Long)context.getAttribute(trackTimeHeader);
        this.LOG.info("Response to {} in {} ms", (Object)trackHeader, (Object)elapsed);
        context.removeAttribute("X-Request-ID");
        context.removeAttribute(trackTimeHeader);
    }
}

