/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileinput.text;

import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileFilter;

public class TextFileFilterProcessor {
    private TextFileFilter[] filters;
    private String[] filtersString;
    private boolean stopProcessing;

    public TextFileFilterProcessor(TextFileFilter[] filters, IVariables variables) {
        this.filters = filters;
        this.stopProcessing = false;
        if (filters.length == 0) {
            filters = null;
        } else {
            this.filtersString = new String[filters.length];
            for (int f = 0; f < filters.length; ++f) {
                this.filtersString[f] = variables.resolve(filters[f].getFilterString());
            }
        }
    }

    public boolean doFilters(String line) {
        if (this.filters == null) {
            return true;
        }
        boolean filterOK = true;
        boolean positiveMode = false;
        boolean positiveMatchFound = false;
        for (int f = 0; f < this.filters.length && filterOK; ++f) {
            boolean isFilterLastLine;
            TextFileFilter filter = this.filters[f];
            String filterString = this.filtersString[f];
            if (filter.isFilterPositive()) {
                positiveMode = true;
            }
            if (Utils.isEmpty((CharSequence)filterString)) continue;
            int from = filter.getFilterPosition();
            if (from >= 0) {
                String sub;
                int to = from + filterString.length();
                if (line.length() >= from && line.length() >= to && (sub = line.substring(filter.getFilterPosition(), to)).equalsIgnoreCase(filterString)) {
                    if (filter.isFilterPositive()) {
                        positiveMatchFound = true;
                    } else {
                        filterOK = false;
                    }
                }
            } else {
                int idx = line.indexOf(filterString);
                if (idx >= 0) {
                    if (filter.isFilterPositive()) {
                        positiveMatchFound = true;
                    } else {
                        filterOK = false;
                    }
                }
            }
            if (filterOK || !(isFilterLastLine = filter.isFilterLastLine())) continue;
            this.stopProcessing = true;
        }
        if (filterOK && positiveMode && !positiveMatchFound) {
            filterOK = false;
        }
        return filterOK;
    }

    public boolean isStopProcessing() {
        return this.stopProcessing;
    }
}

