/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.annotations.Internal;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.client.DriverInformation;
import com.mongodb.internal.client.DriverInformationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MongoDriverInformation {
    private final List<DriverInformation> driverInformationList;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MongoDriverInformation mongoDriverInformation) {
        return new Builder(mongoDriverInformation);
    }

    public List<String> getDriverNames() {
        return DriverInformationHelper.getNames(this.driverInformationList);
    }

    public List<String> getDriverVersions() {
        return DriverInformationHelper.getVersions(this.driverInformationList);
    }

    public List<String> getDriverPlatforms() {
        return DriverInformationHelper.getPlatforms(this.driverInformationList);
    }

    @Internal
    public List<DriverInformation> getDriverInformationList() {
        return this.driverInformationList;
    }

    private MongoDriverInformation(List<DriverInformation> driverInformation) {
        this.driverInformationList = Assertions.notNull("driverInformation", driverInformation);
    }

    @NotThreadSafe
    public static final class Builder {
        private final MongoDriverInformation mongoDriverInformation;
        private String driverName;
        private String driverVersion;
        private String driverPlatform;

        public Builder driverName(String driverName) {
            this.driverName = Assertions.notNull("driverName", driverName);
            return this;
        }

        public Builder driverVersion(String driverVersion) {
            this.driverVersion = Assertions.notNull("driverVersion", driverVersion);
            return this;
        }

        public Builder driverPlatform(String driverPlatform) {
            this.driverPlatform = Assertions.notNull("driverPlatform", driverPlatform);
            return this;
        }

        public MongoDriverInformation build() {
            DriverInformation driverInformation = new DriverInformation(this.driverName, this.driverVersion, this.driverPlatform);
            if (this.mongoDriverInformation.driverInformationList.contains(driverInformation)) {
                return this.mongoDriverInformation;
            }
            ArrayList<DriverInformation> driverInformationList = new ArrayList<DriverInformation>(this.mongoDriverInformation.driverInformationList);
            driverInformationList.add(driverInformation);
            return new MongoDriverInformation(Collections.unmodifiableList(driverInformationList));
        }

        private Builder() {
            this.mongoDriverInformation = new MongoDriverInformation(Collections.emptyList());
        }

        private Builder(MongoDriverInformation driverInformation) {
            this.mongoDriverInformation = Assertions.notNull("driverInformation", driverInformation);
        }
    }
}

