/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.permission;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;

public class APIPermissionSet {
    private Map<String, Set<ObjectPermission.Type>> connectionPermissions = new HashMap();
    private Map<String, Set<ObjectPermission.Type>> connectionGroupPermissions = new HashMap();
    private Map<String, Set<ObjectPermission.Type>> sharingProfilePermissions = new HashMap();
    private Map<String, Set<ObjectPermission.Type>> activeConnectionPermissions = new HashMap();
    private Map<String, Set<ObjectPermission.Type>> userPermissions = new HashMap();
    private Map<String, Set<ObjectPermission.Type>> userGroupPermissions = new HashMap();
    private Set<SystemPermission.Type> systemPermissions = EnumSet.noneOf(SystemPermission.Type.class);

    public APIPermissionSet() {
    }

    private void addSystemPermissions(Set<SystemPermission.Type> permissions, SystemPermissionSet permSet) throws GuacamoleException {
        for (SystemPermission permission : permSet.getPermissions()) {
            permissions.add(permission.getType());
        }
    }

    private void addObjectPermissions(Map<String, Set<ObjectPermission.Type>> permissions, ObjectPermissionSet permSet) throws GuacamoleException {
        for (ObjectPermission permission : permSet.getPermissions()) {
            String identifier = permission.getObjectIdentifier();
            Set<ObjectPermission.Type> objectPermissions = permissions.get(identifier);
            if (objectPermissions == null) {
                permissions.put(identifier, EnumSet.of(permission.getType()));
                continue;
            }
            objectPermissions.add(permission.getType());
        }
    }

    public APIPermissionSet(Permissions permissions) throws GuacamoleException {
        this.addSystemPermissions(this.systemPermissions, permissions.getSystemPermissions());
        this.addObjectPermissions(this.connectionPermissions, permissions.getConnectionPermissions());
        this.addObjectPermissions(this.connectionGroupPermissions, permissions.getConnectionGroupPermissions());
        this.addObjectPermissions(this.sharingProfilePermissions, permissions.getSharingProfilePermissions());
        this.addObjectPermissions(this.activeConnectionPermissions, permissions.getActiveConnectionPermissions());
        this.addObjectPermissions(this.userPermissions, permissions.getUserPermissions());
        this.addObjectPermissions(this.userGroupPermissions, permissions.getUserGroupPermissions());
    }

    public Map<String, Set<ObjectPermission.Type>> getConnectionPermissions() {
        return this.connectionPermissions;
    }

    public Map<String, Set<ObjectPermission.Type>> getConnectionGroupPermissions() {
        return this.connectionGroupPermissions;
    }

    public Map<String, Set<ObjectPermission.Type>> getSharingProfilePermissions() {
        return this.sharingProfilePermissions;
    }

    public Map<String, Set<ObjectPermission.Type>> getActiveConnectionPermissions() {
        return this.activeConnectionPermissions;
    }

    public Map<String, Set<ObjectPermission.Type>> getUserPermissions() {
        return this.userPermissions;
    }

    public Map<String, Set<ObjectPermission.Type>> getUserGroupPermissions() {
        return this.userGroupPermissions;
    }

    public Set<SystemPermission.Type> getSystemPermissions() {
        return this.systemPermissions;
    }

    public void setConnectionPermissions(Map<String, Set<ObjectPermission.Type>> connectionPermissions) {
        this.connectionPermissions = connectionPermissions;
    }

    public void setConnectionGroupPermissions(Map<String, Set<ObjectPermission.Type>> connectionGroupPermissions) {
        this.connectionGroupPermissions = connectionGroupPermissions;
    }

    public void setSharingProfilePermissions(Map<String, Set<ObjectPermission.Type>> sharingProfilePermissions) {
        this.sharingProfilePermissions = sharingProfilePermissions;
    }

    public void setActiveConnectionPermissions(Map<String, Set<ObjectPermission.Type>> activeConnectionPermissions) {
        this.activeConnectionPermissions = activeConnectionPermissions;
    }

    public void setUserPermissions(Map<String, Set<ObjectPermission.Type>> userPermissions) {
        this.userPermissions = userPermissions;
    }

    public void setUserGroupPermissions(Map<String, Set<ObjectPermission.Type>> userGroupPermissions) {
        this.userGroupPermissions = userGroupPermissions;
    }

    public void setSystemPermissions(Set<SystemPermission.Type> systemPermissions) {
        this.systemPermissions = systemPermissions;
    }
}

