/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.rest.auth.DecoratedUserContext;
import org.apache.guacamole.tunnel.UserTunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuacamoleSession {
    private static final Logger logger = LoggerFactory.getLogger(GuacamoleSession.class);
    private AuthenticatedUser authenticatedUser;
    private List<DecoratedUserContext> userContexts;
    private final Map<String, UserTunnel> tunnels = new ConcurrentHashMap();
    private long lastAccessedTime = System.currentTimeMillis();

    public GuacamoleSession(Environment environment, AuthenticatedUser authenticatedUser, List<DecoratedUserContext> userContexts) throws GuacamoleException {
        this.authenticatedUser = authenticatedUser;
        this.userContexts = userContexts;
    }

    public AuthenticatedUser getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    public void setAuthenticatedUser(AuthenticatedUser authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
    }

    public List<DecoratedUserContext> getUserContexts() {
        return Collections.unmodifiableList(this.userContexts);
    }

    public DecoratedUserContext getUserContext(String authProviderIdentifier) throws GuacamoleException {
        for (DecoratedUserContext userContext : this.getUserContexts()) {
            AuthenticationProvider authProvider = userContext.getAuthenticationProvider();
            if (!authProvider.getIdentifier().equals(authProviderIdentifier)) continue;
            return userContext;
        }
        throw new GuacamoleResourceNotFoundException("Session not associated with authentication provider \"" + authProviderIdentifier + "\".");
    }

    public void setUserContexts(List<DecoratedUserContext> userContexts) {
        this.userContexts = userContexts;
    }

    public boolean hasTunnels() {
        return !this.tunnels.isEmpty();
    }

    public Map<String, UserTunnel> getTunnels() {
        return this.tunnels;
    }

    public void addTunnel(UserTunnel tunnel) {
        this.tunnels.put(tunnel.getUUID().toString(), tunnel);
    }

    public boolean removeTunnel(String uuid) {
        return this.tunnels.remove(uuid) != null;
    }

    public void access() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void invalidate() {
        for (GuacamoleTunnel tunnel : this.tunnels.values()) {
            try {
                tunnel.close();
            }
            catch (GuacamoleException e) {
                logger.debug("Unable to close tunnel.", (Throwable)e);
            }
        }
        for (UserContext userContext : this.userContexts) {
            userContext.invalidate();
        }
        this.authenticatedUser.invalidate();
    }
}

