/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ShareAcknowledgeRequestData
implements ApiMessage {
    String groupId;
    String memberId;
    int shareSessionEpoch;
    List<AcknowledgeTopic> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("group_id", Type.COMPACT_NULLABLE_STRING, "The group identifier."), new Field("member_id", Type.COMPACT_NULLABLE_STRING, "The member ID."), new Field("share_session_epoch", Type.INT32, "The current share session epoch: 0 to open a share session; -1 to close it; otherwise increments for consecutive requests."), new Field("topics", new CompactArrayOf(AcknowledgeTopic.SCHEMA_0), "The topics containing records to acknowledge."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ShareAcknowledgeRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ShareAcknowledgeRequestData() {
        this.groupId = null;
        this.memberId = "";
        this.shareSessionEpoch = 0;
        this.topics = new ArrayList<AcknowledgeTopic>(0);
    }

    @Override
    public short apiKey() {
        return 79;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.groupId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupId had invalid length " + length);
            }
            this.groupId = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.memberId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
        }
        this.shareSessionEpoch = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<AcknowledgeTopic> newCollection = new ArrayList<AcknowledgeTopic>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new AcknowledgeTopic(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (this.groupId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.groupId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.memberId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.memberId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.shareSessionEpoch);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        _stringBytes = this.topics.iterator();
        while (_stringBytes.hasNext()) {
            AcknowledgeTopic topicsElement = (AcknowledgeTopic)_stringBytes.next();
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        if (this.groupId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.groupId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.memberId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.memberId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (AcknowledgeTopic topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShareAcknowledgeRequestData)) {
            return false;
        }
        ShareAcknowledgeRequestData other = (ShareAcknowledgeRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        if (this.shareSessionEpoch != other.shareSessionEpoch) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + this.shareSessionEpoch;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public ShareAcknowledgeRequestData duplicate() {
        ShareAcknowledgeRequestData _duplicate = new ShareAcknowledgeRequestData();
        _duplicate.groupId = this.groupId == null ? null : this.groupId;
        _duplicate.memberId = this.memberId == null ? null : this.memberId;
        _duplicate.shareSessionEpoch = this.shareSessionEpoch;
        ArrayList<AcknowledgeTopic> newTopics = new ArrayList<AcknowledgeTopic>(this.topics.size());
        for (AcknowledgeTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "ShareAcknowledgeRequestData(groupId=" + (String)(this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", memberId=" + (String)(this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", shareSessionEpoch=" + this.shareSessionEpoch + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public String memberId() {
        return this.memberId;
    }

    public int shareSessionEpoch() {
        return this.shareSessionEpoch;
    }

    public List<AcknowledgeTopic> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ShareAcknowledgeRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public ShareAcknowledgeRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public ShareAcknowledgeRequestData setShareSessionEpoch(int v) {
        this.shareSessionEpoch = v;
        return this;
    }

    public ShareAcknowledgeRequestData setTopics(List<AcknowledgeTopic> v) {
        this.topics = v;
        return this;
    }

    public static class AcknowledgeTopic
    implements Message {
        Uuid topicId;
        List<AcknowledgePartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_id", Type.UUID, "The unique topic ID."), new Field("partitions", new CompactArrayOf(AcknowledgePartition.SCHEMA_0), "The partitions containing records to acknowledge."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public AcknowledgeTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public AcknowledgeTopic() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<AcknowledgePartition>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AcknowledgeTopic");
            }
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<AcknowledgePartition> newCollection = new ArrayList<AcknowledgePartition>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new AcknowledgePartition(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            for (AcknowledgePartition partitionsElement : this.partitions) {
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AcknowledgeTopic");
            }
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (AcknowledgePartition partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AcknowledgeTopic)) {
                return false;
            }
            AcknowledgeTopic other = (AcknowledgeTopic)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public AcknowledgeTopic duplicate() {
            AcknowledgeTopic _duplicate = new AcknowledgeTopic();
            _duplicate.topicId = this.topicId;
            ArrayList<AcknowledgePartition> newPartitions = new ArrayList<AcknowledgePartition>(this.partitions.size());
            for (AcknowledgePartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "AcknowledgeTopic(topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<AcknowledgePartition> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AcknowledgeTopic setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public AcknowledgeTopic setPartitions(List<AcknowledgePartition> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class AcknowledgementBatch
    implements Message {
        long firstOffset;
        long lastOffset;
        List<Byte> acknowledgeTypes;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("first_offset", Type.INT64, "First offset of batch of records to acknowledge."), new Field("last_offset", Type.INT64, "Last offset (inclusive) of batch of records to acknowledge."), new Field("acknowledge_types", new CompactArrayOf(Type.INT8), "Array of acknowledge types - 0:Gap,1:Accept,2:Release,3:Reject."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public AcknowledgementBatch(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public AcknowledgementBatch() {
            this.firstOffset = 0L;
            this.lastOffset = 0L;
            this.acknowledgeTypes = new ArrayList<Byte>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AcknowledgementBatch");
            }
            this.firstOffset = _readable.readLong();
            this.lastOffset = _readable.readLong();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field acknowledgeTypes was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Byte> newCollection = new ArrayList<Byte>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readByte());
            }
            this.acknowledgeTypes = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeLong(this.firstOffset);
            _writable.writeLong(this.lastOffset);
            _writable.writeUnsignedVarint(this.acknowledgeTypes.size() + 1);
            for (Byte acknowledgeTypesElement : this.acknowledgeTypes) {
                _writable.writeByte(acknowledgeTypesElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AcknowledgementBatch");
            }
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.acknowledgeTypes.size() + 1));
            _size.addBytes(this.acknowledgeTypes.size() * 1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AcknowledgementBatch)) {
                return false;
            }
            AcknowledgementBatch other = (AcknowledgementBatch)obj;
            if (this.firstOffset != other.firstOffset) {
                return false;
            }
            if (this.lastOffset != other.lastOffset) {
                return false;
            }
            if (this.acknowledgeTypes == null ? other.acknowledgeTypes != null : !this.acknowledgeTypes.equals(other.acknowledgeTypes)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.firstOffset >> 32) ^ (int)this.firstOffset);
            hashCode = 31 * hashCode + ((int)(this.lastOffset >> 32) ^ (int)this.lastOffset);
            hashCode = 31 * hashCode + (this.acknowledgeTypes == null ? 0 : this.acknowledgeTypes.hashCode());
            return hashCode;
        }

        @Override
        public AcknowledgementBatch duplicate() {
            AcknowledgementBatch _duplicate = new AcknowledgementBatch();
            _duplicate.firstOffset = this.firstOffset;
            _duplicate.lastOffset = this.lastOffset;
            ArrayList<Byte> newAcknowledgeTypes = new ArrayList<Byte>(this.acknowledgeTypes.size());
            for (Byte _element : this.acknowledgeTypes) {
                newAcknowledgeTypes.add(_element);
            }
            _duplicate.acknowledgeTypes = newAcknowledgeTypes;
            return _duplicate;
        }

        public String toString() {
            return "AcknowledgementBatch(firstOffset=" + this.firstOffset + ", lastOffset=" + this.lastOffset + ", acknowledgeTypes=" + MessageUtil.deepToString(this.acknowledgeTypes.iterator()) + ")";
        }

        public long firstOffset() {
            return this.firstOffset;
        }

        public long lastOffset() {
            return this.lastOffset;
        }

        public List<Byte> acknowledgeTypes() {
            return this.acknowledgeTypes;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AcknowledgementBatch setFirstOffset(long v) {
            this.firstOffset = v;
            return this;
        }

        public AcknowledgementBatch setLastOffset(long v) {
            this.lastOffset = v;
            return this;
        }

        public AcknowledgementBatch setAcknowledgeTypes(List<Byte> v) {
            this.acknowledgeTypes = v;
            return this;
        }
    }

    public static class AcknowledgePartition
    implements Message {
        int partitionIndex;
        List<AcknowledgementBatch> acknowledgementBatches;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("acknowledgement_batches", new CompactArrayOf(AcknowledgementBatch.SCHEMA_0), "Record batches to acknowledge."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public AcknowledgePartition(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public AcknowledgePartition() {
            this.partitionIndex = 0;
            this.acknowledgementBatches = new ArrayList<AcknowledgementBatch>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AcknowledgePartition");
            }
            this.partitionIndex = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field acknowledgementBatches was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<AcknowledgementBatch> newCollection = new ArrayList<AcknowledgementBatch>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new AcknowledgementBatch(_readable, _version));
            }
            this.acknowledgementBatches = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeUnsignedVarint(this.acknowledgementBatches.size() + 1);
            for (AcknowledgementBatch acknowledgementBatchesElement : this.acknowledgementBatches) {
                acknowledgementBatchesElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AcknowledgePartition");
            }
            _size.addBytes(4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.acknowledgementBatches.size() + 1));
            for (AcknowledgementBatch acknowledgementBatchesElement : this.acknowledgementBatches) {
                acknowledgementBatchesElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AcknowledgePartition)) {
                return false;
            }
            AcknowledgePartition other = (AcknowledgePartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.acknowledgementBatches == null ? other.acknowledgementBatches != null : !this.acknowledgementBatches.equals(other.acknowledgementBatches)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + (this.acknowledgementBatches == null ? 0 : this.acknowledgementBatches.hashCode());
            return hashCode;
        }

        @Override
        public AcknowledgePartition duplicate() {
            AcknowledgePartition _duplicate = new AcknowledgePartition();
            _duplicate.partitionIndex = this.partitionIndex;
            ArrayList<AcknowledgementBatch> newAcknowledgementBatches = new ArrayList<AcknowledgementBatch>(this.acknowledgementBatches.size());
            for (AcknowledgementBatch _element : this.acknowledgementBatches) {
                newAcknowledgementBatches.add(_element.duplicate());
            }
            _duplicate.acknowledgementBatches = newAcknowledgementBatches;
            return _duplicate;
        }

        public String toString() {
            return "AcknowledgePartition(partitionIndex=" + this.partitionIndex + ", acknowledgementBatches=" + MessageUtil.deepToString(this.acknowledgementBatches.iterator()) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public List<AcknowledgementBatch> acknowledgementBatches() {
            return this.acknowledgementBatches;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AcknowledgePartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public AcknowledgePartition setAcknowledgementBatches(List<AcknowledgementBatch> v) {
            this.acknowledgementBatches = v;
            return this;
        }
    }
}

