/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.core.DelReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.model.SerializableList;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OUListModel
extends Model<SerializableList<OrgUnit>> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private DelReviewMgr delReviewMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)OUListModel.class.getName());
    private OrgUnit orgUnit;
    private SerializableList<OrgUnit> orgUnits = null;

    public OUListModel(boolean isUser, Session session) {
        Injector.get().inject((Object)this);
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.delReviewMgr.setAdmin(session);
        }
    }

    public OUListModel(OrgUnit orgUnit, Session session) {
        Injector.get().inject((Object)this);
        this.orgUnit = orgUnit;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.delReviewMgr.setAdmin(session);
        }
    }

    public SerializableList<OrgUnit> getObject() {
        if (this.orgUnits != null) {
            LOG.debug(".getObject count: " + this.orgUnits.size());
            return this.orgUnits;
        }
        if (this.orgUnit == null) {
            LOG.debug(".getObject null");
            this.orgUnits = new SerializableList(new ArrayList());
        } else {
            LOG.debug(".getObject orgUnitNm: " + this.orgUnit.getName());
            this.orgUnits = new SerializableList(this.getList(this.orgUnit));
        }
        return this.orgUnits;
    }

    public void setObject(SerializableList<OrgUnit> object) {
        LOG.debug(".setObject count: " + object.size());
        this.orgUnits = object;
    }

    public void detach() {
        this.orgUnits = null;
        this.orgUnit = null;
    }

    private List<OrgUnit> getList(OrgUnit orgUnit) {
        List orgUnitList = null;
        if (orgUnit == null || orgUnit.getType() == null) {
            throw new RuntimeException("Orgunit invalid state");
        }
        try {
            String szOrgUnitNm = orgUnit.getName();
            LOG.debug(".getList orgUnitNm: " + szOrgUnitNm);
            orgUnitList = this.delReviewMgr.search(orgUnit.getType(), orgUnit.getName());
            if (CollectionUtils.isNotEmpty((Collection)orgUnitList)) {
                Collections.sort(orgUnitList, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (SecurityException se) {
            String error = ".getList caught SecurityException=" + se;
            throw new RuntimeException(error, se);
        }
        return orgUnitList;
    }
}

