/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.lang.annotation.Annotation;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

abstract class BooleanExecutionCondition<A extends Annotation>
implements ExecutionCondition {
    private final Class<A> annotationType;
    private final String enabledReason;
    private final String disabledReason;
    private final Function<A, String> customDisabledReason;

    BooleanExecutionCondition(Class<A> annotationType, String enabledReason, String disabledReason, Function<A, String> customDisabledReason) {
        this.annotationType = annotationType;
        this.enabledReason = enabledReason;
        this.disabledReason = disabledReason;
        this.customDisabledReason = customDisabledReason;
    }

    abstract boolean isEnabled(A var1);

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation(context.getElement(), this.annotationType).map(annotation -> this.isEnabled(annotation) ? ConditionEvaluationResult.enabled(this.enabledReason) : ConditionEvaluationResult.disabled(this.disabledReason, this.customDisabledReason.apply(annotation))).orElseGet(this::enabledByDefault);
    }

    private ConditionEvaluationResult enabledByDefault() {
        String reason = String.format("@%s is not present", this.annotationType.getSimpleName());
        return ConditionEvaluationResult.enabled(reason);
    }
}

