/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.om.mapper;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.RecordMapper;

public class ObjectListMapper
implements RecordMapper<List<Object>> {
    private static final long serialVersionUID = 1L;
    private static final byte ZERO_BYTE = 0;
    private static final short ZERO_SHORT = 0;
    private List<Class<?>> convertClasses = null;

    public ObjectListMapper() {
    }

    public ObjectListMapper(int numberOfColumnsToMap) {
        this.convertClasses = new ArrayList(numberOfColumnsToMap);
        if (numberOfColumnsToMap != -1) {
            for (int i = 0; i < numberOfColumnsToMap; ++i) {
                this.convertClasses.add(Object.class);
            }
        }
    }

    public ObjectListMapper(List<Class<?>> convertClasses) {
        if (convertClasses != null) {
            this.convertClasses = new ArrayList(convertClasses);
        }
    }

    @Override
    public List<Object> processRow(ResultSet resultSet, int offset, Criteria criteria) throws TorqueException {
        try {
            int currentNumberOfColumnsToMap;
            if (this.convertClasses != null) {
                currentNumberOfColumnsToMap = this.convertClasses.size();
            } else {
                int resultSetLength = resultSet.getMetaData().getColumnCount();
                currentNumberOfColumnsToMap = resultSetLength - offset;
            }
            ArrayList<Object> result = new ArrayList<Object>(currentNumberOfColumnsToMap);
            for (int i = 0; i < currentNumberOfColumnsToMap; ++i) {
                Object columnValue;
                Class mapClass = this.convertClasses != null ? this.convertClasses.get(i) : Object.class;
                int columnIndex = i + offset + 1;
                if (mapClass.equals(Array.class)) {
                    columnValue = resultSet.getArray(columnIndex);
                } else if (mapClass.equals(BigDecimal.class)) {
                    columnValue = resultSet.getBigDecimal(columnIndex);
                } else if (mapClass.equals(InputStream.class)) {
                    columnValue = resultSet.getBinaryStream(columnIndex);
                } else if (mapClass.equals(Blob.class)) {
                    columnValue = resultSet.getBlob(columnIndex);
                } else if (mapClass.equals(Boolean.class)) {
                    columnValue = resultSet.getBoolean(columnIndex);
                } else if (mapClass.equals(Byte.class)) {
                    columnValue = resultSet.getByte(columnIndex);
                    if (Byte.valueOf((byte)0).equals(columnValue) && resultSet.wasNull()) {
                        columnValue = null;
                    }
                } else if (mapClass.equals(byte[].class)) {
                    columnValue = resultSet.getBytes(columnIndex);
                } else if (mapClass.equals(Reader.class)) {
                    columnValue = resultSet.getCharacterStream(columnIndex);
                } else if (mapClass.equals(Clob.class)) {
                    columnValue = resultSet.getClob(columnIndex);
                } else if (mapClass.equals(Date.class)) {
                    columnValue = resultSet.getDate(columnIndex);
                } else if (mapClass.equals(Double.class)) {
                    columnValue = resultSet.getDouble(columnIndex);
                    if (Double.valueOf(0.0).equals(columnValue) && resultSet.wasNull()) {
                        columnValue = null;
                    }
                } else if (mapClass.equals(Float.class)) {
                    columnValue = Float.valueOf(resultSet.getFloat(columnIndex));
                    if (Float.valueOf(0.0f).equals(columnValue) && resultSet.wasNull()) {
                        columnValue = null;
                    }
                } else if (mapClass.equals(Integer.class)) {
                    columnValue = resultSet.getInt(columnIndex);
                    if (Integer.valueOf(0).equals(columnValue) && resultSet.wasNull()) {
                        columnValue = null;
                    }
                } else if (mapClass.equals(Long.class)) {
                    columnValue = resultSet.getLong(columnIndex);
                    if (Long.valueOf(0L).equals(columnValue) && resultSet.wasNull()) {
                        columnValue = null;
                    }
                } else if (mapClass.equals(Object.class)) {
                    columnValue = resultSet.getObject(columnIndex);
                } else if (mapClass.equals(Ref.class)) {
                    columnValue = resultSet.getRef(columnIndex);
                } else if (mapClass.equals(Short.class)) {
                    columnValue = resultSet.getShort(columnIndex);
                    if (Short.valueOf((short)0).equals(columnValue) && resultSet.wasNull()) {
                        columnValue = null;
                    }
                } else if (mapClass.equals(String.class)) {
                    columnValue = resultSet.getString(columnIndex);
                } else if (mapClass.equals(Time.class)) {
                    columnValue = resultSet.getTime(columnIndex);
                } else if (mapClass.equals(Timestamp.class)) {
                    columnValue = resultSet.getTimestamp(columnIndex);
                } else if (mapClass.equals(URL.class)) {
                    columnValue = resultSet.getURL(columnIndex);
                } else {
                    throw new IllegalArgumentException("Unknown convertClass " + mapClass.getName() + " at position " + i);
                }
                result.add(columnValue);
            }
            return result;
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
    }
}

