/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.outlet.JavaOutletSaxHandlerFactory;
import org.apache.torque.generator.configuration.outlet.ReflectionOutletSaxHandlerFactory;
import org.apache.torque.generator.configuration.outlet.TypedOutletSaxHandlerFactory;
import org.apache.torque.generator.configuration.outlet.UntypedOutletSaxHandlerFactory;
import org.apache.torque.generator.configuration.outlet.VelocityOutletSaxHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutletTypes {
    private Map<String, TypedOutletSaxHandlerFactory> typedOutletHandlerFactories = new HashMap<String, TypedOutletSaxHandlerFactory>();
    private List<UntypedOutletSaxHandlerFactory> untypedOutletHandlerFactories = new ArrayList<UntypedOutletSaxHandlerFactory>();

    public OutletTypes() {
        try {
            this.registerTypedOutletHandlerFactory(new VelocityOutletSaxHandlerFactory());
            this.registerTypedOutletHandlerFactory(new JavaOutletSaxHandlerFactory());
            this.registerUntypedOutletHandlerFactory(new ReflectionOutletSaxHandlerFactory());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerTypedOutletHandlerFactory(TypedOutletSaxHandlerFactory factory) throws ConfigurationException {
        if (factory == null) {
            throw new NullPointerException("factory must not be null");
        }
        String type = factory.getType();
        TypedOutletSaxHandlerFactory oldFactory = this.typedOutletHandlerFactories.get(type);
        if (oldFactory != null) {
            throw new ConfigurationException("Attempted to register a OutletSaxHandlerFactory of type " + factory.getType() + " and class " + factory.getClass().getName() + " : A factory with this type already exists, " + " it has the class " + oldFactory.getClass().getName());
        }
        this.typedOutletHandlerFactories.put(factory.getType(), factory);
    }

    public void registerUntypedOutletHandlerFactory(UntypedOutletSaxHandlerFactory factory) throws ConfigurationException {
        if (factory == null) {
            throw new NullPointerException("factory must not be null");
        }
        this.untypedOutletHandlerFactories.add(factory);
    }

    public Map<String, TypedOutletSaxHandlerFactory> getTypedOutletHandlerFactories() {
        return Collections.unmodifiableMap(this.typedOutletHandlerFactories);
    }

    public List<UntypedOutletSaxHandlerFactory> getUntypedOutletHandlerFactories() {
        return Collections.unmodifiableList(this.untypedOutletHandlerFactories);
    }
}

