/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.source;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EntityReferenceSaxHandler
extends DefaultHandler {
    private String systemId;
    private String resource;
    private ConfigurationProvider configurationProvider;

    public EntityReferenceSaxHandler(ConfigurationProvider configurationProvider, ProjectPaths projectPaths) {
        if (configurationProvider == null) {
            throw new NullPointerException("configurationProvider must not be null");
        }
        if (projectPaths == null) {
            throw new NullPointerException("projectPaths must not be null");
        }
        this.configurationProvider = configurationProvider;
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        if (rawName.equals("entityReference")) {
            this.resource = attributes.getValue("resource");
            if (this.resource == null) {
                throw new SAXException("The attribute resource must not be null for the element entityReference");
            }
            this.systemId = attributes.getValue("systemId");
            if (this.systemId == null) {
                throw new SAXException("The attribute systemId must not be null for the element entityReference");
            }
        } else {
            throw new SAXException("Unknown element " + rawName);
        }
    }

    public String getResource() {
        return this.resource;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public boolean isFinished() {
        return this.systemId != null;
    }

    public byte[] readResource() throws ConfigurationException {
        byte[] content;
        InputStream inputStream = this.configurationProvider.getResourceInputStream(this.resource);
        try {
            content = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not read Stream from resource path " + this.resource, e);
        }
        return content;
    }
}

