/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RolesTest
extends BaseJDBCTestCase {
    private final int _authLevel;
    private final String _user;
    private final String _userPassword;
    private Connection _conn;
    private Statement _stm;
    private static final int NO_SQLAUTHORIZATION = 0;
    private static final int SQLAUTHORIZATION = 1;
    private static final String pwSuffix = "pwSuffix";
    private static final String sqlAuthorizationRequired = "42Z60";
    private static final String syntaxError = "42X01";
    private static final String roleDboOnly = "4251A";
    private static final String invalidRole = "0P000";
    private static final String tooLongId = "42622";
    private static final String revokeWarn = "01007";
    private static final String notIdle = "25001";
    private static final String invalidRoleName = "4293A";
    private static final String userException = "38000";
    private static final String objectAlreadyExists = "X0Y68";
    private static final String invalidPUBLIC = "4251B";
    private static final String loginFailed = "08004";
    private static final String roleGrantCircularity = "4251C";
    private static final String idParseError = "XCXA0";
    private int MAX_IDENTIFIER_LENGTH = 128;
    private static final String[] users = new String[]{"TEST_DBO", "DonaldDuck", "\"additional\"\"user\""};
    private static final int dboIndex = 0;
    private static final int nonDboIndex = 1;
    private static final int additionaluserIndex = 2;

    private boolean isDbo() {
        return users[0].equals(this._user);
    }

    public RolesTest(String name, int authLevel, String user, String userPassword) {
        super(name);
        this._authLevel = authLevel;
        this._user = user;
        this._userPassword = userPassword;
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("RolesTest");
        suite.addTest(RolesTest.negativeSyntaxSuite("suite: negative syntax, embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(RolesTest.negativeSyntaxSuite("suite: negative syntax, client")));
        suite.addTest(RolesTest.positiveSyntaxSuite("suite: positive syntax, embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(RolesTest.positiveSyntaxSuite("suite: positive syntax, client")));
        suite.addTest(RolesTest.semanticSuite("suite: semantic, embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(RolesTest.semanticSuite("suite: semantic, client")));
        return suite;
    }

    private static Test negativeSyntaxSuite(String framework) {
        BaseTestSuite suite = new BaseTestSuite("roles:" + framework);
        BaseTestSuite noauthSuite = new BaseTestSuite("suite: security level=noSqlAuthorization");
        noauthSuite.addTest((Test)new RolesTest("testNegativeSyntax", 0, null, null));
        suite.addTest((Test)noauthSuite);
        suite.addTest(RolesTest.wrapInAuthorization("testNegativeSyntax"));
        return suite;
    }

    private static Test positiveSyntaxSuite(String framework) {
        String dbo = users[0];
        String dbopw = dbo.concat(pwSuffix);
        Test t = TestConfiguration.changeUserDecorator((Test)new RolesTest("testPositiveSyntax", 1, dbo, dbopw), dbo, dbopw);
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication(t, users, pwSuffix));
    }

    public void testNegativeSyntax() throws SQLException {
        RolesTest.println("testNegativeSyntax: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this._conn = this.getConnection();
        this._stm = this._conn.createStatement();
        this.doStmt("create role none", syntaxError, syntaxError, syntaxError);
        this.doStmt("create role current_role", syntaxError, syntaxError, syntaxError);
        char[] longname = new char[this.MAX_IDENTIFIER_LENGTH + 1];
        Arrays.fill(longname, 'a');
        String nameWithMoreThanMaxChars = new String(longname);
        this.doStmt("create role " + nameWithMoreThanMaxChars, tooLongId, tooLongId, tooLongId);
        this.doStmt("create role sysrole", sqlAuthorizationRequired, invalidRoleName, invalidRoleName);
        this.doStmt("create role \"SYSROLE\"", sqlAuthorizationRequired, invalidRoleName, invalidRoleName);
        this.doStmt("create role public", syntaxError, syntaxError, syntaxError);
        this.doStmt("create role \"PUBLIC\"", sqlAuthorizationRequired, invalidPUBLIC, roleDboOnly);
        this.doStmt("grant \"PUBLIC\" to " + users[1], sqlAuthorizationRequired, invalidPUBLIC, invalidPUBLIC);
        this.doStmt("revoke \"PUBLIC\" from " + users[1], sqlAuthorizationRequired, invalidPUBLIC, invalidPUBLIC);
        this._stm.close();
    }

    public void testPositiveSyntax() throws SQLException {
        RolesTest.println("testPositiveSyntax");
        String n_a = null;
        int n_a_cnt = -1;
        if (!this.isDbo()) {
            throw new SQLException("test error");
        }
        this._conn = this.getConnection();
        this._stm = this._conn.createStatement();
        this.doStmt("create role trigger", n_a, null, n_a);
        this.doStmt("create role role", n_a, null, n_a);
        String nameWithMoreThan30Chars = "r123456789012345678901234567890";
        this.doStmt("create role " + nameWithMoreThan30Chars, n_a, null, n_a);
        this.assertSysRolesRowCount(n_a_cnt, 3, n_a_cnt);
        this.doStmt("grant trigger to foo", n_a, null, n_a);
        this.doStmt("grant role to foo", n_a, null, n_a);
        this.doStmt("revoke trigger from foo", n_a, null, n_a);
        this.doStmt("revoke role from foo", n_a, null, n_a);
        this.doStmt("set role " + nameWithMoreThan30Chars, n_a, null, n_a);
        this.doStmt("create table mytab(i int)", n_a, null, n_a);
        this.doStmt("grant select on mytab to " + nameWithMoreThan30Chars, n_a, null, n_a);
        this.doStmt("revoke select on mytab from " + nameWithMoreThan30Chars, n_a, null, n_a);
        this.doStmt("drop table mytab", n_a, null, n_a);
        this.doStmt("drop role trigger", n_a, null, n_a);
        this.doStmt("drop role role", n_a, null, n_a);
        this.doStmt("drop role " + nameWithMoreThan30Chars, n_a, null, n_a);
        this.assertSysRolesRowCount(n_a_cnt, 0, n_a_cnt);
        this._stm.close();
    }

    private static Test semanticSuite(String framework) {
        BaseTestSuite noauthSuite = new BaseTestSuite("suite: security level=noSqlAuthorization");
        noauthSuite.addTest((Test)new RolesTest("testSemantics", 0, null, null));
        BaseTestSuite suite = new BaseTestSuite("roles:" + framework);
        suite.addTest((Test)noauthSuite);
        suite.addTest(RolesTest.wrapInAuthorization("testSemantics"));
        return suite;
    }

    private static Test wrapInAuthorization(String testName) {
        BaseTestSuite usersSuite = new BaseTestSuite("suite: security level=sqlAuthorization");
        for (int userNo = 0; userNo <= users.length - 2; ++userNo) {
            usersSuite.addTest(TestConfiguration.changeUserDecorator((Test)new RolesTest(testName, 1, users[userNo], users[userNo].concat(pwSuffix)), users[userNo], users[userNo].concat(pwSuffix)));
        }
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication((Test)usersSuite, users, pwSuffix));
    }

    public void testSemantics() throws SQLException {
        RolesTest.println("testSemantics: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this._conn = this.getConnection();
        this._stm = this._conn.createStatement();
        this.doStmt("create role foo", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("create role bar", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("create role notGranted", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("create role role", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("create role admin", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("create role \"NONE\"", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("create role foo", sqlAuthorizationRequired, objectAlreadyExists, roleDboOnly);
        this.doStmt("create role " + users[0], sqlAuthorizationRequired, objectAlreadyExists, roleDboOnly);
        this.doStmt("create role " + users[1], sqlAuthorizationRequired, objectAlreadyExists, roleDboOnly);
        this.doStmt("create role " + users[2], sqlAuthorizationRequired, objectAlreadyExists, roleDboOnly);
        this.doStmt("create role whoever", sqlAuthorizationRequired, objectAlreadyExists, roleDboOnly);
        this.doStmt("create role schemaowner", sqlAuthorizationRequired, objectAlreadyExists, roleDboOnly);
        this.testLoginWithUsernameWhichIsARole();
        this.doStmt("grant foo to authid", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("grant foo, role, bar to authid1, authid2, " + users[1], sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("grant admin to authid", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("grant admin, foo to authid", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("grant admin, foo to public", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("grant admin to a,b,c", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("grant foo,bar to admin", sqlAuthorizationRequired, null, roleDboOnly);
        this.assertSysRolesRowCount(0, 24, 5);
        this.checkGrantCircularity();
        this.doStmt("set role foo", sqlAuthorizationRequired, null, null);
        this.doStmt("set role 'FOO'", sqlAuthorizationRequired, null, null);
        this.doStmt("set role none", sqlAuthorizationRequired, null, null);
        this.doDynamicSetRole(this._conn);
        this.doStmt("set role 'NONE'", sqlAuthorizationRequired, idParseError, idParseError);
        this.doStmt("set role 'none'", sqlAuthorizationRequired, idParseError, idParseError);
        this.doStmt("set role '\"NONE\"'", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("set role ' '", sqlAuthorizationRequired, idParseError, idParseError);
        this.doStmt("set role bar", sqlAuthorizationRequired, null, null);
        this.doStmt("set role notGranted", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("set role role", sqlAuthorizationRequired, null, invalidRole);
        this._conn.setAutoCommit(false);
        this.doStmt("select * from SYS.SYSROLES", null, null, null);
        this.doStmt("set role role", sqlAuthorizationRequired, notIdle, notIdle);
        this._conn.commit();
        this._conn.setAutoCommit(true);
        ResultSet rs = this.doQuery("values current_role", sqlAuthorizationRequired, null, null);
        this.assertRoleInRs(rs, "\"ROLE\"", "\"BAR\"");
        if (rs != null) {
            rs.close();
        }
        this.doStmt("revoke foo from authid", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("revoke foo, role, bar from authid1, authid2", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("revoke foo, role from " + users[1], sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("revoke admin from authid", sqlAuthorizationRequired, null, invalidRole);
        this.doStmtWithWarnings("revoke admin from authid", new String[]{sqlAuthorizationRequired, null}, new String[]{null, revokeWarn}, new String[]{invalidRole, null}, false);
        this.doStmt("revoke admin, foo from authid", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("revoke admin from public", sqlAuthorizationRequired, null, invalidRole);
        this.doStmt("create table foo(str varchar(128) default current_role)", sqlAuthorizationRequired, null, null);
        this.doStmt("grant select, insert on foo to admin", sqlAuthorizationRequired, null, null);
        this.doStmt("grant select (str), update (str) on foo to admin", sqlAuthorizationRequired, null, null);
        this.doStmt("create function f1() returns int  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.RolesTest.f1'  no sql called on null input", null, null, null);
        this.doStmt("grant execute on function f1 to admin", sqlAuthorizationRequired, null, null);
        this.assertSysTablePermsRowCount(0, 2, 1);
        this.assertSysColPermsRowCount(0, 2, 2);
        this.assertSysRoutinePermsRowCount(11, 12, 12);
        this.doStmt("drop role role", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("drop role admin", sqlAuthorizationRequired, null, roleDboOnly);
        this.assertSysTablePermsRowCount(0, 1, 1);
        this.assertSysColPermsRowCount(0, 0, 2);
        this.assertSysRoutinePermsRowCount(11, 11, 12);
        this.doStmt("drop role \"NONE\"", sqlAuthorizationRequired, null, roleDboOnly);
        this.doStmt("revoke select, insert on foo from admin", sqlAuthorizationRequired, null, null);
        this.doStmt("revoke select (str), update (str) on foo from admin", sqlAuthorizationRequired, null, null);
        this.doStmt("revoke execute on function f1 from admin restrict", sqlAuthorizationRequired, null, null);
        this.assertSysTablePermsRowCount(0, 1, 0);
        this.assertSysColPermsRowCount(0, 0, 0);
        this.assertSysRoutinePermsRowCount(11, 11, 11);
        this.assertSysRolesRowCount(0, 5, 5);
        this._stm.close();
        if (!JDBC.vmSupportsJSR169()) {
            this.testCurrentRoleIsReset();
        }
    }

    private void testLoginWithUsernameWhichIsARole() throws SQLException {
        if (this._authLevel == 1 && this.isDbo()) {
            this._stm.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.user.soonarole', 'whatever')");
            this.openDefaultConnection("soonarole", "whatever").close();
            this._stm.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.user.soonarole', NULL)");
            this._stm.execute("create role soonarole");
            this._stm.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.user.soonarole', 'whatever')");
            try {
                this.openDefaultConnection("soonarole", "whatever").close();
                RolesTest.fail((String)"Exception expected connecting with user name equal to a role");
            }
            catch (SQLException e) {
                RolesTest.assertSQLState(loginFailed, e);
            }
            this._stm.execute("drop role soonarole");
            this._stm.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.user.soonarole', NULL)");
        }
    }

    private void testCurrentRoleIsReset() throws SQLException {
        if (this._authLevel == 1 && this.isDbo()) {
            String user = "DonaldDuck";
            String passwd = "DonaldDuck".concat(pwSuffix);
            ConnectionPoolDataSource cpDs = J2EEDataSource.getConnectionPoolDataSource();
            this.doTestCurrentRoleIsReset(cpDs.getPooledConnection("DonaldDuck", passwd), "DonaldDuck");
            if (RolesTest.usingDerbyNetClient()) {
                J2EEDataSource.setBeanProperty(cpDs, "maxStatements", 7);
                this.doTestCurrentRoleIsReset(cpDs.getPooledConnection("DonaldDuck", passwd), "DonaldDuck");
            }
        }
    }

    private void doTestCurrentRoleIsReset(PooledConnection pc, String user) throws SQLException {
        Connection con = pc.getConnection();
        Statement stmt = con.createStatement();
        String n_a = null;
        JDBC.assertCurrentSchema(con, user.toUpperCase());
        stmt.execute("set role bar");
        ResultSet rs = stmt.executeQuery("values current_role");
        this.assertRoleInRs(rs, "\"BAR\"", n_a);
        rs.close();
        stmt.close();
        con.close();
        con = pc.getConnection();
        stmt = con.createStatement();
        rs = stmt.executeQuery("values current_role");
        this.assertRoleInRs(rs, null, n_a);
        rs.close();
        stmt.close();
        con.close();
    }

    private void checkGrantCircularity() {
        if (this.isDbo()) {
            int i;
            String NA = null;
            for (i = 1; i <= 8; ++i) {
                this.doStmt("create role s" + i, NA, null, NA);
            }
            this.doStmt("grant s1 to s2", NA, null, NA);
            this.doStmt("grant s3 to s1", NA, null, NA);
            this.doStmt("grant s1 to s4", NA, null, NA);
            this.doStmt("grant s4 to s2", NA, null, NA);
            this.doStmt("grant s4 to s6", NA, null, NA);
            this.doStmt("grant s4 to s5", NA, null, NA);
            this.doStmt("grant s6 to s7", NA, null, NA);
            this.doStmt("grant s8 to s4", NA, null, NA);
            this.doStmt("grant s1 to s1", NA, roleGrantCircularity, NA);
            this.doStmt("grant s2 to s3", NA, roleGrantCircularity, NA);
            this.doStmt("grant s2 to s8", NA, roleGrantCircularity, NA);
            this.doStmt("grant s7 to s1", NA, roleGrantCircularity, NA);
            this.doStmt("grant s7 to s4", NA, roleGrantCircularity, NA);
            this.doStmt("grant s7 to s6", NA, roleGrantCircularity, NA);
            this.doStmt("grant s7 to s3", NA, roleGrantCircularity, NA);
            this.doStmt("grant s2 to s1", NA, roleGrantCircularity, NA);
            this.doStmt("grant s2 to s8", NA, roleGrantCircularity, NA);
            this.doStmt("grant s2 to s4", NA, roleGrantCircularity, NA);
            this.doStmt("grant s6 to s1", NA, roleGrantCircularity, NA);
            this.doStmt("grant s6 to s8", NA, roleGrantCircularity, NA);
            this.doStmt("grant s6 to s3", NA, roleGrantCircularity, NA);
            this.doStmt("grant s6 to s4", NA, roleGrantCircularity, NA);
            this.doStmt("grant s5 to s1", NA, roleGrantCircularity, NA);
            this.doStmt("grant s5 to s3", NA, roleGrantCircularity, NA);
            this.doStmt("grant s5 to s4", NA, roleGrantCircularity, NA);
            this.doStmt("grant s5 to s8", NA, roleGrantCircularity, NA);
            for (i = 1; i <= 8; ++i) {
                this.doStmt("drop role s" + i, NA, null, NA);
            }
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._stm = this.createStatement();
        if (this._authLevel == 1 && this.isDbo()) {
            try {
                this._stm.executeUpdate("drop role foo");
                this._stm.executeUpdate("drop role bar");
                this._stm.executeUpdate("drop role notGranted");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            this._stm.executeUpdate("drop function f1");
            this._stm.executeUpdate("drop table foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this._authLevel == 1 && this.isDbo()) {
            this._stm.executeUpdate("create table t1(i int)");
            this._stm.executeUpdate("grant select on t1 to whoever");
            this._stm.executeUpdate("create schema lingerSchema authorization schemaowner");
        }
        this._stm.close();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this._authLevel == 1 && this.isDbo()) {
            this._stm = this.createStatement();
            try {
                this._stm.executeUpdate("revoke select on t1 from whoever");
                this._stm.executeUpdate("drop table t1");
                this._stm.executeUpdate("drop schema lingerSchema restrict");
            }
            catch (SQLException se) {
                System.err.println("Test error + " + String.valueOf(se));
            }
        }
        if (this._stm != null) {
            this._stm.close();
            this._stm = null;
        }
        if (this._conn != null) {
            this._conn = null;
        }
        super.tearDown();
    }

    private void doStmt(String stmt, String noAuthState, String authDboState, String authNotDboState) {
        this.doStmt(stmt, noAuthState, authDboState, authNotDboState, false);
    }

    private ResultSet doQuery(String stmt, String noAuthState, String authDboState, String authNotDboState) {
        return this.doStmt(stmt, noAuthState, authDboState, authNotDboState, true);
    }

    private ResultSet doStmt(String stmt, String noAuthState, String authDboState, String authNotDboState, boolean query) {
        return this.doStmtWithWarnings(stmt, new String[]{noAuthState, null}, new String[]{authDboState, null}, new String[]{authNotDboState, null}, query);
    }

    private ResultSet doStmtWithWarnings(String stmt, String[] noAuthState, String[] authDboState, String[] authNotDboState, boolean query) {
        ResultSet result = null;
        try {
            if (query) {
                result = this._stm.executeQuery(stmt);
            } else {
                this._stm.execute(stmt);
            }
            if (this._authLevel == 0) {
                if (noAuthState[0] != null) {
                    RolesTest.fail((String)("exception " + noAuthState[0] + " expected: (" + stmt));
                }
                if (noAuthState[1] != null) {
                    SQLWarning w = this._stm.getWarnings();
                    RolesTest.assertNotNull((String)"Expected warning but found none", (Object)w);
                    RolesTest.assertSQLState(noAuthState[1], w);
                }
            } else if (this.isDbo()) {
                if (authDboState[0] != null) {
                    RolesTest.fail((String)("exception " + authDboState[0] + " expected: (" + stmt));
                }
                if (authDboState[1] != null) {
                    SQLWarning w = this._stm.getWarnings();
                    RolesTest.assertNotNull((String)"Expected warning but found none", (Object)w);
                    RolesTest.assertSQLState(authDboState[1], w);
                }
            } else {
                if (authNotDboState[0] != null) {
                    RolesTest.fail((String)("exception " + authNotDboState[0] + " expected: (" + stmt));
                }
                if (authNotDboState[1] != null) {
                    SQLWarning w = this._stm.getWarnings();
                    RolesTest.assertNotNull((String)"Expected warning but found none", (Object)w);
                    RolesTest.assertSQLState(authNotDboState[1], w);
                }
            }
        }
        catch (SQLException e) {
            if (this._authLevel == 0) {
                if (noAuthState[0] == null) {
                    RolesTest.fail("stmt " + stmt + " failed with exception " + e.getSQLState(), e);
                } else {
                    RolesTest.assertSQLState("Stmt " + stmt, noAuthState[0], e);
                }
            }
            if (this.isDbo()) {
                if (authDboState[0] == null) {
                    RolesTest.fail("stmt " + stmt + " failed with exception " + e.getSQLState(), e);
                } else {
                    RolesTest.assertSQLState("Stmt " + stmt, authDboState[0], e);
                }
            }
            if (authNotDboState[0] == null) {
                RolesTest.fail("stmt " + stmt + " failed with exception " + e.getSQLState(), e);
            }
            RolesTest.assertSQLState("Stmt " + stmt, authNotDboState[0], e);
        }
        return result;
    }

    private void doDynamicSetRole(Connection conn) {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("set role ?");
            if (this._authLevel == 0) {
                RolesTest.fail((String)"set role ? should have failed; no sqlAuthorization");
            }
        }
        catch (SQLException e) {
            if (this._authLevel == 0) {
                RolesTest.assertSQLState(sqlAuthorizationRequired, e);
                return;
            }
            RolesTest.fail("prepare of set role ? failed:" + String.valueOf(e), e);
        }
        try {
            pstmt.setString(1, "BAR");
            int rowcnt = pstmt.executeUpdate();
            RolesTest.assertEquals((String)"rowcount from set role ? not 0", (int)rowcnt, (int)0);
        }
        catch (SQLException e) {
            RolesTest.fail("execute of set role ? failed: [foo]" + String.valueOf(e), e);
        }
        try {
            pstmt.setString(1, " BAR ");
            int rowcnt = pstmt.executeUpdate();
            RolesTest.assertEquals((String)"rowcount from set role ? not 0", (int)rowcnt, (int)0);
        }
        catch (SQLException e) {
            RolesTest.fail("execute of set role ? failed: [foo]" + String.valueOf(e), e);
        }
        try {
            int rowcnt = conn.createStatement().executeUpdate("set role ' BAR '");
            RolesTest.assertEquals((String)"rowcount from set role ? not 0", (int)rowcnt, (int)0);
        }
        catch (SQLException e) {
            RolesTest.fail("execute of set role ? failed: [foo]" + String.valueOf(e), e);
        }
        try {
            pstmt.setString(1, "");
            int rowcnt = pstmt.executeUpdate();
            RolesTest.fail((String)"Expected syntax error on identifier");
        }
        catch (SQLException e) {
            RolesTest.assertSQLState(idParseError, e);
        }
        try {
            pstmt.setString(1, " ");
            int rowcnt = pstmt.executeUpdate();
            RolesTest.fail((String)"Expected syntax error on identifier");
        }
        catch (SQLException e) {
            RolesTest.assertSQLState(idParseError, e);
        }
        try {
            pstmt.setString(1, null);
            int rowcnt = pstmt.executeUpdate();
            RolesTest.fail((String)"Expected syntax error on identifier");
        }
        catch (SQLException e) {
            RolesTest.assertSQLState(idParseError, e);
        }
        if (this.isDbo()) {
            int rowcnt;
            String n_a = null;
            try {
                pstmt.setString(1, "NONE");
                rowcnt = pstmt.executeUpdate();
                RolesTest.fail((String)"NONE should not be allowed as a dynamic parameter");
            }
            catch (SQLException e) {
                RolesTest.assertSQLState(idParseError, e);
            }
            try {
                pstmt.setString(1, "none");
                rowcnt = pstmt.executeUpdate();
                RolesTest.fail((String)"NONE should not be allowed as a dynamic parameter");
            }
            catch (SQLException e) {
                RolesTest.assertSQLState(idParseError, e);
            }
            try {
                pstmt.setString(1, "\"NONE\"");
                int rowcnt2 = pstmt.executeUpdate();
                RolesTest.assertEquals((String)"rowcount from set role ? not 0", (int)rowcnt2, (int)0);
                ResultSet rs = this.doQuery("values current_role", n_a, null, n_a);
                this.assertRoleInRs(rs, "\"NONE\"", n_a);
                rs.close();
            }
            catch (SQLException e) {
                RolesTest.fail("execute of set role ? failed: [\"NONE\"] " + String.valueOf(e), e);
            }
        }
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void assertSystableRowCount(String table, int rcNoAuth, int rcDbo, int rcMereMortal) throws SQLException {
        ResultSet rs = this._stm.executeQuery("SELECT COUNT(*) FROM " + table);
        rs.next();
        RolesTest.assertEquals((String)(table + " (_authLevel == NO_SQLAUTHORIZATION) = " + (this._authLevel == 0) + ", isDbo() = " + this.isDbo() + ", row count:"), (int)(this._authLevel == 0 ? rcNoAuth : (this.isDbo() ? rcDbo : rcMereMortal)), (int)rs.getInt(1));
        rs.close();
    }

    private void assertSysRolesRowCount(int rcNoAuth, int rcDbo, int rcMereMortal) throws SQLException {
        if (TestConfiguration.getCurrent().isVerbose()) {
            this.dumpSysRoles();
        }
        this.assertSystableRowCount("SYS.SYSROLES", rcNoAuth, rcDbo, rcMereMortal);
    }

    private void assertSysTablePermsRowCount(int rcNoAuth, int rcDbo, int rcMereMortal) throws SQLException {
        if (TestConfiguration.getCurrent().isVerbose()) {
            this.dumpSysTablePerms();
        }
        this.assertSystableRowCount("SYS.SYSTABLEPERMS", rcNoAuth, rcDbo, rcMereMortal);
    }

    private void assertSysColPermsRowCount(int rcNoAuth, int rcDbo, int rcMereMortal) throws SQLException {
        if (TestConfiguration.getCurrent().isVerbose()) {
            this.dumpSysColPerms();
        }
        this.assertSystableRowCount("SYS.SYSCOLPERMS", rcNoAuth, rcDbo, rcMereMortal);
    }

    private void assertSysRoutinePermsRowCount(int rcNoAuth, int rcDbo, int rcMereMortal) throws SQLException {
        if (TestConfiguration.getCurrent().isVerbose()) {
            this.dumpSysRoutinePerms();
        }
        this.assertSystableRowCount("SYS.SYSROUTINEPERMS", rcNoAuth, rcDbo, rcMereMortal);
    }

    private void dumpSysRoles() throws SQLException {
        ResultSet rs = this._stm.executeQuery("SELECT * FROM SYS.SYSROLES ORDER BY ROLEID");
        RolesTest.println("SYS.SYSROLES:");
        while (rs.next()) {
            RolesTest.println("uuid=" + rs.getString(1) + " r=" + rs.getString(2) + " -ee:" + rs.getString(3) + " -or:" + rs.getString(4) + " a:" + rs.getString(5) + " d:" + rs.getString(6));
        }
        rs.close();
    }

    private void dumpSysTablePerms() throws SQLException {
        ResultSet rs = this._stm.executeQuery("SELECT * FROM SYS.SYSTABLEPERMS");
        RolesTest.println("SYS.SYSTABLEPERMS:");
        while (rs.next()) {
            RolesTest.println("id: " + rs.getString(1) + " -ee:" + rs.getString(2) + " -or:" + rs.getString(3) + " tableid:" + rs.getString(4) + " S:" + rs.getString(5) + " D:" + rs.getString(6) + " I:" + rs.getString(7) + " U:" + rs.getString(8) + " R:" + rs.getString(9) + " T:" + rs.getString(10));
        }
        rs.close();
    }

    private void dumpSysColPerms() throws SQLException {
        ResultSet rs = this._stm.executeQuery("SELECT * FROM SYS.SYSCOLPERMS");
        RolesTest.println("SYS.SYSCOLPERMS:");
        while (rs.next()) {
            RolesTest.println("id: " + rs.getString(1) + " -ee:" + rs.getString(2) + " -or:" + rs.getString(3) + " tableid:" + rs.getString(4) + " type:" + rs.getString(5) + " col#:" + rs.getString(6));
        }
        rs.close();
    }

    private void dumpSysRoutinePerms() throws SQLException {
        ResultSet rs = this._stm.executeQuery("SELECT * FROM SYS.SYSROUTINEPERMS");
        RolesTest.println("SYS.SYSROUTINEPERMS:");
        while (rs.next()) {
            RolesTest.println("id: " + rs.getString(1) + " -ee:" + rs.getString(2) + " -or:" + rs.getString(3) + " alias:" + rs.getString(4) + " grantopt:" + rs.getString(5));
        }
        rs.close();
    }

    private void assertRoleInRs(ResultSet rs, String dboRole, String notDboRole) throws SQLException {
        if (this._authLevel == 0) {
            RolesTest.assertNull((Object)rs);
        } else if (this.isDbo()) {
            JDBC.assertSingleValueResultSet(rs, dboRole);
        } else {
            JDBC.assertSingleValueResultSet(rs, notDboRole);
        }
    }

    public static int f1() {
        return 1;
    }
}

