/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;

public class PrivilegedFileOpsForTests {
    public static long length(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return file.length();
            }
        });
    }

    public static String getAbsolutePath(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() throws SecurityException {
                return file.getAbsolutePath();
            }
        });
    }

    public static URI toURI(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return AccessController.doPrivileged(new PrivilegedAction<URI>(){

            @Override
            public URI run() throws SecurityException {
                return file.toURI();
            }
        });
    }

    public static File createTempFile(final String string, final String string2, final File file) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    return File.createTempFile(string, string2, file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
    }

    public static boolean exists(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }

    public static boolean delete(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.delete();
            }
        });
    }

    public static boolean mkdir(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.mkdir();
            }
        });
    }

    public static boolean setReadable(final File file, final boolean bl, final boolean bl2) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.setReadable(bl, bl2);
            }
        });
    }

    public static boolean setReadOnly(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.setReadOnly();
            }
        });
    }

    public static FileReader getFileReader(final File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileReader>(){

                @Override
                public FileReader run() throws FileNotFoundException {
                    return new FileReader(file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getCause();
        }
    }

    public static FileWriter getFileWriter(final File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileWriter>(){

                @Override
                public FileWriter run() throws IOException {
                    return new FileWriter(file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static File[] listFiles(File file) {
        return AccessController.doPrivileged(() -> file.listFiles());
    }

    public static void copy(final File file, final File file2) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    PrivilegedFileOpsForTests.recursiveCopy(file, file2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private static void recursiveCopy(File file, File file2) throws IOException {
        byte[] byArray = new byte[32768];
        if (file.isFile()) {
            PrivilegedFileOpsForTests.copySingleFile(file, file2, byArray);
            return;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(file, stringArray[i]);
                File file4 = new File(file2, stringArray[i]);
                if (file3.isDirectory()) {
                    PrivilegedFileOpsForTests.copy(file3, file4);
                    continue;
                }
                PrivilegedFileOpsForTests.copySingleFile(file3, file4, byArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySingleFile(File file, File file2, byte[] byArray) throws IOException {
        File file3;
        if (byArray == null) {
            byArray = new byte[32768];
        }
        if ((file3 = file2.getParentFile()) != null && !file3.exists()) {
            file2.getParentFile().mkdirs();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            int n;
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static FileOutputStream getFileOutputStream(File file) throws FileNotFoundException {
        return PrivilegedFileOpsForTests.getFileOutputStream(file, false);
    }

    public static FileOutputStream getFileOutputStream(final File file, final boolean bl) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(file, bl);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getCause();
        }
    }

    public static File[] persistentRecursiveDelete(final File file) throws FileNotFoundException {
        if (!PrivilegedFileOpsForTests.exists(file)) {
            throw new FileNotFoundException(PrivilegedFileOpsForTests.getAbsolutePath(file));
        }
        final ArrayList arrayList = new ArrayList();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                PrivilegedFileOpsForTests.deleteRecursively(file, arrayList);
                return null;
            }
        });
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static boolean deleteRecursively(File file, List<File> list) {
        File[] fileArray;
        boolean bl = true;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    bl &= PrivilegedFileOpsForTests.deleteRecursively(file2, list);
                    continue;
                }
                bl &= PrivilegedFileOpsForTests.internalDelete(file2, list);
            }
        }
        return bl &= PrivilegedFileOpsForTests.internalDelete(file, list);
    }

    private static boolean internalDelete(File file, List<File> list) {
        boolean bl = file.delete();
        if (!bl) {
            list.add(file);
        }
        return bl;
    }

    public static String getFileInfo(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                if (!file.exists()) {
                    return "(non-existant)";
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("(isDir=").append(file.isDirectory()).append(", canRead=").append(file.canRead()).append(", canWrite=").append(file.canWrite()).append(", size=").append(file.length()).append(')');
                return stringBuilder.toString();
            }
        });
    }
}

