/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JDBCDataSource {
    public static DataSource getDataSource() {
        return JDBCDataSource.getDataSource(TestConfiguration.getCurrent(), null);
    }

    public static DataSource getDataSource(String string) {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", string);
        return dataSource;
    }

    public static DataSource getDataSourceLogical(String string) {
        DataSource dataSource = JDBCDataSource.getDataSource();
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        String string2 = testConfiguration.getPhysicalDatabaseName(string);
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", string2);
        return dataSource;
    }

    static DataSource getDataSource(TestConfiguration testConfiguration, HashMap hashMap) {
        return (DataSource)JDBCDataSource.getDataSource(testConfiguration, hashMap, testConfiguration.getJDBCClient().getDataSourceClassName());
    }

    static Object getDataSource(TestConfiguration testConfiguration, HashMap hashMap, String string) {
        if (hashMap == null) {
            hashMap = JDBCDataSource.getDataSourceProperties(testConfiguration);
        }
        return JDBCDataSource.getDataSourceObject(string, hashMap);
    }

    static HashMap<String, Object> getDataSourceProperties(TestConfiguration testConfiguration) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (!testConfiguration.getJDBCClient().isEmbedded()) {
            hashMap.put("serverName", testConfiguration.getHostName());
            hashMap.put("portNumber", testConfiguration.getPort());
        }
        hashMap.put("databaseName", testConfiguration.getDefaultDatabaseName());
        hashMap.put("user", testConfiguration.getUserName());
        hashMap.put("password", testConfiguration.getUserPassword());
        String string = testConfiguration.getConnectionAttributesString();
        if (string != null) {
            hashMap.put("connectionAttributes", string);
        }
        return hashMap;
    }

    static DataSource getDataSourceObject(String string, HashMap hashMap) {
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            Object object;
            DataSource dataSource = null;
            if (classLoader != null) {
                try {
                    object = Class.forName(string, true, classLoader);
                    dataSource = (DataSource)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (dataSource == null) {
                object = Class.forName(string);
                dataSource = (DataSource)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            for (String string2 : hashMap.keySet()) {
                Object v = hashMap.get(string2);
                JDBCDataSource.setBeanProperty(dataSource, string2, v);
            }
            if (!BaseTestCase.isJ9Platform() && !BaseTestCase.isCVM()) {
                dataSource.setLoginTimeout(TestConfiguration.getCurrent().getLoginTimeout());
            }
            return dataSource;
        }
        catch (Exception exception) {
            BaseTestCase.printStackTrace(exception);
            BaseTestCase.fail("unexpected error: " + exception.getMessage(), exception);
            return null;
        }
    }

    public static void setBeanProperty(Object object, String string, Object object2) {
        String string2 = JDBCDataSource.getSetterName(string);
        Class<Object> clazz = object2.getClass();
        if (Integer.class.equals(clazz)) {
            clazz = Integer.TYPE;
        } else if (Boolean.class.equals(clazz)) {
            clazz = Boolean.TYPE;
        } else if (Short.class.equals(clazz)) {
            clazz = Short.TYPE;
        }
        try {
            Method method = object.getClass().getMethod(string2, clazz);
            method.invoke(object, object2);
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public static Object getBeanProperty(Object object, String string) throws Exception {
        String string2 = JDBCDataSource.getGetterName(string);
        Method method = object.getClass().getMethod(string2, new Class[0]);
        return method.invoke(object, new Object[0]);
    }

    public static void clearStringBeanProperty(Object object, String string) {
        String string2 = JDBCDataSource.getSetterName(string);
        try {
            Method method = object.getClass().getMethod(string2, String.class);
            method.invoke(object, new Object[]{null});
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    private static String getSetterName(String string) {
        return "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private static String getGetterName(String string) {
        return "get" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static void shutdownDatabase(DataSource dataSource) {
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        try {
            dataSource.getConnection();
            Assert.fail((String)"Database failed to shut down");
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState("Database shutdown", "08006", sQLException);
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(dataSource, "shutdownDatabase");
        }
    }

    public static void shutEngine(DataSource dataSource) throws SQLException {
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", "");
        try {
            dataSource.getConnection();
            Assert.fail((String)"Engine failed to shut down");
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.assertSQLState("Engine shutdown", "XJ015", sQLException);
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(dataSource, "shutdownDatabase");
        }
    }
}

