/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util.streams;

import java.io.IOException;
import java.io.Reader;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;

public class LoopingAlphabetReader
extends Reader {
    private static final int MAX_BUF_SIZE = 32768;
    private static final int SPACE = 32;
    private final long length;
    private final int trailingBlanks;
    private long remainingNonBlanks;
    private long remainingBlanks;
    private char[] buffer = new char[0];
    private final CharAlphabet alphabet;
    private boolean closed = false;

    public LoopingAlphabetReader(long l) {
        this(l, 0);
    }

    public LoopingAlphabetReader(long l, int n) {
        this.length = l;
        this.trailingBlanks = n;
        this.remainingNonBlanks = l - (long)n;
        this.remainingBlanks = n;
        this.alphabet = CharAlphabet.modernLatinLowercase();
        this.fillBuffer(this.alphabet.charCount());
    }

    public LoopingAlphabetReader(long l, CharAlphabet charAlphabet) {
        this(l, charAlphabet, 0);
    }

    public LoopingAlphabetReader(long l, CharAlphabet charAlphabet, int n) {
        this.length = l;
        this.trailingBlanks = n;
        this.remainingNonBlanks = l - (long)n;
        this.remainingBlanks = n;
        this.alphabet = charAlphabet.getClone();
        this.fillBuffer(charAlphabet.charCount());
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.remainingBlanks <= 0L && this.remainingNonBlanks <= 0L) {
            return -1;
        }
        if (this.remainingNonBlanks <= 0L) {
            --this.remainingBlanks;
            return 32;
        }
        --this.remainingNonBlanks;
        return this.alphabet.nextCharAsInt();
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        this.ensureOpen();
        if (this.remainingBlanks <= 0L && this.remainingNonBlanks <= 0L) {
            return -1;
        }
        int n4 = Math.min((int)this.remainingNonBlanks, n2);
        this.fillBuffer(n4);
        int n5 = this.alphabet.nextCharToRead(0);
        if (n4 <= this.buffer.length - n5) {
            System.arraycopy(this.buffer, n5, cArray, n, n4);
            this.remainingNonBlanks -= (long)n4;
            n3 = n4;
            this.alphabet.nextCharToRead(n4);
        } else {
            int n6 = 0;
            for (n3 = 0; this.remainingNonBlanks > 0L && n3 < n4; n3 += n6) {
                n5 = this.alphabet.nextCharToRead(n6);
                n6 = Math.min(this.buffer.length - n5, n4 - n3);
                System.arraycopy(this.buffer, n5, cArray, n + n3, n6);
                this.remainingNonBlanks -= (long)n6;
            }
            n5 = this.alphabet.nextCharToRead(n6);
        }
        if (n3 < n2 && this.remainingBlanks > 0L) {
            n3 += this.fillBlanks(cArray, n + n3, n2 - n3);
        }
        return n3;
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        this.remainingNonBlanks = this.length - (long)this.trailingBlanks;
        this.remainingBlanks = this.trailingBlanks;
        this.alphabet.reset();
    }

    public int available() {
        return (int)(this.remainingNonBlanks + this.remainingBlanks);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private void fillBuffer(int n) {
        if (n > 32768) {
            n = 32768;
        }
        if (n <= this.buffer.length) {
            return;
        }
        int n2 = this.alphabet.nextCharToRead(0);
        this.alphabet.reset();
        this.buffer = new char[n];
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = this.alphabet.nextChar();
        }
        this.alphabet.reset();
        this.alphabet.nextCharToRead(n2);
    }

    private int fillBlanks(char[] cArray, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n2 && this.remainingBlanks > 0L; ++n3) {
            cArray[n + n3] = 32;
            --this.remainingBlanks;
        }
        return n3;
    }

    private final void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
    }
}

